/*
 * Decompiled with CFR 0.152.
 */
package com.fernferret.allpay.multiverse;

import ca.agnate.EconXP.EconXP;
import com.fernferret.allpay.multiverse.BOSEconomyBank;
import com.fernferret.allpay.multiverse.EconXPBank;
import com.fernferret.allpay.multiverse.EssentialsBank;
import com.fernferret.allpay.multiverse.FeconomyBank;
import com.fernferret.allpay.multiverse.GenericBank;
import com.fernferret.allpay.multiverse.ItemBank;
import com.fernferret.allpay.multiverse.RealEconomyBank;
import com.fernferret.allpay.multiverse.iConomyBank4X;
import com.fernferret.allpay.multiverse.iConomyBank5X;
import com.fernferret.allpay.multiverse.iConomyBank6X;
import com.iCo6.iConomy;
import cosine.boseconomy.BOSEconomy;
import fr.crafter.tickleman.RealEconomy.RealEconomy;
import fr.crafter.tickleman.RealPlugin.RealPlugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.melonbrew.fe.Fe;

public class AllPay {
    private static double version;
    private Properties props = new Properties();
    protected String logPrefix = "";
    protected static final Logger LOGGER;
    private String prefix;
    private Plugin plugin;
    private GenericBank bank;
    private static final String[] VALID_ECON_PLUGINS;

    public AllPay(Plugin plugin, String prefix) {
        try {
            this.props.load(this.getClass().getResourceAsStream("/allpay.properties"));
            version = Integer.parseInt(this.props.getProperty("version", "-1"));
        }
        catch (NumberFormatException e) {
            this.logBadAllPay(plugin);
        }
        catch (FileNotFoundException e) {
            this.logBadAllPay(plugin);
        }
        catch (IOException e) {
            this.logBadAllPay(plugin);
        }
        this.logPrefix = "[AllPay] - Version " + version;
        this.plugin = plugin;
        this.prefix = prefix;
    }

    public static String[] getValidEconPlugins() {
        return VALID_ECON_PLUGINS;
    }

    private void logBadAllPay(Plugin plugin) {
        plugin.getLogger().log(Level.SEVERE, String.format("AllPay looks corrupted, meaning this plugin (%s) is corrupted too!", plugin.getDescription().getName()));
    }

    public GenericBank loadEconPlugin() {
        this.loadiConomy();
        this.loadBOSEconomy();
        this.loadRealShopEconomy();
        this.loadEssentialsEconomoy();
        this.loadEconXPEconomy();
        this.loadFeconomy();
        this.loadDefaultItemEconomy();
        this.bank.setPrefix(this.prefix);
        return this.bank;
    }

    public GenericBank getEconPlugin() {
        return this.bank;
    }

    public double getVersion() {
        return version;
    }

    private void loadEssentialsEconomoy() {
        if (this.bank == null) {
            try {
                Plugin essentialsPlugin = this.plugin.getServer().getPluginManager().getPlugin("Essentials");
                if (essentialsPlugin != null) {
                    this.bank = new EssentialsBank();
                    LOGGER.info(this.logPrefix + " - hooked into Essentials Economy for " + this.plugin.getDescription().getFullName());
                }
            }
            catch (Exception e) {
                LOGGER.warning(this.logPrefix + "You are using a VERY old version of Essentials. Please upgrade it.");
            }
        }
    }

    private void loadRealShopEconomy() {
        Plugin realShopPlugin;
        if (this.bank == null && !(this.bank instanceof EssentialsBank) && (realShopPlugin = this.plugin.getServer().getPluginManager().getPlugin("RealShop")) != null) {
            RealEconomy realEconPlugin = new RealEconomy((RealPlugin)realShopPlugin);
            LOGGER.info(this.logPrefix + " - hooked into RealEconomy for " + this.plugin.getDescription().getFullName());
            this.bank = new RealEconomyBank(realEconPlugin);
        }
    }

    private void loadBOSEconomy() {
        Plugin boseconPlugin;
        if (this.bank == null && !(this.bank instanceof EssentialsBank) && (boseconPlugin = this.plugin.getServer().getPluginManager().getPlugin("BOSEconomy")) != null) {
            this.bank = new BOSEconomyBank((BOSEconomy)boseconPlugin);
            LOGGER.info(this.logPrefix + " - hooked into BOSEconomy for " + this.plugin.getDescription().getFullName());
        }
    }

    private void loadEconXPEconomy() {
        Plugin econXPPlugin;
        if (this.bank == null && !(this.bank instanceof EssentialsBank) && (econXPPlugin = this.plugin.getServer().getPluginManager().getPlugin("EconXP")) != null) {
            this.bank = new EconXPBank((EconXP)econXPPlugin);
            LOGGER.info(this.logPrefix + " - hooked into EconXP for " + this.plugin.getDescription().getFullName());
        }
    }

    private void loadFeconomy() {
        Plugin feconplugin;
        if (this.bank == null && !(this.bank instanceof FeconomyBank) && (feconplugin = this.plugin.getServer().getPluginManager().getPlugin("Fe")) != null) {
            this.bank = new FeconomyBank((Fe)feconplugin);
            LOGGER.info(this.logPrefix + " - hooked into Fe-conomy for " + this.plugin.getDescription().getFullName());
        }
    }

    private void loadDefaultItemEconomy() {
        if (this.bank == null) {
            this.bank = new ItemBank();
            LOGGER.info(this.logPrefix + " - using only an item based economy for " + this.plugin.getDescription().getFullName());
        }
    }

    private void loadiConomy() {
        if (this.bank == null && !(this.bank instanceof EssentialsBank)) {
            Plugin iConomyTest = this.plugin.getServer().getPluginManager().getPlugin("iConomy");
            try {
                if (iConomyTest != null && iConomyTest instanceof iConomy) {
                    this.bank = new iConomyBank6X();
                    LOGGER.info(this.logPrefix + " - hooked into iConomy 6 for " + this.plugin.getDescription().getFullName());
                }
            }
            catch (NoClassDefFoundError e) {
                this.loadiConomy5X(iConomyTest);
            }
        }
    }

    private void loadiConomy5X(Plugin iConomyTest) {
        block3: {
            try {
                if (iConomyTest != null && iConomyTest instanceof com.iConomy.iConomy) {
                    this.bank = new iConomyBank5X();
                    LOGGER.info(this.logPrefix + " - hooked into iConomy 5 for " + this.plugin.getDescription().getFullName());
                }
            }
            catch (NoClassDefFoundError ex) {
                if (iConomyTest == null) break block3;
                this.loadiConomy4X();
            }
        }
    }

    private void loadiConomy4X() {
        com.nijiko.coelho.iConomy.iConomy iConomyPlugin = (com.nijiko.coelho.iConomy.iConomy)this.plugin.getServer().getPluginManager().getPlugin("iConomy");
        if (iConomyPlugin != null) {
            this.bank = new iConomyBank4X();
            LOGGER.info(this.logPrefix + " - hooked into iConomy 4 for " + this.plugin.getDescription().getFullName());
        }
    }

    static {
        LOGGER = Logger.getLogger("Minecraft");
        VALID_ECON_PLUGINS = new String[]{"Essentials", "RealShop", "BOSEconomy", "iConomy", "MultiCurrency", "EconXP", "Fe"};
    }
}

