/*
 * Decompiled with CFR 0.152.
 */
package com.fernferret.allpay.multiverse;

import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import com.fernferret.allpay.multiverse.GenericBank;
import org.bukkit.entity.Player;

public class EssentialsBank
extends GenericBank {
    @Override
    public String getEconUsed() {
        return "Essentials Economy";
    }

    @Override
    protected boolean setMoneyBalance(Player player, double amount) {
        try {
            Economy.setMoney((String)player.getName(), (double)amount);
            return true;
        }
        catch (UserDoesNotExistException e) {
            this.showError(player, "You don't have an account!");
        }
        catch (NoLoanPermittedException e) {
            this.showError(player, "Your bank doesn't allow loans!");
        }
        return false;
    }

    @Override
    public String getFormattedMoneyAmount(Player player, double amount) {
        return Economy.format((double)amount);
    }

    @Override
    public boolean hasMoney(Player player, double money, String message) {
        try {
            return Economy.hasEnough((String)player.getName(), (double)money);
        }
        catch (UserDoesNotExistException e) {
            return false;
        }
    }

    @Override
    public void takeMoney(Player player, double amount) {
        try {
            Economy.subtract((String)player.getName(), (double)amount);
            this.showReceipt(player, amount, -1);
        }
        catch (UserDoesNotExistException e) {
            this.showError(player, "You don't have an account!");
        }
        catch (NoLoanPermittedException e) {
            this.showError(player, "Your bank doesn't allow loans!");
        }
    }

    @Override
    protected double getMoneyBalance(Player p) {
        try {
            return Economy.getMoney((String)p.getName());
        }
        catch (UserDoesNotExistException e) {
            this.showError(p, "You don't have an account!");
            return 0.0;
        }
    }

    @Override
    public void giveMoney(Player player, double amount) {
        try {
            Economy.add((String)player.getName(), (double)amount);
            this.showReceipt(player, amount * -1.0, -1);
        }
        catch (UserDoesNotExistException e) {
            this.showError(player, "You don't have an account!");
        }
        catch (NoLoanPermittedException e) {
            this.showError(player, "Your bank doesn't allow loans!");
        }
    }
}

