/*
 * Decompiled with CFR 0.152.
 */
package com.fernferret.allpay.multiverse;

import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class GenericBank {
    private boolean receipts = true;
    private String prefix;

    protected final boolean hasItem(Player player, double amount, int type, String message) {
        boolean hasEnough = player.getInventory().contains(type, (int)amount);
        if (!hasEnough) {
            this.userIsTooPoor(player, type, message);
        }
        return hasEnough;
    }

    protected abstract boolean hasMoney(Player var1, double var2, String var4);

    public final boolean hasEnough(Player player, double amount, int type, String message) {
        if (amount == 0.0) {
            return true;
        }
        if (type == -1) {
            return this.hasMoney(player, amount, message);
        }
        return this.hasItem(player, amount, type, message);
    }

    public final boolean hasEnough(Player player, double amount, int type) {
        return this.hasEnough(player, amount, type, null);
    }

    protected final void takeItem(Player player, double amount, int type) {
        int removed = 0;
        HashMap items = player.getInventory().all(type);
        Iterator i$ = items.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if ((double)removed >= amount) break;
            int diff = (int)(amount - (double)removed);
            int amt = player.getInventory().getItem(i).getAmount();
            if (amt - diff > 0) {
                player.getInventory().getItem(i).setAmount(amt - diff);
                break;
            }
            removed += amt;
            player.getInventory().clear(i);
        }
        this.showReceipt(player, amount, type);
    }

    protected abstract void takeMoney(Player var1, double var2);

    public final void take(Player player, double amount, int type) {
        if (type == -1) {
            this.takeMoney(player, amount);
        } else {
            this.takeItem(player, amount, type);
        }
    }

    public final void give(Player player, double amount, int type) {
        if (type == -1) {
            this.giveMoney(player, amount);
        } else {
            this.giveItem(player, amount, type);
        }
    }

    protected abstract void giveMoney(Player var1, double var2);

    protected final void giveItem(Player player, double amount, int type) {
        ItemStack item = new ItemStack(type, (int)amount);
        player.getInventory().addItem(new ItemStack[]{item});
        this.showReceipt(player, amount * -1.0, type);
    }

    public final void transfer(Player from, Player to, double amount, int type) {
        if (type == -1) {
            this.transferMoney(from, to, amount);
        } else {
            this.transferItem(from, to, amount, type);
        }
    }

    protected void transferMoney(Player from, Player to, double amount) {
        if (!this.hasMoney(from, amount, "")) {
            return;
        }
        this.takeMoney(from, amount);
        this.giveMoney(to, amount);
    }

    protected final void transferItem(Player from, Player to, double amount, int type) {
        if (!this.hasEnough(from, amount, type)) {
            return;
        }
        this.takeItem(from, amount, type);
        this.giveItem(to, amount, type);
    }

    public final String getFormattedItemAmount(double amount, int type) {
        Material m = Material.getMaterial((int)type);
        if (m != null) {
            return amount + " " + m.toString();
        }
        return "NO ITEM FOUND";
    }

    protected abstract String getFormattedMoneyAmount(Player var1, double var2);

    public final String getFormattedAmount(Player player, double amount, int item) {
        if (item == -1) {
            return this.getFormattedMoneyAmount(player, amount);
        }
        return this.getFormattedItemAmount(amount, item);
    }

    protected final void userIsTooPoor(Player player, int item, String message) {
        String type = item == -1 ? "funds" : "items";
        message = message == null ? "" : " " + message;
        player.sendMessage(ChatColor.DARK_RED + this.prefix + ChatColor.WHITE + "Sorry but you do not have the required " + type + message);
    }

    protected void showReceipt(Player player, double price, int item) {
        if (this.receipts) {
            if (price > 0.0) {
                player.sendMessage(String.format("%s%s%s%s%s %s", ChatColor.DARK_GREEN, this.prefix, ChatColor.WHITE, "You have been charged", ChatColor.GREEN, this.getFormattedAmount(player, price, item)));
            } else if (price < 0.0) {
                player.sendMessage(String.format("%s%s%s%s %s", ChatColor.DARK_GREEN, this.prefix, this.getFormattedAmount(player, price * -1.0, item), ChatColor.WHITE, "has been added to your account."));
            }
        }
    }

    protected void showError(Player player, String message) {
        player.sendMessage(ChatColor.DARK_RED + this.prefix + ChatColor.WHITE + message);
    }

    public abstract String getEconUsed();

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected final String formatCurrency(double amount, String currencySingular, String currencyPlural) {
        boolean inFront = false;
        if (currencySingular != null && currencySingular.length() == 1 && currencySingular.matches("[a-zA-Z]")) {
            inFront = true;
        }
        if (currencyPlural == null || amount == 1.0 || inFront) {
            return inFront ? currencySingular + amount : amount + " " + currencySingular;
        }
        return amount + " " + currencyPlural;
    }

    public boolean setBalance(Player player, int itemId, double amount) {
        if (itemId == -1) {
            return this.setMoneyBalance(player, amount);
        }
        return this.setItemAmount(player, itemId, amount);
    }

    protected abstract boolean setMoneyBalance(Player var1, double var2);

    protected final boolean setItemAmount(Player player, int type, double amount) {
        int numberOfItems = this.getItemAmount(player, type);
        if ((double)numberOfItems > amount) {
            this.takeItem(player, (double)numberOfItems - amount, type);
        } else if ((double)numberOfItems < amount) {
            this.giveItem(player, amount - (double)numberOfItems, type);
        }
        return true;
    }

    public double getBalance(Player player, int itemId) {
        if (itemId == -1) {
            return this.getMoneyBalance(player);
        }
        return this.getItemAmount(player, itemId);
    }

    protected abstract double getMoneyBalance(Player var1);

    @Deprecated
    protected final int getItemAnount(Player player, int type) {
        return this.getItemAmount(player, type);
    }

    protected final int getItemAmount(Player player, int type) {
        HashMap items = player.getInventory().all(type);
        int total = 0;
        Iterator i$ = items.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            total += player.getInventory().getItem(i).getAmount();
        }
        return total;
    }

    public void toggleReceipts(boolean showRecipts) {
        this.receipts = showRecipts;
    }
}

