/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class FileUtils {
    private static final int COPY_BLOCK_SIZE = 1024;

    protected FileUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean deleteFolder(File file) {
        if (file.exists()) {
            boolean ret = true;
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    ret = ret && FileUtils.deleteFolder(f);
                }
            }
            return ret && file.delete();
        }
        return false;
    }

    public static boolean deleteFolderContents(File file) {
        if (file.exists()) {
            boolean ret = true;
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    ret = ret && FileUtils.deleteFolder(f);
                }
            }
            return ret;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFolder(File source, File target, Logger log) {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (source.isDirectory()) {
                String[] children;
                if (!target.exists()) {
                    target.mkdir();
                }
                for (String child : children = source.list()) {
                    FileUtils.copyFolder(new File(source, child), new File(target, child), log);
                }
            } else {
                int len;
                in = new FileInputStream(source);
                out = new FileOutputStream(target);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            boolean buf = true;
            return buf;
        }
        catch (FileNotFoundException e) {
            log.warning("Exception while copying file: " + e.getMessage());
        }
        catch (IOException e) {
            log.warning("Exception while copying file: " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
        return false;
    }
}

