/*
 * Decompiled with CFR 0.152.
 */
package com.nuclearw.borderarea;

import com.nuclearw.borderarea.BorderAreaPlayerListener;
import com.nuclearw.borderarea.BorderAreaVehicleListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BorderArea
extends JavaPlugin {
    static String mainDirectory = "plugins" + File.separator + "BorderArea";
    static File borderpoints = new File(mainDirectory + File.separator + "points");
    static Properties prop = new Properties();
    private final BorderAreaPlayerListener playerListener = new BorderAreaPlayerListener(this);
    private final BorderAreaVehicleListener vehicleListener = new BorderAreaVehicleListener(this);
    public int xmin = 0;
    public int xmax = 0;
    public int zmin = 0;
    public int zmax = 0;
    Logger log = Logger.getLogger("Minecraft");

    public void onEnable() {
        int[][] points = new int[2][2];
        this.log.info("BorderArea " + this.getDescription().getVersion() + " loaded.");
        new File(mainDirectory).mkdir();
        if (!borderpoints.exists()) {
            try {
                borderpoints.createNewFile();
                FileOutputStream out = new FileOutputStream(borderpoints);
                prop.put("point1-x", "-100");
                prop.put("point1-z", "-100");
                prop.put("point2-x", "100");
                prop.put("point2-z", "100");
                prop.store(out, "Border area points go here.");
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            FileInputStream in = new FileInputStream(borderpoints);
            prop.load(in);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        points[0][0] = Integer.parseInt(prop.getProperty("point1-x"));
        points[0][1] = Integer.parseInt(prop.getProperty("point1-z"));
        points[1][0] = Integer.parseInt(prop.getProperty("point2-x"));
        points[1][1] = Integer.parseInt(prop.getProperty("point2-z"));
        if (points[0][0] < points[1][0]) {
            this.xmin = points[0][0];
            this.xmax = points[1][0];
        } else {
            this.xmin = points[1][0];
            this.xmax = points[0][0];
        }
        if (points[0][1] < points[1][1]) {
            this.zmin = points[0][1];
            this.zmax = points[1][1];
        } else {
            this.zmin = points[1][1];
            this.zmax = points[0][1];
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.vehicleListener, (Plugin)this);
    }

    public void onDisable() {
        this.log.info("BorderArea " + this.getDescription().getVersion() + " unloaded.");
    }

    public boolean validLocation(Location check) {
        int x = check.getBlockX();
        int z = check.getBlockZ();
        if (x > this.xmax || x < this.xmin) {
            return false;
        }
        return z <= this.zmax && z >= this.zmin;
    }
}

