/*
 * Decompiled with CFR 0.152.
 */
package com.nuclearw.borderarea;

import com.nuclearw.borderarea.BorderArea;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BorderAreaPlayerListener
implements Listener {
    public static BorderArea plugin;

    public BorderAreaPlayerListener(BorderArea instance) {
        plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (plugin.validLocation(player.getLocation())) {
            return;
        }
        player.teleport(player.getWorld().getSpawnLocation());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (plugin.validLocation(event.getTo())) {
            return;
        }
        Player player = event.getPlayer();
        if (plugin.validLocation(event.getFrom())) {
            player.sendMessage("You have reached the border.");
            player.teleport(event.getFrom());
            event.setTo(event.getFrom());
            return;
        }
        if (plugin.validLocation(event.getTo().add(1.0, 0.0, 0.0))) {
            player.sendMessage("You have reached the border.");
            player.teleport(event.getTo().add(1.0, 0.0, 0.0));
            event.setTo(event.getTo().add(1.0, 0.0, 0.0));
            return;
        }
        if (plugin.validLocation(event.getTo().add(-1.0, 0.0, 0.0))) {
            player.sendMessage("You have reached the border.");
            player.teleport(event.getTo().add(-1.0, 0.0, 0.0));
            event.setTo(event.getTo().add(-1.0, 0.0, 0.0));
            return;
        }
        if (plugin.validLocation(event.getTo().add(0.0, 0.0, 1.0))) {
            player.sendMessage("You have reached the border.");
            player.teleport(event.getTo().add(0.0, 0.0, 1.0));
            event.setTo(event.getTo().add(0.0, 0.0, 1.0));
            return;
        }
        if (plugin.validLocation(event.getTo().add(0.0, 0.0, -1.0))) {
            player.sendMessage("You have reached the border.");
            player.teleport(event.getTo().add(0.0, 0.0, -1.0));
            event.setTo(event.getTo().add(0.0, 0.0, -1.0));
            return;
        }
        player.damage(2);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (plugin.validLocation(event.getTo())) {
            return;
        }
        Player player = event.getPlayer();
        if (plugin.validLocation(event.getFrom())) {
            event.setTo(event.getFrom());
            player.sendMessage("You have reached the border.");
            player.teleport(event.getFrom());
        } else {
            player.teleport(player.getWorld().getSpawnLocation());
        }
    }
}

