/*
 * Decompiled with CFR 0.152.
 */
package org.PrimeSoft.AsyncWorldedit.BlockLogger;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import me.botsko.prism.Prism;
import me.botsko.prism.actionlibs.ActionFactory;
import me.botsko.prism.actions.Handler;
import org.PrimeSoft.AsyncWorldedit.BlockLogger.IBlockLogger;
import org.PrimeSoft.AsyncWorldedit.PluginMain;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PrismLogger
implements IBlockLogger {
    private boolean m_isEnabled;

    public static Prism getPrism(JavaPlugin plugin) {
        try {
            Plugin cPlugin = plugin.getServer().getPluginManager().getPlugin("Prism");
            if (cPlugin == null || !(cPlugin instanceof Prism)) {
                return null;
            }
            return (Prism)cPlugin;
        }
        catch (NoClassDefFoundError ex) {
            return null;
        }
    }

    public PrismLogger(PluginMain plugin) {
        if (PrismLogger.getPrism(plugin) == null) {
            PluginMain.Log("Error initializing Prism logger.");
            this.m_isEnabled = false;
        } else {
            PluginMain.Log("Prism logger initialized");
            this.m_isEnabled = true;
        }
    }

    @Override
    public void LogBlock(Vector location, BaseBlock oldBlock, BaseBlock newBlock, String player, World world) {
        if (!this.m_isEnabled) {
            return;
        }
        Location l = new Location(world, (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        Handler action = ActionFactory.create((String)"world-edit", (Location)l, (int)oldBlock.getType(), (byte)((byte)oldBlock.getData()), (int)newBlock.getType(), (byte)((byte)newBlock.getData()), (String)player);
        Prism.actionsRecorder.addToQueue(action);
    }
}

