/*
 * Decompiled with CFR 0.152.
 */
package org.PrimeSoft.AsyncWorldedit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import org.PrimeSoft.AsyncWorldedit.BlockLogger.IBlockLogger;
import org.PrimeSoft.AsyncWorldedit.BlockLogger.NoneLogger;
import org.PrimeSoft.AsyncWorldedit.BlockPlacerEntry;
import org.PrimeSoft.AsyncWorldedit.ConfigProvider;
import org.PrimeSoft.AsyncWorldedit.PermissionManager;
import org.PrimeSoft.AsyncWorldedit.PluginMain;
import org.PrimeSoft.AsyncWorldedit.Worldedit.AsyncEditSession;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class BlockPlacer
implements Runnable {
    private BukkitScheduler m_scheduler;
    private BukkitTask m_task;
    private HashMap<String, Queue<BlockPlacerEntry>> m_blocks = new HashMap();
    private HashSet<String> m_lockedQueues = new HashSet();
    private boolean m_shutdown;
    private IBlockLogger m_logger;
    private int m_queueHardLimit;
    private int m_queueSoftLimit;

    public BlockPlacer(PluginMain plugin) {
        this.m_scheduler = plugin.getServer().getScheduler();
        this.m_task = this.m_scheduler.runTaskTimer((Plugin)plugin, (Runnable)this, ConfigProvider.getInterval(), ConfigProvider.getInterval());
        this.m_queueHardLimit = ConfigProvider.getQueueHardLimit();
        this.m_queueSoftLimit = ConfigProvider.getQueueSoftLimit();
        this.setLogger(null);
    }

    public void setLogger(IBlockLogger logger) {
        if (logger == null) {
            logger = new NoneLogger();
        }
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<BlockPlacerEntry> entries = new ArrayList<BlockPlacerEntry>(ConfigProvider.getBlockCount());
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            String[] keys = this.m_blocks.keySet().toArray(new String[0]);
            int keyPos = 0;
            boolean added = keys.length > 0;
            int blockCnt = ConfigProvider.getBlockCount();
            for (int i = 0; i < blockCnt && added; ++i) {
                added = false;
                String player = keys[keyPos];
                Queue<BlockPlacerEntry> queue = this.m_blocks.get(player);
                if (queue != null) {
                    int size;
                    if (!queue.isEmpty()) {
                        entries.add(queue.poll());
                        added = true;
                    }
                    if ((size = queue.size()) < this.m_queueSoftLimit && this.m_lockedQueues.contains(player)) {
                        PluginMain.Say(PluginMain.getPlayer(player), "Your block queue is unlocked. You can use WorldEdit.");
                        this.m_lockedQueues.remove(player);
                    }
                    if (size == 0) {
                        this.m_blocks.remove(keys[keyPos]);
                    }
                } else if (this.m_lockedQueues.contains(player)) {
                    PluginMain.Say(PluginMain.getPlayer(player), "Your block queue is unlocked. You can use WorldEdit.");
                    this.m_lockedQueues.remove(player);
                }
                keyPos = (keyPos + 1) % keys.length;
            }
            if (!added && this.m_shutdown) {
                this.stop();
            }
        }
        for (BlockPlacerEntry entry : entries) {
            this.process(entry);
        }
    }

    public void queueStop() {
        this.m_shutdown = true;
    }

    public void stop() {
        this.m_task.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTasks(BlockPlacerEntry entry) {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            Queue<Object> queue;
            AsyncEditSession editSesson = entry.getEditSession();
            String player = editSesson.getPlayer();
            if (!this.m_blocks.containsKey(player)) {
                queue = new ArrayDeque();
                this.m_blocks.put(player, queue);
            } else {
                queue = this.m_blocks.get(player);
            }
            if (this.m_lockedQueues.contains(player)) {
                return false;
            }
            queue.add(entry);
            if (queue.size() >= this.m_queueHardLimit && !PermissionManager.isAllowed(PluginMain.getPlayer(player), PermissionManager.Perms.QueueBypass)) {
                this.m_lockedQueues.add(player);
                PluginMain.Say(PluginMain.getPlayer(player), "Your block queue is full. Wait for items to finish drawing.");
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(String player) {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            if (this.m_blocks.containsKey(player)) {
                this.m_blocks.remove(player);
            }
            if (this.m_lockedQueues.contains(player)) {
                this.m_lockedQueues.remove(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAll() {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            for (String user : this.getAllPlayers()) {
                this.purge(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllPlayers() {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            return this.m_blocks.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerEvents(String player) {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            if (this.m_blocks.containsKey(player)) {
                return this.m_blocks.get(player).size();
            }
            return 0;
        }
    }

    private void process(BlockPlacerEntry entry) {
        if (entry == null) {
            return;
        }
        Vector location = entry.getLocation();
        BaseBlock block = entry.getNewBlock();
        AsyncEditSession eSession = entry.getEditSession();
        String player = eSession.getPlayer();
        World world = eSession.getCBWorld();
        BaseBlock oldBlock = eSession.getBlock(location);
        eSession.doRawSetBlock(location, block);
        this.m_logger.LogBlock(location, oldBlock, block, player, world);
    }
}

