/*
 * Decompiled with CFR 0.152.
 */
package org.PrimeSoft.AsyncWorldedit;

import org.PrimeSoft.AsyncWorldedit.PluginMain;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigProvider {
    public static final String DEFAULT_USER = "#worldedit";
    private static final int CONFIG_VERSION = 1;
    private static boolean m_defaultMode = true;
    private static boolean m_checkUpdate = false;
    private static boolean m_isConfigUpdate = false;
    private static long m_interval;
    private static int m_blocksCnt;
    private static int m_queueHardLimit;
    private static int m_queueSoftLimit;
    private static String m_configVersion;
    private static String m_logger;

    public static String getLogger() {
        return m_logger;
    }

    public static String getConfigVersion() {
        return m_configVersion;
    }

    public static boolean getCheckUpdate() {
        return m_checkUpdate;
    }

    public static long getInterval() {
        return m_interval;
    }

    public static int getBlockCount() {
        return m_blocksCnt;
    }

    public static boolean isConfigUpdated() {
        return m_isConfigUpdate;
    }

    public static int getQueueHardLimit() {
        return m_queueHardLimit;
    }

    public static int getQueueSoftLimit() {
        return m_queueSoftLimit;
    }

    public static boolean getDefaultMode() {
        return m_defaultMode;
    }

    public static boolean load(PluginMain plugin) {
        if (plugin == null) {
            return false;
        }
        plugin.saveDefaultConfig();
        FileConfiguration config = plugin.getConfig();
        ConfigurationSection mainSection = config.getConfigurationSection("awe");
        if (mainSection == null) {
            return false;
        }
        m_configVersion = mainSection.getString("version", "?");
        ConfigProvider.parseRenderSection(mainSection);
        m_checkUpdate = mainSection.getBoolean("checkVersion", true);
        m_isConfigUpdate = mainSection.getInt("version", 0) == 1;
        m_logger = mainSection.getString("logger", "none").toLowerCase();
        m_defaultMode = mainSection.getBoolean("defaultOn", true);
        return true;
    }

    private static void parseRenderSection(ConfigurationSection mainSection) {
        ConfigurationSection renderSection = mainSection.getConfigurationSection("rendering");
        if (renderSection == null) {
            m_blocksCnt = 1000;
            m_interval = 15L;
            m_queueHardLimit = 500000;
            m_queueSoftLimit = 250000;
        } else {
            m_blocksCnt = renderSection.getInt("blocks", 1000);
            m_interval = renderSection.getInt("interval", 15);
            m_queueSoftLimit = renderSection.getInt("queue-limit-soft", 250000);
            m_queueHardLimit = renderSection.getInt("queue-limit-hard", 500000);
        }
    }
}

