/*
 * Decompiled with CFR 0.152.
 */
package org.PrimeSoft.AsyncWorldedit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.PrimeSoft.AsyncWorldedit.PluginMain;

public class VersionChecker {
    private static final String s_versionUrl = "http://dev.bukkit.org/server-mods/async_worldedit/pages/version/";

    private static String downlaodPage(String url) {
        try {
            InputStreamReader is = new InputStreamReader(new URL(url).openStream());
            BufferedReader br = new BufferedReader(is);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            PluginMain.Log("Error downloading file: " + e.getMessage());
            return null;
        }
    }

    public static String CheckVersion(String version) {
        String content = VersionChecker.downlaodPage(s_versionUrl);
        if (content == null || content.isEmpty()) {
            return "Unable to check latest plugin version.";
        }
        String eVersion = content.replaceAll("(.*>VERSION:[\t ]*)([^<]+)(<.*)", "$2");
        int cmp = version.compareToIgnoreCase(eVersion);
        if (cmp < 0) {
            return "You have an old version of the plugin. Your version: " + version + ", available version: " + eVersion;
        }
        if (cmp > 0) {
            return "You have a newer version of the plugin then available! Your version: " + version + ", available version: " + eVersion;
        }
        return "You have the latest version of the plugin.";
    }
}

