/*
 * Decompiled with CFR 0.152.
 */
package org.PrimeSoft.AsyncWorldedit.Worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import java.util.Map;
import org.PrimeSoft.AsyncWorldedit.BlockPlacer;
import org.PrimeSoft.AsyncWorldedit.BlockPlacerEntry;
import org.PrimeSoft.AsyncWorldedit.PluginMain;
import org.PrimeSoft.AsyncWorldedit.Worldedit.UndoSession;
import org.bukkit.World;

public class AsyncEditSession
extends EditSession {
    private String m_player;
    private BlockPlacer m_blockPlacer;
    private World m_world;

    public String getPlayer() {
        return this.m_player;
    }

    public AsyncEditSession(PluginMain plugin, String player, LocalWorld world, int maxBlocks) {
        super(world, maxBlocks);
        this.m_player = player;
        this.m_blockPlacer = plugin.getBlockPlacer();
        this.m_world = plugin.getServer().getWorld(world.getName());
    }

    public AsyncEditSession(PluginMain plugin, String player, LocalWorld world, int maxBlocks, BlockBag blockBag) {
        super(world, maxBlocks, blockBag);
        this.m_player = player;
        this.m_blockPlacer = plugin.getBlockPlacer();
        this.m_world = plugin.getServer().getWorld(world.getName());
    }

    public boolean rawSetBlock(Vector pt, BaseBlock block) {
        if (PluginMain.hasAsyncMode(this.m_player)) {
            return this.m_blockPlacer.addTasks(new BlockPlacerEntry(this, pt, block));
        }
        return super.rawSetBlock(pt, block);
    }

    public void undo(EditSession sess) {
        UndoSession undoSession = new UndoSession();
        super.undo((EditSession)undoSession);
        Map.Entry<Vector, BaseBlock>[] blocks = undoSession.getEntries();
        for (int i = blocks.length - 1; i >= 0; --i) {
            Map.Entry<Vector, BaseBlock> entry = blocks[i];
            sess.smartSetBlock(entry.getKey(), entry.getValue());
        }
        sess.flushQueue();
    }

    public void doRawSetBlock(Vector pt, BaseBlock block) {
        super.rawSetBlock(pt, block);
    }

    public World getCBWorld() {
        return this.m_world;
    }
}

