/*
 * Decompiled with CFR 0.152.
 */
package org.PrimeSoft.AsyncWorldedit.Worldedit;

import com.sk89q.worldedit.EditSessionFactory;
import com.sk89q.worldedit.WorldEdit;
import org.PrimeSoft.AsyncWorldedit.PluginMain;
import org.PrimeSoft.AsyncWorldedit.Worldedit.AsyncEditSessionFactory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class WorldeditIntegrator
implements Runnable {
    private static final int CHECK_INTERVAL = 40;
    private BukkitScheduler m_scheduler;
    private WorldEdit m_worldedit;
    private boolean m_shutdown;
    private BukkitTask m_task;
    private PluginMain m_parent;

    public WorldeditIntegrator(PluginMain plugin, WorldEdit worldEdit) {
        this.m_worldedit = worldEdit;
        this.m_parent = plugin;
        this.m_scheduler = plugin.getServer().getScheduler();
        if (this.m_parent == null) {
            this.m_shutdown = true;
            return;
        }
        if (this.m_worldedit == null || this.m_scheduler == null) {
            this.m_shutdown = true;
            PluginMain.Log("Error initializeing Worldedit integrator");
            return;
        }
        this.m_task = this.m_scheduler.runTaskTimer((Plugin)plugin, (Runnable)this, 40L, 40L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WorldeditIntegrator worldeditIntegrator = this;
        synchronized (worldeditIntegrator) {
            if (this.m_shutdown) {
                this.stop();
                return;
            }
            EditSessionFactory factory = this.m_worldedit.getEditSessionFactory();
            if (!(factory instanceof AsyncEditSessionFactory)) {
                PluginMain.Log("World edit session not set to AsyncWorldedit. Fixing.");
                this.m_worldedit.setEditSessionFactory((EditSessionFactory)new AsyncEditSessionFactory(this.m_parent));
            }
        }
    }

    public void queueStop() {
        this.m_shutdown = true;
    }

    public void stop() {
        if (this.m_task != null) {
            this.m_task.cancel();
            this.m_task = null;
        }
    }
}

