/*
 * Decompiled with CFR 0.152.
 */
package com.dibujaron.MoreMobs.Mobs;

import com.dibujaron.MoreMobs.Mobs.BaseMobHandler;
import com.dibujaron.MoreMobs.MoreMobsCore;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HeroBlockHandler
implements BaseMobHandler {
    MoreMobsCore plugin;

    public HeroBlockHandler(MoreMobsCore p) {
        this.plugin = p;
    }

    @Override
    public void create(Entity baseMob) {
        if (baseMob instanceof Skeleton) {
            Skeleton s = (Skeleton)baseMob;
            this.setup(s);
        } else {
            Skeleton s = (Skeleton)baseMob.getWorld().spawnEntity(baseMob.getLocation(), EntityType.SKELETON);
            this.setup(s);
            baseMob.remove();
        }
    }

    @Override
    public boolean isThisType(Entity entity) {
        return entity instanceof Skeleton && ((Skeleton)entity).hasPotionEffect(PotionEffectType.INVISIBILITY) && ((Skeleton)entity).getEquipment().getHelmet() != null && ((Skeleton)entity).getEquipment().getHelmet().getType() != Material.AIR;
    }

    @Override
    public void Die(EntityDeathEvent event) {
    }

    @Override
    public void specialAttack(Entity thisMob, Entity target) {
    }

    private void setup(Skeleton s) {
        EntityEquipment e = s.getEquipment();
        Material m = this.getHighestBlockBeneath(s.getLocation()).getBlock().getType();
        e.setHelmet(new ItemStack(m));
        s.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false));
        e.setItemInHand(new ItemStack(Material.AIR));
    }

    public Location getHighestBlockBeneath(Location loc) {
        if (loc.getWorld().getBlockAt(loc).getType() == Material.AIR) {
            return this.getHighestBlockBeneath(new Location(loc.getWorld(), loc.getX(), loc.getY() - 1.0, loc.getZ()));
        }
        return loc;
    }
}

