/*
 * Decompiled with CFR 0.152.
 */
package com.dibujaron.MoreMobs.Mobs;

import com.dibujaron.MoreMobs.Mobs.BaseMobHandler;
import com.dibujaron.MoreMobs.MoreMobsCore;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WraithHandler
implements BaseMobHandler {
    MoreMobsCore plugin;

    public WraithHandler(MoreMobsCore p) {
        this.plugin = p;
    }

    @Override
    public void create(Entity baseMob) {
        if (baseMob instanceof Zombie) {
            this.setup((Zombie)baseMob);
        } else {
            Zombie z = (Zombie)baseMob.getWorld().spawnEntity(baseMob.getLocation(), EntityType.ZOMBIE);
            this.setup(z);
            baseMob.remove();
        }
    }

    @Override
    public boolean isThisType(Entity entity) {
        EntityEquipment e;
        this.plugin.debug("isThistType called");
        if (entity instanceof Zombie && (e = ((Zombie)entity).getEquipment()).getChestplate().getType() == Material.LEATHER_CHESTPLATE) {
            this.plugin.debug("chestplate is yes");
            if (e.getHelmet().getType() == Material.SKULL_ITEM) {
                this.plugin.debug("helmet is yes");
                if (e.getItemInHand().getType() == Material.IRON_HOE) {
                    this.plugin.debug("iteminhand is yes");
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void Die(EntityDeathEvent event) {
    }

    @Override
    public void specialAttack(Entity thisMob, Entity target) {
        Player p;
        if (target instanceof Player && (p = (Player)target).getHealth() < 8 && this.plugin.useWraithHell) {
            p.teleport(this.plugin.wraithHellLocation);
            p.getServer().broadcastMessage(String.valueOf(p.getName()) + " had their soul reaped by a wraith");
        }
    }

    public void setup(Zombie z) {
        EntityEquipment e = z.getEquipment();
        e.setHelmet(new ItemStack(Material.SKULL_ITEM, 1, 1));
        ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE);
        LeatherArmorMeta m = (LeatherArmorMeta)chestplate.getItemMeta();
        m.setColor(Color.BLACK);
        chestplate.setItemMeta((ItemMeta)m);
        e.setChestplate(chestplate);
        e.setItemInHand(new ItemStack(Material.IRON_HOE));
        z.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false));
    }
}

