/*
 * Decompiled with CFR 0.152.
 */
package com.dibujaron.MoreMobs;

import com.dibujaron.MoreMobs.Mobs.BabyZombieHandler;
import com.dibujaron.MoreMobs.Mobs.GiantMagmaCubeHandler;
import com.dibujaron.MoreMobs.Mobs.GiantSlimeHandler;
import com.dibujaron.MoreMobs.Mobs.GiantZombieHandler;
import com.dibujaron.MoreMobs.Mobs.HeroBlockHandler;
import com.dibujaron.MoreMobs.Mobs.PigChestHandler;
import com.dibujaron.MoreMobs.Mobs.WraithHandler;
import com.dibujaron.MoreMobs.MoreMobsCommander;
import com.dibujaron.MoreMobs.MoreMobsListener;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MoreMobsCore
extends JavaPlugin {
    private final boolean DEBUG = false;
    public int giantZombieChance;
    public int giantSlimeChance;
    public int giantMagmaCubeChance;
    public int wraithChance;
    public int heroBlockChance;
    public int babyZombieChance;
    public EntityType giantZombieReplaceType;
    public EntityType giantSlimeReplaceType;
    public EntityType giantMagmaCubeReplaceType;
    public EntityType wraithReplaceType;
    public EntityType heroBlockReplaceType;
    public EntityType babyZombieReplaceType;
    public BabyZombieHandler BZH;
    public GiantMagmaCubeHandler GMCH;
    public GiantSlimeHandler GSH;
    public GiantZombieHandler GZH;
    public HeroBlockHandler HBH;
    public PigChestHandler PCH;
    public WraithHandler WH;
    public boolean useWraithHell;
    public Location wraithHellLocation;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        MoreMobsCommander commander = new MoreMobsCommander(this);
        this.getServer().getPluginManager().registerEvents((Listener)new MoreMobsListener(this), (Plugin)this);
        this.getCommand("MoreMobs").setExecutor((CommandExecutor)commander);
        this.getCommand("setWraithHell").setExecutor((CommandExecutor)commander);
        this.giantZombieChance = config.getInt("GiantZombieChance");
        this.giantSlimeChance = config.getInt("GiantSlimeChance");
        this.giantMagmaCubeChance = config.getInt("GiantMagmaCubeChance");
        this.wraithChance = config.getInt("WraithChance");
        this.heroBlockChance = config.getInt("HeroBlockChance");
        this.babyZombieChance = config.getInt("BabyZombieChance");
        this.giantZombieReplaceType = this.parseEntityType(config.getString("giantZombieReplaceType"));
        this.giantSlimeReplaceType = this.parseEntityType(config.getString("giantSlimeReplaceType"));
        this.giantMagmaCubeReplaceType = this.parseEntityType(config.getString("giantMagmaCubeReplaceType"));
        this.wraithReplaceType = this.parseEntityType(config.getString("wraithReplaceType"));
        this.heroBlockReplaceType = this.parseEntityType(config.getString("heroBlockReplaceType"));
        this.babyZombieReplaceType = this.parseEntityType(config.getString("babyZombieReplaceType"));
        this.useWraithHell = config.getBoolean("useWraithHell");
        String world = config.getString("wraithHellWorld");
        int X = config.getInt("wraithHellX");
        int Y = config.getInt("wraithHellY");
        int Z = config.getInt("wraithHellZ");
        this.wraithHellLocation = new Location(this.getServer().getWorld(world), (double)X, (double)Y, (double)Z);
        this.BZH = new BabyZombieHandler(this);
        this.GMCH = new GiantMagmaCubeHandler(this);
        this.GSH = new GiantSlimeHandler(this);
        this.GZH = new GiantZombieHandler(this);
        this.HBH = new HeroBlockHandler(this);
        this.PCH = new PigChestHandler(this);
        this.WH = new WraithHandler(this);
    }

    private EntityType parseEntityType(String string) {
        if (string.equals("ZOMBIE")) {
            return EntityType.ZOMBIE;
        }
        if (string.equals("SPIDER")) {
            return EntityType.SPIDER;
        }
        if (string.equals("SKELETON")) {
            return EntityType.SKELETON;
        }
        if (string.equals("PIG_ZOMBIE")) {
            return EntityType.PIG_ZOMBIE;
        }
        if (string.equals("GHAST")) {
            return EntityType.GHAST;
        }
        if (string.equals("CAVE_SPIDER")) {
            return EntityType.CAVE_SPIDER;
        }
        if (string.equals("MAGMA_CUBE")) {
            return EntityType.MAGMA_CUBE;
        }
        if (string.equals("SLIME")) {
            return EntityType.SLIME;
        }
        if (string.equals("CREEPER")) {
            return EntityType.CREEPER;
        }
        if (string.equals("ENDERMAN")) {
            return EntityType.ENDERMAN;
        }
        this.getLogger().severe("ERROR MoreMobs configuration file invalid." + string + " is not an acceptable type");
        this.getLogger().severe("Spawning will not work properly!");
        return null;
    }

    public void debug(String s) {
    }
}

