/*
 * Decompiled with CFR 0.152.
 */
package com.dibujaron.MoreMobs;

import com.dibujaron.MoreMobs.MoreMobsCore;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;

public class MoreMobsListener
implements Listener {
    MoreMobsCore c;

    MoreMobsListener(MoreMobsCore p) {
        this.c = p;
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Pig && event.getPlayer().getItemInHand().getType() == Material.STORAGE_MINECART) {
            this.c.PCH.create(event.getRightClicked());
            event.getPlayer().setItemInHand(new ItemStack(Material.AIR));
            event.getPlayer().sendMessage("<" + ChatColor.AQUA + "MoreMobs" + ChatColor.RESET + "> You have created a PigChest!");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (!event.isCancelled()) {
            this.c.debug("CreatureSpwnEvent called");
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                return;
            }
            this.c.debug("was not SpawnReason.CUSTOM");
            this.c.debug(event.getEntityType().getName());
            LivingEntity e = event.getEntity();
            EntityType t = e.getType();
            if (t == this.c.giantZombieReplaceType && this.chance(this.c.giantZombieChance)) {
                this.c.GZH.create((Entity)e);
                return;
            }
            if (t == this.c.giantSlimeReplaceType && this.chance(this.c.giantSlimeChance)) {
                this.c.GSH.create((Entity)e);
                return;
            }
            if (t == this.c.giantMagmaCubeReplaceType && this.chance(this.c.giantMagmaCubeChance)) {
                this.c.GMCH.create((Entity)e);
                return;
            }
            if (t == this.c.wraithReplaceType && this.chance(this.c.wraithChance)) {
                this.c.WH.create((Entity)e);
                return;
            }
            if (t == this.c.heroBlockReplaceType && this.chance(this.c.heroBlockChance)) {
                this.c.HBH.create((Entity)e);
                return;
            }
            if (t == this.c.babyZombieReplaceType && this.chance(this.c.babyZombieChance)) {
                this.c.BZH.create((Entity)e);
                return;
            }
            this.c.debug("Was not any of the MoreMob types");
        }
    }

    @EventHandler
    public void onEntityDie(EntityDeathEvent event) {
        LivingEntity e = event.getEntity();
        if (event.getEntity().getKiller() instanceof Player) {
            if (this.c.GZH.isThisType((Entity)e)) {
                this.c.GZH.Die(event);
                return;
            }
            if (this.c.BZH.isThisType((Entity)e)) {
                this.c.BZH.Die(event);
                return;
            }
            if (this.c.HBH.isThisType((Entity)e)) {
                this.c.HBH.Die(event);
                return;
            }
            if (this.c.WH.isThisType((Entity)e)) {
                this.c.WH.Die(event);
                return;
            }
            if (this.c.GSH.isThisType((Entity)e)) {
                this.c.GSH.Die(event);
                return;
            }
            if (this.c.GMCH.isThisType((Entity)e)) {
                this.c.GMCH.Die(event);
                return;
            }
        }
    }

    @EventHandler
    public void onEntityAttackEntity(EntityDamageByEntityEvent event) {
        this.c.debug("Damage by Entity Event");
        if (event.getEntity() instanceof Player) {
            this.c.debug("Damaged entity was a player");
            Player p = (Player)event.getEntity();
            Entity e = event.getDamager();
            if (this.c.GZH.isThisType(e)) {
                this.c.debug("was a gZ");
                this.c.GZH.specialAttack(e, (Entity)p);
                return;
            }
            if (this.c.BZH.isThisType(e)) {
                this.c.debug("was a BZ");
                this.c.BZH.specialAttack(e, (Entity)p);
                return;
            }
            if (this.c.HBH.isThisType(e)) {
                this.c.debug("was a HB");
                this.c.HBH.specialAttack(e, (Entity)p);
                return;
            }
            if (this.c.WH.isThisType(e)) {
                this.c.debug("was a wraith");
                this.c.WH.specialAttack(e, (Entity)p);
                return;
            }
            if (this.c.GSH.isThisType(e)) {
                this.c.GSH.specialAttack(e, (Entity)p);
                return;
            }
            if (this.c.GMCH.isThisType(e)) {
                this.c.GMCH.specialAttack(e, (Entity)p);
                return;
            }
        }
    }

    private boolean chance(int chanceOfHundred) {
        int testNum = (int)(Math.random() * 100.0);
        return testNum < chanceOfHundred;
    }
}

