/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.primesoft.asyncworldedit.BlockPlacerEntry;
import org.primesoft.asyncworldedit.ConfigProvider;
import org.primesoft.asyncworldedit.PermissionManager;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.worldedit.AsyncEditSession;

public class BlockPlacer
implements Runnable {
    private BukkitScheduler m_scheduler;
    private BukkitTask m_task;
    private HashMap<String, Queue<BlockPlacerEntry>> m_blocks = new HashMap();
    private HashSet<String> m_lockedQueues = new HashSet();
    private boolean m_shutdown;
    private int m_queueHardLimit;
    private int m_queueSoftLimit;
    private int m_queueMaxSize;

    public BlockPlacer(PluginMain plugin) {
        this.m_scheduler = plugin.getServer().getScheduler();
        this.m_task = this.m_scheduler.runTaskTimer((Plugin)plugin, (Runnable)this, ConfigProvider.getInterval(), ConfigProvider.getInterval());
        this.m_queueHardLimit = ConfigProvider.getQueueHardLimit();
        this.m_queueSoftLimit = ConfigProvider.getQueueSoftLimit();
        this.m_queueMaxSize = ConfigProvider.getQueueMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<BlockPlacerEntry> entries = new ArrayList<BlockPlacerEntry>(ConfigProvider.getBlockCount() + ConfigProvider.getVipBlockCount());
        boolean added = false;
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            String[] keys = this.m_blocks.keySet().toArray(new String[0]);
            String[] vipKeys = this.getVips(keys);
            added |= this.fetchBlocks(ConfigProvider.getBlockCount(), keys, entries);
            if (!(added |= this.fetchBlocks(ConfigProvider.getVipBlockCount(), vipKeys, entries)) && this.m_shutdown) {
                this.stop();
            }
        }
        for (BlockPlacerEntry entry : entries) {
            this.process(entry);
        }
    }

    private boolean fetchBlocks(int blockCnt, String[] playerNames, List<BlockPlacerEntry> entries) {
        if (blockCnt <= 0 || playerNames == null || playerNames.length == 0) {
            return false;
        }
        int keyPos = 0;
        boolean added = playerNames.length > 0;
        int i = 0;
        while (i < blockCnt && added) {
            added = false;
            String player = playerNames[keyPos];
            Queue<BlockPlacerEntry> queue = this.m_blocks.get(player);
            if (queue != null) {
                int size;
                if (!queue.isEmpty()) {
                    entries.add(queue.poll());
                    added = true;
                }
                if ((size = queue.size()) < this.m_queueSoftLimit && this.m_lockedQueues.contains(player)) {
                    PluginMain.Say(PluginMain.getPlayer(player), "Your block queue is unlocked. You can use WorldEdit.");
                    this.m_lockedQueues.remove(player);
                }
                if (size == 0) {
                    this.m_blocks.remove(playerNames[keyPos]);
                }
            } else if (this.m_lockedQueues.contains(player)) {
                PluginMain.Say(PluginMain.getPlayer(player), "Your block queue is unlocked. You can use WorldEdit.");
                this.m_lockedQueues.remove(player);
            }
            keyPos = (keyPos + 1) % playerNames.length;
            ++i;
        }
        return added;
    }

    public void queueStop() {
        this.m_shutdown = true;
    }

    public void stop() {
        this.m_task.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTasks(BlockPlacerEntry entry) {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            block11: {
                boolean bypass;
                Queue<Object> queue;
                String player;
                block10: {
                    block9: {
                        AsyncEditSession editSesson = entry.getEditSession();
                        player = editSesson.getPlayer();
                        if (!this.m_blocks.containsKey(player)) {
                            queue = new ArrayDeque();
                            this.m_blocks.put(player, queue);
                        } else {
                            queue = this.m_blocks.get(player);
                        }
                        if (!this.m_lockedQueues.contains(player)) break block9;
                        return false;
                    }
                    bypass = !PermissionManager.isAllowed(PluginMain.getPlayer(player), PermissionManager.Perms.QueueBypass);
                    int size = 0;
                    for (Map.Entry<String, Queue<BlockPlacerEntry>> queueEntry : this.m_blocks.entrySet()) {
                        size += queueEntry.getValue().size();
                    }
                    if (this.m_queueMaxSize <= 0 || size <= this.m_queueMaxSize || bypass) break block10;
                    PluginMain.Say(PluginMain.getPlayer(player), "Out of space on AWE block queue.");
                    return false;
                }
                queue.add(entry);
                if (queue.size() < this.m_queueHardLimit || !bypass) break block11;
                this.m_lockedQueues.add(player);
                PluginMain.Say(PluginMain.getPlayer(player), "Your block queue is full. Wait for items to finish drawing.");
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(String player) {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            if (this.m_blocks.containsKey(player)) {
                this.m_blocks.remove(player);
            }
            if (this.m_lockedQueues.contains(player)) {
                this.m_lockedQueues.remove(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAll() {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            String[] stringArray = this.getAllPlayers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String user = stringArray[n2];
                this.purge(user);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllPlayers() {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            return this.m_blocks.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerEvents(String player) {
        BlockPlacer blockPlacer = this;
        synchronized (blockPlacer) {
            if (this.m_blocks.containsKey(player)) {
                return this.m_blocks.get(player).size();
            }
            return 0;
        }
    }

    private void process(BlockPlacerEntry entry) {
        if (entry == null) {
            return;
        }
        Vector location = entry.getLocation();
        BaseBlock block = entry.getNewBlock();
        AsyncEditSession eSession = entry.getEditSession();
        eSession.doRawSetBlock(location, block);
    }

    private String[] getVips(String[] playerNames) {
        if (playerNames == null || playerNames.length == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>(playerNames.length);
        String[] stringArray = playerNames;
        int n = playerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String login = stringArray[n2];
            Player player = PluginMain.getPlayer(login);
            if (player != null && PermissionManager.isAllowed(player, PermissionManager.Perms.QueueVip)) {
                result.add(login);
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }
}

