/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit;

import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.worldedit.WorldeditOperations;

public class ConfigProvider {
    public static final String DEFAULT_USER = "#worldedit";
    private static final int CONFIG_VERSION = 1;
    private static boolean m_defaultMode = true;
    private static boolean m_checkUpdate = false;
    private static boolean m_isConfigUpdate = false;
    private static long m_interval;
    private static int m_blocksCnt;
    private static int m_vipBlocksCnt;
    private static int m_queueHardLimit;
    private static int m_queueSoftLimit;
    private static int m_queueMaxSize;
    private static String m_configVersion;
    private static String m_logger;
    private static HashSet<WorldeditOperations> m_allowedOperations;
    private static HashSet<String> m_enabledWorlds;

    public static String getLogger() {
        return m_logger;
    }

    public static String getConfigVersion() {
        return m_configVersion;
    }

    public static boolean getCheckUpdate() {
        return m_checkUpdate;
    }

    public static long getInterval() {
        return m_interval;
    }

    public static int getBlockCount() {
        return m_blocksCnt;
    }

    public static int getVipBlockCount() {
        return m_vipBlocksCnt;
    }

    public static boolean isConfigUpdated() {
        return m_isConfigUpdate;
    }

    public static boolean isLogging(String world) {
        return m_enabledWorlds.contains(world.toLowerCase());
    }

    public static int getQueueHardLimit() {
        return m_queueHardLimit;
    }

    public static int getQueueSoftLimit() {
        return m_queueSoftLimit;
    }

    public static boolean getDefaultMode() {
        return m_defaultMode;
    }

    public static int getQueueMaxSize() {
        return m_queueMaxSize;
    }

    public static boolean load(PluginMain plugin) {
        if (plugin == null) {
            return false;
        }
        plugin.saveDefaultConfig();
        FileConfiguration config = plugin.getConfig();
        ConfigurationSection mainSection = config.getConfigurationSection("awe");
        if (mainSection == null) {
            return false;
        }
        m_configVersion = mainSection.getString("version", "?");
        m_checkUpdate = mainSection.getBoolean("checkVersion", true);
        m_isConfigUpdate = mainSection.getInt("version", 0) == 1;
        m_defaultMode = mainSection.getBoolean("defaultOn", true);
        ConfigProvider.parseRenderSection(mainSection);
        ConfigProvider.parseLoggerSection(mainSection);
        m_allowedOperations = ConfigProvider.parseOperationsSection(mainSection);
        return true;
    }

    public static boolean isAsyncAllowed(WorldeditOperations operation) {
        return m_allowedOperations.contains((Object)operation);
    }

    private static void parseRenderSection(ConfigurationSection mainSection) {
        ConfigurationSection renderSection = mainSection.getConfigurationSection("rendering");
        if (renderSection == null) {
            m_blocksCnt = 1000;
            m_vipBlocksCnt = 1000;
            m_interval = 15L;
            m_queueHardLimit = 500000;
            m_queueSoftLimit = 250000;
            m_queueMaxSize = 10000000;
        } else {
            m_blocksCnt = renderSection.getInt("blocks", 1000);
            m_vipBlocksCnt = renderSection.getInt("blocks-vip", 1000);
            m_interval = renderSection.getInt("interval", 15);
            m_queueSoftLimit = renderSection.getInt("queue-limit-soft", 250000);
            m_queueHardLimit = renderSection.getInt("queue-limit-hard", 500000);
            m_queueMaxSize = renderSection.getInt("queue-max-size", 10000000);
            if (m_queueMaxSize <= 0) {
                PluginMain.Log("Warinig: Block queue is disabled!");
            }
        }
    }

    private static HashSet<WorldeditOperations> parseOperationsSection(ConfigurationSection mainSection) {
        WorldeditOperations op;
        WorldeditOperations[] worldeditOperationsArray;
        HashSet<WorldeditOperations> result = new HashSet<WorldeditOperations>();
        for (String string : mainSection.getStringList("enabledOperations")) {
            try {
                result.add(WorldeditOperations.valueOf(string));
            }
            catch (Exception e) {
                PluginMain.Log("* unknown operation name " + string);
            }
        }
        if (result.isEmpty()) {
            PluginMain.Log("Warning: No operations defined in config file. Enabling all.");
            worldeditOperationsArray = WorldeditOperations.values();
            int n = worldeditOperationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                op = worldeditOperationsArray[n2];
                result.add(op);
                ++n2;
            }
        }
        PluginMain.Log("World edit operations:");
        worldeditOperationsArray = WorldeditOperations.values();
        int n = worldeditOperationsArray.length;
        int n3 = 0;
        while (n3 < n) {
            op = worldeditOperationsArray[n3];
            PluginMain.Log("* " + (Object)((Object)op) + "..." + (result.contains((Object)op) ? "async" : "regular"));
            ++n3;
        }
        return result;
    }

    private static void parseLoggerSection(ConfigurationSection mainSection) {
        ConfigurationSection loggerSection = mainSection.getConfigurationSection("logger");
        if (loggerSection == null) {
            m_logger = "none";
            m_enabledWorlds = new HashSet();
        } else {
            m_logger = loggerSection.getString("type", "none").toLowerCase();
            m_enabledWorlds = new HashSet();
            for (Object world : loggerSection.getStringList("worlds")) {
                if (m_enabledWorlds.contains(world = ((String)world).toLowerCase())) continue;
                m_enabledWorlds.add((String)world);
            }
            PluginMain.Log("WorldEdit logging:");
        }
        for (Object world : Bukkit.getWorlds()) {
            PluginMain.Log("* " + world.getName() + "..." + (m_enabledWorlds.contains(world.getName().toLowerCase()) ? "enabled" : "disabled"));
        }
    }
}

