/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.primesoft.asyncworldedit.BlockPlacer;
import org.primesoft.asyncworldedit.ConfigProvider;
import org.primesoft.asyncworldedit.EventListener;
import org.primesoft.asyncworldedit.Help;
import org.primesoft.asyncworldedit.PermissionManager;
import org.primesoft.asyncworldedit.VersionChecker;
import org.primesoft.asyncworldedit.blocklogger.CoreProtectLogger;
import org.primesoft.asyncworldedit.blocklogger.HawkEyeLogger;
import org.primesoft.asyncworldedit.blocklogger.IBlockLogger;
import org.primesoft.asyncworldedit.blocklogger.LogBlockLogger;
import org.primesoft.asyncworldedit.blocklogger.NoneLogger;
import org.primesoft.asyncworldedit.blocklogger.PrismLogger;
import org.primesoft.asyncworldedit.commands.JobsCommand;
import org.primesoft.asyncworldedit.commands.PurgeCommand;
import org.primesoft.asyncworldedit.commands.ToggleCommand;
import org.primesoft.asyncworldedit.mcstats.MetricsLite;
import org.primesoft.asyncworldedit.worldedit.WorldeditIntegrator;

public class PluginMain
extends JavaPlugin {
    private static final Logger s_log = Logger.getLogger("Minecraft.MCPainter");
    private static ConsoleCommandSender s_console;
    private static String s_prefix;
    private static String s_logFormat;
    private static PluginMain s_instance;
    private static final HashSet<String> s_asyncPlayers;
    private Boolean m_isInitialized = false;
    private MetricsLite m_metrics;
    private EventListener m_listener = new EventListener(this);
    private BlockPlacer m_blockPlacer;
    private WorldeditIntegrator m_weIntegrator;
    private IBlockLogger m_logger;

    static {
        s_prefix = null;
        s_logFormat = "%s %s";
        s_asyncPlayers = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAsyncMode(String player) {
        if (player == null) {
            return true;
        }
        HashSet<String> hashSet = s_asyncPlayers;
        synchronized (hashSet) {
            return s_asyncPlayers.contains(player.toLowerCase());
        }
    }

    public static void setMode(Player player) {
        boolean hasOn = PermissionManager.isAllowed(player, PermissionManager.Perms.Mode_On);
        boolean hasOff = PermissionManager.isAllowed(player, PermissionManager.Perms.Mode_Off);
        boolean def = ConfigProvider.getDefaultMode();
        if (hasOn) {
            PluginMain.setMode(player.getName(), true);
        } else if (hasOff) {
            PluginMain.setMode(player.getName(), false);
        } else {
            PluginMain.setMode(player.getName(), def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMode(String player, boolean mode) {
        if (player == null) {
            return;
        }
        HashSet<String> hashSet = s_asyncPlayers;
        synchronized (hashSet) {
            player = player.toLowerCase();
            boolean contains = s_asyncPlayers.contains(player);
            if (contains && !mode) {
                s_asyncPlayers.remove(player);
            } else if (!contains && mode) {
                s_asyncPlayers.add(player);
            }
        }
    }

    public BlockPlacer getBlockPlacer() {
        return this.m_blockPlacer;
    }

    public static String getPrefix() {
        return s_prefix;
    }

    public static Player getPlayer(String player) {
        if (s_instance == null) {
            return null;
        }
        return s_instance.getServer().getPlayer(player);
    }

    public static void Log(String msg) {
        if (s_log == null || msg == null || s_prefix == null) {
            return;
        }
        s_log.log(Level.INFO, String.format(s_logFormat, s_prefix, msg));
    }

    public static void Say(Player player, String msg) {
        if (player == null) {
            s_console.sendRawMessage(msg);
        } else {
            player.sendRawMessage(msg);
        }
    }

    public void onEnable() {
        s_instance = this;
        PluginDescriptionFile desc = this.getDescription();
        s_prefix = String.format("[%s]", desc.getName());
        this.m_isInitialized = false;
        try {
            this.m_metrics = new MetricsLite((Plugin)this);
            this.m_metrics.start();
        }
        catch (IOException e) {
            PluginMain.Log("Error initializing MCStats: " + e.getMessage());
        }
        s_console = this.getServer().getConsoleSender();
        WorldEditPlugin worldEdit = PluginMain.getWorldEdit(this);
        if (worldEdit == null) {
            PluginMain.Log("World edit not found.");
            return;
        }
        if (!ConfigProvider.load(this)) {
            PluginMain.Log("Error loading config");
            return;
        }
        this.m_blockPlacer = new BlockPlacer(this);
        if (ConfigProvider.getCheckUpdate()) {
            PluginMain.Log(VersionChecker.CheckVersion(desc.getVersion()));
        }
        if (!ConfigProvider.isConfigUpdated()) {
            PluginMain.Log("Please update your config file!");
        }
        this.m_logger = this.getLogger(ConfigProvider.getLogger());
        this.m_weIntegrator = new WorldeditIntegrator(this, worldEdit.getWorldEdit(), this.m_logger);
        this.getServer().getPluginManager().registerEvents((Listener)this.m_listener, (Plugin)this);
        this.m_isInitialized = true;
        this.setPlayerModes();
        PluginMain.Log("Enabled");
    }

    public void onDisable() {
        this.m_blockPlacer.stop();
        this.m_weIntegrator.queueStop();
        PluginMain.Log("Disabled");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String name;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!command.getName().equalsIgnoreCase("awe")) {
            return false;
        }
        String string = name = args != null && args.length > 0 ? args[0] : "";
        if (name.equalsIgnoreCase("Reload")) {
            this.doReloadConfig(player);
            return true;
        }
        if (name.equalsIgnoreCase("Help")) {
            String arg = args.length > 1 ? args[1] : null;
            return Help.ShowHelp(player, arg);
        }
        if (player == null) {
            return Help.ShowHelp(player, null);
        }
        if (name.equalsIgnoreCase("Purge")) {
            this.doPurge(player, args);
            return true;
        }
        if (name.equalsIgnoreCase("Jobs")) {
            this.doJobs(player, args);
            return true;
        }
        if (name.equalsIgnoreCase("Toggle")) {
            this.doToggle(player, args);
            return true;
        }
        return Help.ShowHelp(player, null);
    }

    private void doReloadConfig(Player player) {
        if (player != null && !PermissionManager.isAllowed(player, PermissionManager.Perms.ReloadConfig)) {
            PluginMain.Say(player, ChatColor.RED + "You have no permissions to do that.");
            return;
        }
        PluginMain.Log(player != null ? player.getName() : "console  reloading config...");
        this.reloadConfig();
        this.m_isInitialized = false;
        if (!ConfigProvider.load(this)) {
            PluginMain.Say(player, "Error loading config");
            return;
        }
        this.m_blockPlacer.queueStop();
        this.m_blockPlacer = new BlockPlacer(this);
        this.m_logger = this.getLogger(ConfigProvider.getLogger());
        this.m_weIntegrator.setLogger(this.m_logger);
        this.m_isInitialized = true;
        PluginMain.Say(player, "Config reloaded");
    }

    private void doToggle(Player player, String[] args) {
        if (!this.m_isInitialized.booleanValue()) {
            PluginMain.Say(player, ChatColor.RED + "Module not initialized, contact administrator.");
            return;
        }
        ToggleCommand.Execte(this, player, args);
    }

    private void doPurge(Player player, String[] args) {
        if (!this.m_isInitialized.booleanValue()) {
            PluginMain.Say(player, ChatColor.RED + "Module not initialized, contact administrator.");
            return;
        }
        PurgeCommand.Execte(this, player, args);
    }

    private void doJobs(Player player, String[] args) {
        if (!this.m_isInitialized.booleanValue()) {
            PluginMain.Say(player, ChatColor.RED + "Module not initialized, contact administrator.");
            return;
        }
        JobsCommand.Execte(this, player, args);
    }

    public static WorldEditPlugin getWorldEdit(JavaPlugin plugin) {
        Plugin wPlugin = plugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (wPlugin == null || !(wPlugin instanceof WorldEditPlugin)) {
            return null;
        }
        return (WorldEditPlugin)wPlugin;
    }

    private IBlockLogger getLogger(String logger) {
        if (logger.equalsIgnoreCase("logblock")) {
            return new LogBlockLogger(this);
        }
        if (logger.equalsIgnoreCase("coreprotect")) {
            return new CoreProtectLogger(this);
        }
        if (logger.equalsIgnoreCase("prism")) {
            return new PrismLogger(this);
        }
        if (logger.equalsIgnoreCase("hawkeye")) {
            return new HawkEyeLogger(this);
        }
        if (logger.equalsIgnoreCase("none")) {
            return new NoneLogger();
        }
        PluginMain.Log("Unknown logger: " + logger + ". Logger disabled.");
        return new NoneLogger();
    }

    private void setPlayerModes() {
        Player[] players;
        Player[] playerArray = players = this.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            PluginMain.setMode(player);
            ++n2;
        }
    }
}

