/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit.blocklogger;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.blocklogger.IBlockLogger;

public class CoreProtectLogger
implements IBlockLogger {
    private CoreProtectAPI m_coreProtect;
    private boolean m_isEnabled;

    public static CoreProtectAPI getCoreProtect(JavaPlugin plugin) {
        Plugin cPlugin;
        block3: {
            try {
                cPlugin = plugin.getServer().getPluginManager().getPlugin("CoreProtect");
                if (cPlugin != null && cPlugin instanceof CoreProtect) break block3;
                return null;
            }
            catch (NoClassDefFoundError ex) {
                return null;
            }
        }
        return ((CoreProtect)cPlugin).getAPI();
    }

    public CoreProtectLogger(PluginMain plugin) {
        this.m_coreProtect = CoreProtectLogger.getCoreProtect(plugin);
        if (this.m_coreProtect == null) {
            PluginMain.Log("Error initializing CoreProtect logger.");
            this.m_isEnabled = false;
        } else {
            PluginMain.Log("CoreProtect logger initialized");
            this.m_isEnabled = true;
        }
    }

    @Override
    public void LogBlock(Vector location, BaseBlock oldBlock, BaseBlock newBlock, String player, World world) {
        if (!this.m_isEnabled) {
            return;
        }
        Location l = new Location(world, (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        this.m_coreProtect.logRemoval(player, l, oldBlock.getType(), (byte)oldBlock.getData());
        this.m_coreProtect.logPlacement(player, l, newBlock.getType(), (byte)newBlock.getData());
    }
}

