/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit.blocklogger;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.blocklogger.IBlockLogger;
import uk.co.oliwali.HawkEye.DataType;
import uk.co.oliwali.HawkEye.HawkEye;
import uk.co.oliwali.HawkEye.database.DataManager;
import uk.co.oliwali.HawkEye.entry.BlockChangeEntry;
import uk.co.oliwali.HawkEye.entry.BlockEntry;
import uk.co.oliwali.HawkEye.entry.DataEntry;

public class HawkEyeLogger
implements IBlockLogger {
    private HawkEye m_hawkEye;
    private boolean m_isEnabled;

    public static HawkEye getHawkEye(JavaPlugin plugin) {
        Plugin cPlugin;
        block3: {
            try {
                cPlugin = plugin.getServer().getPluginManager().getPlugin("HawkEye");
                if (cPlugin != null && cPlugin instanceof HawkEye) break block3;
                return null;
            }
            catch (NoClassDefFoundError ex) {
                return null;
            }
        }
        return (HawkEye)cPlugin;
    }

    public HawkEyeLogger(PluginMain plugin) {
        this.m_hawkEye = HawkEyeLogger.getHawkEye(plugin);
        if (this.m_hawkEye == null) {
            PluginMain.Log("Error initializing HawkEye logger.");
            this.m_isEnabled = false;
        } else {
            PluginMain.Log("HawkEye logger initialized");
            this.m_isEnabled = true;
        }
    }

    @Override
    public void LogBlock(Vector location, BaseBlock oldBlock, BaseBlock newBlock, String player, World world) {
        if (!this.m_isEnabled) {
            return;
        }
        Location l = new Location(world, (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        if (newBlock.getType() == Material.AIR.getId()) {
            DataManager.addEntry((DataEntry)new BlockEntry(player, DataType.WORLDEDIT_BREAK, oldBlock.getType(), oldBlock.getData(), l));
        } else {
            DataManager.addEntry((DataEntry)new BlockChangeEntry(player, DataType.WORLDEDIT_PLACE, l, oldBlock.getType(), oldBlock.getData(), newBlock.getType(), newBlock.getData()));
        }
    }
}

