/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit.blocklogger;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.blocklogger.IBlockLogger;

public class LogBlockLogger
implements IBlockLogger {
    private LogBlock m_logBlock;
    private boolean m_isEnabled;

    public static LogBlock getLogBlock(JavaPlugin plugin) {
        Plugin cPlugin;
        block3: {
            try {
                cPlugin = plugin.getServer().getPluginManager().getPlugin("LogBlock");
                if (cPlugin != null && cPlugin instanceof LogBlock) break block3;
                return null;
            }
            catch (NoClassDefFoundError ex) {
                return null;
            }
        }
        return (LogBlock)cPlugin;
    }

    public LogBlockLogger(PluginMain plugin) {
        this.m_logBlock = LogBlockLogger.getLogBlock(plugin);
        if (this.m_logBlock == null) {
            PluginMain.Log("Error initializing LogBlock logger.");
            this.m_isEnabled = false;
        } else {
            PluginMain.Log("LogBlock logger initialized");
            this.m_isEnabled = true;
        }
    }

    @Override
    public void LogBlock(Vector location, BaseBlock oldBlock, BaseBlock newBlock, String player, World world) {
        if (!this.m_isEnabled) {
            return;
        }
        Location l = new Location(world, (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        Consumer consumer = this.m_logBlock.getConsumer();
        consumer.queueBlockBreak(player, l, oldBlock.getType(), (byte)oldBlock.getData());
        consumer.queueBlockPlace(player, l, newBlock.getType(), (byte)newBlock.getData());
    }
}

