/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.expression.ExpressionException;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.Map;
import java.util.Set;
import org.bukkit.World;
import org.primesoft.asyncworldedit.BlockPlacer;
import org.primesoft.asyncworldedit.BlockPlacerEntry;
import org.primesoft.asyncworldedit.ConfigProvider;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.blocklogger.IBlockLogger;
import org.primesoft.asyncworldedit.worldedit.AsyncEditSessionFactory;
import org.primesoft.asyncworldedit.worldedit.UndoSession;
import org.primesoft.asyncworldedit.worldedit.WorldeditOperations;

public class AsyncEditSession
extends EditSession {
    private String m_player;
    private BlockPlacer m_blockPlacer;
    private World m_world;
    private AsyncEditSessionFactory m_factory;
    private boolean m_asyncForced;
    private boolean m_asyncDisabled;

    public String getPlayer() {
        return this.m_player;
    }

    public AsyncEditSession(AsyncEditSessionFactory factory, PluginMain plugin, String player, LocalWorld world, int maxBlocks) {
        super(world, maxBlocks);
        this.initialize(player, plugin, world, factory);
    }

    public AsyncEditSession(AsyncEditSessionFactory factory, PluginMain plugin, String player, LocalWorld world, int maxBlocks, BlockBag blockBag) {
        super(world, maxBlocks, blockBag);
        this.initialize(player, plugin, world, factory);
    }

    public boolean rawSetBlock(Vector pt, BaseBlock block) {
        if (this.m_asyncForced || PluginMain.hasAsyncMode(this.m_player) && !this.m_asyncDisabled) {
            return this.m_blockPlacer.addTasks(new BlockPlacerEntry(this, pt, block));
        }
        return this.doRawSetBlock(pt, block);
    }

    public void flushQueue() {
        boolean queued = this.isQueueEnabled();
        super.flushQueue();
        if (queued) {
            this.resetAsync();
        }
    }

    public void undo(EditSession sess) {
        this.checkAsync(WorldeditOperations.undo);
        UndoSession undoSession = new UndoSession();
        super.undo((EditSession)undoSession);
        Map.Entry<Vector, BaseBlock>[] blocks = undoSession.getEntries();
        int i = blocks.length - 1;
        while (i >= 0) {
            Map.Entry<Vector, BaseBlock> entry = blocks[i];
            sess.smartSetBlock(entry.getKey(), entry.getValue());
            --i;
        }
        sess.flushQueue();
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
    }

    public void redo(EditSession sess) {
        this.checkAsync(WorldeditOperations.redo);
        super.redo(sess);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
    }

    public int fillXZ(Vector origin, BaseBlock block, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.fillXZ);
        int result = super.fillXZ(origin, block, radius, depth, recursive);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int fillXZ(Vector origin, Pattern pattern, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.fillXZ);
        int result = super.fillXZ(origin, pattern, radius, depth, recursive);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int removeAbove(Vector pos, int size, int height) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.removeAbove);
        int result = super.removeAbove(pos, size, height);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int removeBelow(Vector pos, int size, int height) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.removeBelow);
        int result = super.removeBelow(pos, size, height);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int removeNear(Vector pos, int blockType, int size) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.removeNear);
        int result = super.removeNear(pos, blockType, size);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int setBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.setBlocks);
        int result = super.setBlocks(region, block);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.setBlocks);
        int result = super.setBlocks(region, pattern);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int replaceBlocks(Region region, Set<BaseBlock> fromBlockTypes, BaseBlock toBlock) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.replaceBlocks);
        int result = super.replaceBlocks(region, fromBlockTypes, toBlock);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int replaceBlocks(Region region, Set<BaseBlock> fromBlockTypes, Pattern pattern) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.replaceBlocks);
        int result = super.replaceBlocks(region, fromBlockTypes, pattern);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeCuboidFaces(Region region, BaseBlock block) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeCuboidFaces);
        int result = super.makeCuboidFaces(region, block);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeCuboidFaces(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeCuboidFaces);
        int result = super.makeCuboidFaces(region, pattern);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeCuboidWalls(Region region, BaseBlock block) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeCuboidWalls);
        int result = super.makeCuboidWalls(region, block);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeCuboidWalls(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeCuboidWalls);
        int result = super.makeCuboidWalls(region, pattern);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int overlayCuboidBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.overlayCuboidBlocks);
        int result = super.overlayCuboidBlocks(region, block);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int overlayCuboidBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.overlayCuboidBlocks);
        int result = super.overlayCuboidBlocks(region, pattern);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int naturalizeCuboidBlocks(Region region) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.naturalizeCuboidBlocks);
        int result = super.naturalizeCuboidBlocks(region);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int stackCuboidRegion(Region region, Vector dir, int count, boolean copyAir) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.stackCuboidRegion);
        int result = super.stackCuboidRegion(region, dir, count, copyAir);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int moveCuboidRegion(Region region, Vector dir, int distance, boolean copyAir, BaseBlock replace) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.moveCuboidRegion);
        int result = super.moveCuboidRegion(region, dir, distance, copyAir, replace);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int drainArea(Vector pos, double radius) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.drainArea);
        int result = super.drainArea(pos, radius);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int fixLiquid(Vector pos, double radius, int moving, int stationary) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.fixLiquid);
        int result = super.fixLiquid(pos, radius, moving, stationary);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeCylinder(Vector pos, Pattern block, double radius, int height, boolean filled) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeCylinder);
        int result = super.makeCylinder(pos, block, radius, height, filled);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeCylinder(Vector pos, Pattern block, double radiusX, double radiusZ, int height, boolean filled) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeCylinder);
        int result = super.makeCylinder(pos, block, radiusX, radiusZ, height, filled);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeSphere(Vector pos, Pattern block, double radius, boolean filled) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeSphere);
        int result = super.makeSphere(pos, block, radius, filled);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeSphere(Vector pos, Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeSphere);
        int result = super.makeSphere(pos, block, radiusX, radiusY, radiusZ, filled);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makePyramid(Vector pos, Pattern block, int size, boolean filled) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makePyramid);
        int result = super.makePyramid(pos, block, size, filled);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int thaw(Vector pos, double radius) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.thaw);
        int result = super.thaw(pos, radius);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int simulateSnow(Vector pos, double radius) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.simulateSnow);
        int result = super.simulateSnow(pos, radius);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int green(Vector pos, double radius) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.green);
        int result = super.green(pos, radius);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makePumpkinPatches(Vector basePos, int size) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makePumpkinPatches);
        int result = super.makePumpkinPatches(basePos, size);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeForest(Vector basePos, int size, double density, TreeGenerator treeGenerator) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeForest);
        int result = super.makeForest(basePos, size, density, treeGenerator);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int makeShape(Region region, Vector zero, Vector unit, Pattern pattern, String expressionString, boolean hollow) throws ExpressionException, MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.makeShape);
        int result = super.makeShape(region, zero, unit, pattern, expressionString, hollow);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int deformRegion(Region region, Vector zero, Vector unit, String expressionString) throws ExpressionException, MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.deformRegion);
        int result = super.deformRegion(region, zero, unit, expressionString);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public int hollowOutRegion(Region region, int thickness, Pattern pattern) throws MaxChangedBlocksException {
        this.checkAsync(WorldeditOperations.hollowOutRegion);
        int result = super.hollowOutRegion(region, thickness, pattern);
        if (!this.isQueueEnabled()) {
            this.resetAsync();
        }
        return result;
    }

    public boolean doRawSetBlock(Vector location, BaseBlock block) {
        IBlockLogger logger = this.m_factory != null ? this.m_factory.getLogger() : null;
        String player = this.getPlayer();
        World world = this.getCBWorld();
        BaseBlock oldBlock = this.getBlock(location);
        boolean success = super.rawSetBlock(location, block);
        if (logger != null && success && world != null && ConfigProvider.isLogging(world.getName())) {
            logger.LogBlock(location, oldBlock, block, player, world);
        }
        return success;
    }

    public World getCBWorld() {
        return this.m_world;
    }

    private void initialize(String player, PluginMain plugin, LocalWorld world, AsyncEditSessionFactory factory) {
        this.m_factory = factory;
        this.m_player = player;
        this.m_blockPlacer = plugin.getBlockPlacer();
        if (world != null) {
            this.m_world = plugin.getServer().getWorld(world.getName());
        }
        this.m_asyncForced = false;
        this.m_asyncDisabled = false;
    }

    public void setAsyncForced(boolean value) {
        this.m_asyncForced = value;
    }

    public boolean isAsyncForced() {
        return this.m_asyncForced;
    }

    private void checkAsync(WorldeditOperations operation) {
        this.m_asyncDisabled = !ConfigProvider.isAsyncAllowed(operation);
    }

    private void resetAsync() {
        this.m_asyncDisabled = false;
    }
}

