/*
 * Decompiled with CFR 0.152.
 */
package org.primesoft.asyncworldedit.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EditSessionFactory;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.bags.BlockBag;
import org.primesoft.asyncworldedit.PluginMain;
import org.primesoft.asyncworldedit.blocklogger.IBlockLogger;
import org.primesoft.asyncworldedit.blocklogger.NoneLogger;
import org.primesoft.asyncworldedit.worldedit.AsyncEditSession;

public class AsyncEditSessionFactory
extends EditSessionFactory {
    private PluginMain m_parent;
    private IBlockLogger m_logger;

    public AsyncEditSessionFactory(PluginMain parent, IBlockLogger logger) {
        this.m_parent = parent;
        this.setLogger(logger);
    }

    public void setLogger(IBlockLogger logger) {
        if (logger == null) {
            logger = new NoneLogger();
        }
        this.m_logger = logger;
    }

    public IBlockLogger getLogger() {
        return this.m_logger;
    }

    public EditSession getEditSession(LocalWorld world, int maxBlocks) {
        return new AsyncEditSession(this, this.m_parent, "#worldedit", world, maxBlocks);
    }

    public EditSession getEditSession(LocalWorld world, int maxBlocks, LocalPlayer player) {
        return new AsyncEditSession(this, this.m_parent, player.getName(), world, maxBlocks);
    }

    public EditSession getEditSession(LocalWorld world, int maxBlocks, BlockBag blockBag) {
        return new AsyncEditSession(this, this.m_parent, "#worldedit", world, maxBlocks, blockBag);
    }

    public EditSession getEditSession(LocalWorld world, int maxBlocks, BlockBag blockBag, LocalPlayer player) {
        return new AsyncEditSession(this, this.m_parent, player.getName(), world, maxBlocks, blockBag);
    }
}

