/*
 * Decompiled with CFR 0.152.
 */
package com.drtshock.playervaults;

import com.drtshock.playervaults.PlayerVaults;
import com.drtshock.playervaults.commands.VaultViewInfo;
import com.drtshock.playervaults.util.DropOnDeath;
import com.drtshock.playervaults.util.Lang;
import com.drtshock.playervaults.util.VaultManager;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;

public class Listeners
implements Listener {
    public PlayerVaults plugin;
    VaultManager vm;

    public Listeners(PlayerVaults playerVaults) {
        this.vm = new VaultManager(this.plugin);
        this.plugin = playerVaults;
    }

    public void saveVault(Player p) {
        if (PlayerVaults.IN_VAULT.containsKey(p.getName())) {
            Inventory inv = p.getOpenInventory().getTopInventory();
            if (inv.getViewers().size() == 1) {
                VaultViewInfo info = PlayerVaults.IN_VAULT.get(p.getName());
                try {
                    this.vm.saveVault(inv, info.getHolder(), info.getNumber());
                }
                catch (IOException e) {
                    // empty catch block
                }
                PlayerVaults.OPENINVENTORIES.remove(info.toString());
            }
            PlayerVaults.IN_VAULT.remove(p.getName());
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        this.saveVault(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.saveVault(player);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() && PlayerVaults.UPDATE) {
            player.sendMessage(ChatColor.GREEN + "Version " + PlayerVaults.NEWVERSION + " of PlayerVaults is up for download!");
            player.sendMessage(ChatColor.GREEN + PlayerVaults.LINK + " to view the changelog and download!");
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.saveVault(player);
        if (PlayerVaults.DROP_ON_DEATH && !player.hasPermission("playervaults.ignore.drops")) {
            DropOnDeath.drop(event.getEntity());
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        HumanEntity he = event.getPlayer();
        if (he instanceof Player) {
            Player player = (Player)he;
            this.saveVault(player);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Block block;
        Player player = event.getPlayer();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && PlayerVaults.IN_VAULT.containsKey(player.getName()) && ((block = event.getClickedBlock()).getType() == Material.CHEST || block.getType() == Material.ENDER_CHEST || block.getType() == Material.FURNACE || block.getType() == Material.BURNING_FURNACE || block.getType() == Material.BREWING_STAND || block.getType() == Material.BEACON)) {
            event.setCancelled(true);
        }
        if (PlayerVaults.SET_SIGN.containsKey(player.getName())) {
            int i = PlayerVaults.SET_SIGN.get(player.getName()).getChest();
            boolean self = PlayerVaults.SET_SIGN.get(player.getName()).isSelf();
            String owner = null;
            if (!self) {
                owner = PlayerVaults.SET_SIGN.get(player.getName()).getOwner();
            }
            PlayerVaults.SET_SIGN.remove(player.getName());
            event.setCancelled(true);
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (event.getClickedBlock().getType() == Material.WALL_SIGN || event.getClickedBlock().getType() == Material.SIGN_POST) {
                    Sign s = (Sign)event.getClickedBlock().getState();
                    Location l = s.getLocation();
                    String world = l.getWorld().getName();
                    int x = l.getBlockX();
                    int y = l.getBlockY();
                    int z = l.getBlockZ();
                    if (self) {
                        this.plugin.getSigns().set(world + ";;" + x + ";;" + y + ";;" + z + ".self", (Object)self);
                    } else {
                        this.plugin.getSigns().set(world + ";;" + x + ";;" + y + ";;" + z + ".owner", (Object)owner);
                    }
                    this.plugin.getSigns().set(world + ";;" + x + ";;" + y + ";;" + z + ".chest", (Object)i);
                    this.plugin.saveSigns();
                    player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.SET_SIGN));
                } else {
                    player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.NOT_A_SIGN));
                }
            } else {
                player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.NOT_A_SIGN));
            }
            return;
        }
        Block b = event.getClickedBlock();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (b.getType() == Material.WALL_SIGN || b.getType() == Material.SIGN_POST)) {
            Location l = b.getLocation();
            String world = l.getWorld().getName();
            int x = l.getBlockX();
            int y = l.getBlockY();
            int z = l.getBlockZ();
            if (this.plugin.getSigns().getKeys(false).contains(world + ";;" + x + ";;" + y + ";;" + z)) {
                if (player.hasPermission("playervaults.signs.use")) {
                    boolean self = PlayerVaults.SIGNS.getBoolean(world + ";;" + x + ";;" + y + ";;" + z + ".self", false);
                    String owner = null;
                    if (!self) {
                        owner = PlayerVaults.SIGNS.getString(world + ";;" + x + ";;" + y + ";;" + z + ".owner");
                    }
                    int num = PlayerVaults.SIGNS.getInt(world + ";;" + x + ";;" + y + ";;" + z + ".chest");
                    Inventory inv = PlayerVaults.VM.loadVault(self ? player.getName() : owner, num);
                    player.openInventory(inv);
                    PlayerVaults.IN_VAULT.put(player.getName(), new VaultViewInfo(self ? player.getName() : owner, num));
                    event.setCancelled(true);
                    player.sendMessage(Lang.TITLE.toString() + Lang.OPEN_WITH_SIGN.toString().replace("%v", String.valueOf(num)).replace("%p", self ? player.getName() : owner));
                } else {
                    player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.NO_PERMS));
                }
            }
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        this.blockChangeCheck(event.getBlock().getLocation());
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        this.blockChangeCheck(event.getBlock().getLocation());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.blockChangeCheck(event.getBlock().getLocation());
    }

    public void blockChangeCheck(Location location) {
        String world = location.getWorld().getName();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        if (this.plugin.getSigns().getKeys(false).contains(world + ";;" + x + ";;" + y + ";;" + z)) {
            this.plugin.getSigns().set(world + ";;" + x + ";;" + y + ";;" + z, null);
            this.plugin.saveSigns();
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        EntityType type = event.getRightClicked().getType();
        if ((type == EntityType.VILLAGER || type == EntityType.MINECART) && PlayerVaults.IN_VAULT.containsKey(player.getName())) {
            event.setCancelled(true);
        }
    }
}

