/*
 * Decompiled with CFR 0.152.
 */
package com.drtshock.playervaults;

import com.drtshock.playervaults.Listeners;
import com.drtshock.playervaults.commands.Commands;
import com.drtshock.playervaults.commands.SignSetInfo;
import com.drtshock.playervaults.commands.VaultViewInfo;
import com.drtshock.playervaults.util.Lang;
import com.drtshock.playervaults.util.Metrics;
import com.drtshock.playervaults.util.Updater;
import com.drtshock.playervaults.util.VaultManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerVaults
extends JavaPlugin {
    public static PlayerVaults PLUGIN;
    public static Logger log;
    public static boolean UPDATE;
    public static String NEWVERSION;
    public static String LINK;
    public static Commands commands;
    public static HashMap<String, SignSetInfo> SET_SIGN;
    public static HashMap<String, VaultViewInfo> IN_VAULT;
    public static HashMap<String, Inventory> OPENINVENTORIES;
    public static Economy ECON;
    public static boolean DROP_ON_DEATH;
    public static int INVENTORIES_TO_DROP;
    public static boolean USE_VAULT;
    public static YamlConfiguration LANG;
    public static File LANG_FILE;
    public static YamlConfiguration SIGNS;
    public static File SIGNS_FILE;
    public static String DIRECTORY;
    public static VaultManager VM;
    public static Listeners listener;

    public void onEnable() {
        this.loadLang();
        log = this.getServer().getLogger();
        listener = new Listeners(this);
        this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
        this.loadConfig();
        this.loadSigns();
        this.startMetrics();
        this.checkUpdate();
        commands = new Commands();
        this.getCommand("pv").setExecutor((CommandExecutor)commands);
        this.getCommand("pvdel").setExecutor((CommandExecutor)commands);
        this.getCommand("pvsign").setExecutor((CommandExecutor)commands);
        this.getCommand("workbench").setExecutor((CommandExecutor)commands);
        this.setupEconomy();
        if (this.getConfig().getBoolean("drop-on-death.enabled")) {
            DROP_ON_DEATH = true;
            INVENTORIES_TO_DROP = this.getConfig().getInt("drop-on-death.inventories");
        }
        new File(DIRECTORY + File.separator + "backups").mkdirs();
        VM = new VaultManager(this);
    }

    public void onDisable() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!IN_VAULT.containsKey(p.getName())) continue;
            p.closeInventory();
        }
    }

    public void startMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkUpdate() {
        new BukkitRunnable(){

            public void run() {
                if (PlayerVaults.this.getConfig().getBoolean("check-update") && PlayerVaults.this.getConfig().getBoolean("check-update")) {
                    try {
                        Updater u = new Updater(PlayerVaults.this.getDescription().getVersion());
                        UPDATE = u.getUpdate();
                        if (UPDATE) {
                            LINK = u.getLink();
                            NEWVERSION = u.getNewVersion();
                        }
                    }
                    catch (Exception e) {
                        PlayerVaults.this.getLogger().log(Level.WARNING, "Failed to check for updates.");
                        PlayerVaults.this.getLogger().log(Level.WARNING, "Report this stack trace to gomeow.");
                        e.printStackTrace();
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        ECON = (Economy)rsp.getProvider();
        USE_VAULT = true;
        return ECON != null;
    }

    public void loadConfig() {
        File config = new File(this.getDataFolder() + File.separator + "config.yml");
        if (!config.exists()) {
            this.saveDefaultConfig();
        } else {
            this.updateConfig();
        }
    }

    public void loadSigns() {
        File signs = new File(this.getDataFolder(), "signs.yml");
        if (!signs.exists()) {
            try {
                signs.createNewFile();
            }
            catch (IOException e) {
                log.severe("PlayerVaults has encountered a fatal error trying to load the signs file.");
                log.severe("Please report this error to drtshock and gomeow.");
                e.printStackTrace();
            }
        }
        SIGNS_FILE = signs;
        SIGNS = YamlConfiguration.loadConfiguration((File)signs);
    }

    public YamlConfiguration getSigns() {
        return SIGNS;
    }

    public void saveSigns() {
        try {
            SIGNS.save(SIGNS_FILE);
        }
        catch (IOException e) {
            log.severe("PlayerVaults has encountered an error trying to save the signs file.");
            log.severe("Please report this error to drtshock and gomeow.");
            e.printStackTrace();
        }
    }

    public void updateConfig() {
        boolean checkUpdate = this.getConfig().getBoolean("check-update", true);
        boolean ecoEnabled = this.getConfig().getBoolean("economy.enabled", false);
        int ecoCreate = this.getConfig().getInt("economy.cost-to-create", 100);
        int ecoOpen = this.getConfig().getInt("economy.cost-to-open", 10);
        int ecoDelete = this.getConfig().getInt("economy.refund-on-delete", 50);
        boolean dropEnabled = this.getConfig().getBoolean("drop-on-death.enabled", false);
        int dropInvs = this.getConfig().getInt("drop-on-death.inventories", 50);
        File configFile = new File(this.getDataFolder(), "config.yml");
        configFile.delete();
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((InputStream)this.getResource("config.yml"));
        this.setInConfig("check-update", checkUpdate, conf);
        this.setInConfig("economy.enabled", ecoEnabled, conf);
        this.setInConfig("economy.cost-to-create", ecoCreate, conf);
        this.setInConfig("economy.cost-to-open", ecoOpen, conf);
        this.setInConfig("economy.refund-on-delete", ecoDelete, conf);
        this.setInConfig("drop-on-death.enabled", dropEnabled, conf);
        this.setInConfig("drop-on-death.inventories", dropInvs, conf);
        try {
            conf.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <T> void setInConfig(String path, T object, YamlConfiguration conf) {
        conf.set(path, object);
    }

    public YamlConfiguration loadLang() {
        File lang = new File(this.getDataFolder(), "lang.yml");
        if (!lang.exists()) {
            try {
                this.getDataFolder().mkdir();
                lang.createNewFile();
                InputStream defConfigStream = this.getResource("lang.yml");
                if (defConfigStream != null) {
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
                    defConfig.save(lang);
                    Lang.setFile(defConfig);
                    return defConfig;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.severe("[PlayerVaults] Couldn't create language file.");
                log.severe("[PlayerVaults] This is a fatal error. Now disabling");
                this.setEnabled(false);
            }
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)lang);
        for (Lang item : Lang.values()) {
            if (conf.getString(item.getPath()) != null) continue;
            conf.set(item.getPath(), (Object)item.getDefault());
        }
        Lang.setFile(conf);
        LANG = conf;
        LANG_FILE = lang;
        try {
            conf.save(this.getLangFile());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "PlayerVaults: Failed to save lang.yml.");
            log.log(Level.WARNING, "PlayerVaults: Report this stack trace to drtshock and gomeow.");
            e.printStackTrace();
        }
        return conf;
    }

    public YamlConfiguration getLang() {
        return LANG;
    }

    public File getLangFile() {
        return LANG_FILE;
    }

    static {
        UPDATE = false;
        NEWVERSION = "";
        LINK = "";
        SET_SIGN = new HashMap();
        IN_VAULT = new HashMap();
        OPENINVENTORIES = new HashMap();
        ECON = null;
        DROP_ON_DEATH = false;
        INVENTORIES_TO_DROP = 0;
        USE_VAULT = false;
        DIRECTORY = "plugins" + File.separator + "PlayerVaults" + File.separator + "vaults";
    }
}

