/*
 * Decompiled with CFR 0.152.
 */
package com.drtshock.playervaults.commands;

import com.drtshock.playervaults.PlayerVaults;
import com.drtshock.playervaults.util.EconomyOperations;
import com.drtshock.playervaults.util.Lang;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class VaultOperations {
    public static boolean checkPerms(CommandSender sender, int number) {
        if (sender.hasPermission("playervaults.amount." + String.valueOf(number))) {
            return true;
        }
        for (int x = number; x <= 99; ++x) {
            if (!sender.hasPermission("playervaults.amount." + String.valueOf(x))) continue;
            return true;
        }
        return false;
    }

    public static boolean openOwnVault(Player player, String arg) {
        if (arg.matches("^[0-9]{1,2}$")) {
            int number = 0;
            try {
                number = Integer.parseInt(arg);
                if (number == 0) {
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                player.sendMessage(Lang.TITLE.toString() + ChatColor.RED + (Object)((Object)Lang.MUST_BE_NUMBER));
                return false;
            }
            if (VaultOperations.checkPerms((CommandSender)player, number)) {
                if (EconomyOperations.payToOpen(player)) {
                    Inventory inv = PlayerVaults.VM.loadVault(player.getName(), number);
                    player.openInventory(inv);
                    player.sendMessage(Lang.TITLE.toString() + Lang.OPEN_VAULT.toString().replace("%v", arg));
                    return true;
                }
                player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.INSUFFICIENT_FUNDS));
                return false;
            }
            player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.NO_PERMS));
        } else {
            player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.MUST_BE_NUMBER));
        }
        return false;
    }

    public static boolean openOtherVault(Player player, String holder, String arg) {
        if (player.hasPermission("playervaults.admin")) {
            if (arg.matches("^[0-9]{1,2}$")) {
                int number = 0;
                try {
                    number = Integer.parseInt(arg);
                    if (number == 0) {
                        return false;
                    }
                }
                catch (NumberFormatException nfe) {
                    player.sendMessage(Lang.TITLE.toString() + ChatColor.RED + (Object)((Object)Lang.MUST_BE_NUMBER));
                }
                Inventory inv = PlayerVaults.VM.loadVault(holder, number);
                player.openInventory(inv);
                player.sendMessage(Lang.TITLE.toString() + Lang.OPEN_OTHER_VAULT.toString().replace("%v", arg).replace("%p", holder));
                return true;
            }
            player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.MUST_BE_NUMBER));
        } else {
            player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.NO_PERMS));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteOwnVault(Player player, String arg) {
        if (arg.matches("^[0-9]{1,2}$")) {
            int number = 0;
            try {
                number = Integer.parseInt(arg);
                if (number != 0) return;
                player.sendMessage(Lang.TITLE.toString() + ChatColor.RED + (Object)((Object)Lang.MUST_BE_NUMBER));
                return;
            }
            catch (NumberFormatException nfe) {
                player.sendMessage(Lang.TITLE.toString() + ChatColor.RED + (Object)((Object)Lang.MUST_BE_NUMBER));
                try {
                    if (!EconomyOperations.refundOnDelete(player, number)) return;
                    PlayerVaults.VM.deleteVault((CommandSender)player, player.getName(), number);
                    return;
                }
                catch (IOException e) {
                    player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.DELETE_VAULT_ERROR));
                }
                return;
            }
        } else {
            player.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.MUST_BE_NUMBER));
        }
    }

    public static void deleteOtherVault(CommandSender sender, String holder, String arg) {
        if (sender.hasPermission("playervaults.delete")) {
            if (arg.matches("^[0-9]{1,2}$")) {
                int number = 0;
                try {
                    number = Integer.parseInt(arg);
                    if (number == 0) {
                        sender.sendMessage(Lang.TITLE.toString() + ChatColor.RED + (Object)((Object)Lang.MUST_BE_NUMBER));
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    sender.sendMessage(Lang.TITLE.toString() + ChatColor.RED + (Object)((Object)Lang.MUST_BE_NUMBER));
                }
                try {
                    PlayerVaults.VM.deleteVault(sender, holder, number);
                }
                catch (IOException e) {
                    sender.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.DELETE_VAULT_ERROR));
                }
            } else {
                sender.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.MUST_BE_NUMBER));
            }
        } else {
            sender.sendMessage(Lang.TITLE.toString() + (Object)((Object)Lang.NO_PERMS));
        }
    }
}

