/*
 * Decompiled with CFR 0.152.
 */
package com.drtshock.playervaults.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Serialization {
    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, Serialization.fromJson(object.get(key)));
        }
        return map;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return Serialization.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return Serialization.toList((JSONArray)json);
        }
        return json;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(Serialization.fromJson(array.get(i)));
        }
        return list;
    }

    public static List<String> toString(Inventory inv) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack is : inv.getContents()) {
            items.add(is);
        }
        for (ConfigurationSerializable configurationSerializable : items) {
            if (configurationSerializable == null) {
                result.add("null");
                continue;
            }
            result.add(new JSONObject(Serialization.serialize(configurationSerializable)).toString());
        }
        return result;
    }

    public static Inventory toInventory(List<String> stringItems, int number) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.RED + "Vault #" + number));
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        for (String piece : stringItems) {
            if (piece.equalsIgnoreCase("null")) {
                contents.add(null);
                continue;
            }
            try {
                ItemStack item = (ItemStack)Serialization.deserialize(Serialization.toMap(new JSONObject(piece)));
                contents.add(item);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        ItemStack[] items = new ItemStack[contents.size()];
        for (int x = 0; x < contents.size(); ++x) {
            items[x] = (ItemStack)contents.get(x);
        }
        inv.setContents(items);
        return inv;
    }

    public static Map<String, Object> serialize(ConfigurationSerializable cs) {
        Map<String, Object> serialized = Serialization.recreateMap(cs.serialize());
        for (Map.Entry<String, Object> entry : serialized.entrySet()) {
            if (!(entry.getValue() instanceof ConfigurationSerializable)) continue;
            entry.setValue(Serialization.serialize((ConfigurationSerializable)entry.getValue()));
        }
        serialized.put("==", ConfigurationSerialization.getAlias(cs.getClass()));
        return serialized;
    }

    public static Map<String, Object> recreateMap(Map<String, Object> original) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static ConfigurationSerializable deserialize(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map) || !((Map)entry.getValue()).containsKey("==")) continue;
            entry.setValue(Serialization.deserialize((Map)entry.getValue()));
        }
        return ConfigurationSerialization.deserializeObject(map);
    }
}

