/*
 * Decompiled with CFR 0.152.
 */
package com.drtshock.playervaults.util;

import com.drtshock.playervaults.PlayerVaults;
import com.drtshock.playervaults.commands.VaultViewInfo;
import com.drtshock.playervaults.util.Lang;
import com.drtshock.playervaults.util.Serialization;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;

public class VaultManager {
    public PlayerVaults plugin;
    private final String directory = "plugins" + File.separator + "PlayerVaults" + File.separator + "vaults";

    public VaultManager(PlayerVaults instance) {
        this.plugin = instance;
    }

    public void saveVault(Inventory inventory, String player, int number) throws IOException {
        YamlConfiguration yaml = this.getPlayerVaultFile(player);
        yaml.set("vault" + number, null);
        List<String> list = Serialization.toString(inventory);
        String[] ser = list.toArray(new String[list.size()]);
        for (int x = 0; x < ser.length; ++x) {
            if (ser[x].equalsIgnoreCase("null")) continue;
            yaml.set("vault" + number + "." + x, (Object)ser[x]);
        }
        this.saveFile(player, yaml);
    }

    public Inventory loadVault(String holder, int number) {
        VaultViewInfo info = new VaultViewInfo(holder, number);
        Inventory inv = null;
        if (PlayerVaults.OPENINVENTORIES.containsKey(info.toString())) {
            inv = PlayerVaults.OPENINVENTORIES.get(info.toString());
        } else {
            YamlConfiguration playerFile = this.getPlayerVaultFile(holder);
            if (playerFile.getConfigurationSection("vault" + number) == null) {
                inv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_RED + "Vault #" + String.valueOf(number)));
            } else {
                ArrayList<String> data = new ArrayList<String>();
                for (int x = 0; x < 54; ++x) {
                    String line = playerFile.getString("vault" + number + "." + x);
                    if (line != null) {
                        data.add(line);
                        continue;
                    }
                    data.add("null");
                }
                inv = Serialization.toInventory(data, number);
            }
            PlayerVaults.OPENINVENTORIES.put(info.toString(), inv);
        }
        return inv;
    }

    public Inventory getVault(String holder, int number) {
        YamlConfiguration playerFile = this.getPlayerVaultFile(holder);
        List data = playerFile.getStringList("vault" + number);
        if (data == null) {
            Inventory inv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.GREEN + "Vault #" + String.valueOf(number)));
            return inv;
        }
        Inventory inv = Serialization.toInventory(data, number);
        return inv;
    }

    public void deleteVault(CommandSender sender, String holder, int number) throws IOException {
        String name = holder.toLowerCase();
        File file = new File(this.directory + File.separator + name.toLowerCase() + ".yml");
        YamlConfiguration playerFile = YamlConfiguration.loadConfiguration((File)file);
        if (file.exists()) {
            playerFile.set("vault" + number, null);
            playerFile.save(file);
        }
        if (sender.getName().equalsIgnoreCase(holder)) {
            sender.sendMessage(Lang.TITLE.toString() + Lang.DELETE_VAULT.toString().replace("%v", String.valueOf(number)));
        } else {
            sender.sendMessage(Lang.TITLE.toString() + Lang.DELETE_OTHER_VAULT.toString().replace("%v", String.valueOf(number)).replace("%p", holder));
        }
    }

    public YamlConfiguration getPlayerVaultFile(String holder) {
        File file;
        File folder = new File(this.directory);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(file = new File(this.directory + File.separator + holder.toLowerCase() + ".yml")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        YamlConfiguration playerFile = YamlConfiguration.loadConfiguration((File)file);
        return playerFile;
    }

    public void saveFile(String holder, YamlConfiguration yaml) throws IOException {
        File file = new File(this.directory + File.separator + holder.toLowerCase() + ".yml");
        if (file.exists()) {
            file.renameTo(new File(this.directory + File.separator + "backups" + File.separator + holder.toLowerCase() + ".yml"));
        }
        yaml.save(file);
    }
}

