/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.HookManager;
import org.kitteh.vanish.hooks.plugins.BPermissionsHook;
import org.kitteh.vanish.hooks.plugins.GeoIPToolsHook;
import org.kitteh.vanish.hooks.plugins.VaultHook;
import org.kitteh.vanish.metrics.MetricsOverlord;

public final class VanishAnnounceManipulator {
    private final List<String> delayedAnnouncePlayerList;
    private final VanishPlugin plugin;
    private final Map<String, Boolean> playerOnlineStatus;

    VanishAnnounceManipulator(VanishPlugin plugin) {
        this.plugin = plugin;
        this.playerOnlineStatus = new HashMap<String, Boolean>();
        this.delayedAnnouncePlayerList = new ArrayList<String>();
    }

    public void addToDelayedAnnounce(String player) {
        this.playerOnlineStatus.put(player, false);
        if (!Settings.getAutoFakeJoinSilent()) {
            return;
        }
        this.delayedAnnouncePlayerList.add(player);
    }

    public void dropDelayedAnnounce(String player) {
        this.delayedAnnouncePlayerList.remove(player);
    }

    public boolean getFakeOnlineStatus(String playerName) {
        Player player = this.plugin.getServer().getPlayerExact(playerName);
        if (player == null) {
            return false;
        }
        playerName = player.getName();
        if (this.playerOnlineStatus.containsKey(playerName)) {
            return this.playerOnlineStatus.get(playerName);
        }
        return true;
    }

    public boolean playerHasQuit(String player) {
        if (this.playerOnlineStatus.containsKey(player)) {
            return this.playerOnlineStatus.remove(player);
        }
        return true;
    }

    private String injectPlayerInformation(String message, Player player) {
        GeoIPToolsHook geoip = (GeoIPToolsHook)this.plugin.getHookManager().getHook(HookManager.HookType.GeoIPTools);
        BPermissionsHook bperms = (BPermissionsHook)this.plugin.getHookManager().getHook(HookManager.HookType.BPermissions);
        VaultHook vault = (VaultHook)this.plugin.getHookManager().getHook(HookManager.HookType.Vault);
        message = message.replace("%p", player.getName());
        message = message.replace("%d", player.getDisplayName());
        String prefix = bperms.getPrefix(player);
        if (prefix.isEmpty()) {
            prefix = vault.getPrefix(player);
        }
        message = message.replace("%up", prefix);
        String suffix = bperms.getSuffix(player);
        if (suffix.isEmpty()) {
            suffix = vault.getSuffix(player);
        }
        message = message.replace("%us", suffix);
        message = message.replace("%city", geoip.getCity(player));
        message = message.replace("%country", geoip.getCountry(player));
        return message;
    }

    void fakeJoin(Player player, boolean force) {
        if (force || !this.playerOnlineStatus.containsKey(player.getName()) || !this.playerOnlineStatus.get(player.getName()).booleanValue()) {
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + this.injectPlayerInformation(Settings.getFakeJoin(), player));
            this.plugin.getLogger().info(player.getName() + " faked joining");
            MetricsOverlord.getFakejoinTracker().increment();
            this.playerOnlineStatus.put(player.getName(), true);
        }
    }

    void fakeQuit(Player player, boolean force) {
        if (force || !this.playerOnlineStatus.containsKey(player.getName()) || this.playerOnlineStatus.get(player.getName()).booleanValue()) {
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + this.injectPlayerInformation(Settings.getFakeQuit(), player));
            this.plugin.getLogger().info(player.getName() + " faked quitting");
            MetricsOverlord.getFakequitTracker().increment();
            this.playerOnlineStatus.put(player.getName(), false);
        }
    }

    void vanishToggled(Player player) {
        if (!Settings.getAutoFakeJoinSilent() || !this.delayedAnnouncePlayerList.contains(player.getName())) {
            return;
        }
        this.fakeJoin(player, false);
        this.dropDelayedAnnounce(player.getName());
    }
}

