/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishCheck;
import org.kitteh.vanish.VanishCommand;
import org.kitteh.vanish.VanishManager;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.compat.NMSManager;
import org.kitteh.vanish.hooks.HookManager;
import org.kitteh.vanish.listeners.ListenEntity;
import org.kitteh.vanish.listeners.ListenInventory;
import org.kitteh.vanish.listeners.ListenPlayerJoin;
import org.kitteh.vanish.listeners.ListenPlayerMessages;
import org.kitteh.vanish.listeners.ListenPlayerOther;
import org.kitteh.vanish.listeners.ListenToYourHeart;
import org.kitteh.vanish.listeners.TagAPIListener;
import org.kitteh.vanish.metrics.MetricsOverlord;
import org.kitteh.vanish.staticaccess.VanishNoPacket;

public final class VanishPlugin
extends JavaPlugin {
    private final HashSet<String> haveInventoriesOpen = new HashSet();
    private String latestVersion = null;
    private boolean versionDiff = false;
    private VanishManager manager;
    private final HookManager hookManager = new HookManager(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chestFakeClose(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            this.haveInventoriesOpen.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chestFakeInUse(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            return this.haveInventoriesOpen.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chestFakeOpen(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            this.haveInventoriesOpen.add(name);
        }
    }

    public String getCurrentVersion() {
        return "3.18";
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public String getLatestKnownVersion() {
        return this.latestVersion;
    }

    public VanishManager getManager() {
        return this.manager;
    }

    public void hooksJoin(Player player) {
        this.hookManager.onJoin(player);
    }

    public void hooksQuit(Player player) {
        this.hookManager.onQuit(player);
        this.hookManager.onUnvanish(player);
    }

    public void hooksUnvanish(Player player) {
        this.hookManager.onUnvanish(player);
    }

    public void hooksVanish(Player player) {
        this.hookManager.onVanish(player);
    }

    public void messageStatusUpdate(String message) {
        this.messageStatusUpdate(message, null);
    }

    public void messageStatusUpdate(String message, Player avoid) {
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player == null || player.equals(avoid) || !VanishPerms.canSeeStatusUpdates(player)) continue;
            player.sendMessage(message);
        }
    }

    public void onDisable() {
        VanishNoPacket.setInstance(null);
        Debuggle.nah();
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player == null || !this.manager.isVanished(player)) continue;
            player.sendMessage(ChatColor.DARK_AQUA + "[Vanish] You have been forced visible by a reload.");
        }
        this.hookManager.onDisable();
        this.manager.onPluginDisable();
        this.getLogger().info("v3.18 unloaded.");
    }

    public void onEnable() {
        NMSManager.load((Plugin)this);
        VanishNoPacket.setInstance(this);
        File check = new File(this.getDataFolder(), "config.yml");
        boolean firstTimeStarting = false;
        if (!check.exists()) {
            firstTimeStarting = true;
            this.saveDefaultConfig();
            this.reloadConfig();
            if (this.getServer().getPluginManager().isPluginEnabled("Essentials")) {
                this.getConfig().set("hooks.essentials", (Object)true);
                this.getLogger().info("Detected Essentials. Enabling Essentials hook.");
                this.saveConfig();
            }
        }
        Settings.freshStart(this);
        if (this.getConfig().getBoolean("colornametags", true)) {
            if (this.getServer().getPluginManager().isPluginEnabled("TagAPI")) {
                this.getServer().getPluginManager().registerEvents((Listener)new TagAPIListener(this), (Plugin)this);
                this.getLogger().info("Using color changing features of TagAPI.");
            } else {
                this.getLogger().info("Colored nametags enabled, but I couldn't find TagAPI");
                this.getLogger().info("For awesome colored nametags on vanish, visit");
                this.getLogger().info("http://dev.bukkit.org/server-mods/tag/ ");
                this.getLogger().info("and download TagAPI.jar");
            }
        }
        if (this.getConfig().getBoolean("hooks.essentials", false)) {
            this.hookManager.getHook(HookManager.HookType.Essentials).onEnable();
        }
        this.hookManager.getHook(HookManager.HookType.GeoIPTools).onEnable();
        if (this.getConfig().getBoolean("hooks.dynmap", false)) {
            this.hookManager.getHook(HookManager.HookType.Dynmap).onEnable();
        }
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            this.hookManager.getHook(HookManager.HookType.ProtocolLib).onEnable();
        }
        final VanishPlugin self = this;
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            public void run() {
                if (VanishPlugin.this.getConfig().getBoolean("hooks.JSONAPI", false)) {
                    VanishPlugin.this.hookManager.getHook(HookManager.HookType.JSONAPI).onEnable();
                }
                MetricsOverlord.init(self);
            }
        }, 1L);
        if (this.getConfig().getBoolean("hooks.spoutcraft", false)) {
            this.hookManager.getHook(HookManager.HookType.SpoutCraft).onEnable();
        }
        this.manager = new VanishManager(this);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.setMetadata("vanished", (MetadataValue)new LazyMetadataValue((Plugin)this, LazyMetadataValue.CacheStrategy.NEVER_CACHE, (Callable)new VanishCheck(player.getName())));
        }
        boolean updateCheck = this.getConfig().getBoolean("checkupdates", true);
        if (firstTimeStarting) {
            updateCheck = false;
            this.getLogger().info("This is your first startup (or you wiped your config).");
            this.getLogger().info("In future startups, VanishNoPacket will check for updates");
            this.getLogger().info("If you dislike it, disable 'checkupdates' in the config file");
            this.getLogger().info("Note that this plugin also utilizes PluginMetrics with usage tracking");
            this.getLogger().info("If you do not want usage tracking (paranoid) disable in that config");
        }
        if (updateCheck) {
            if (this.getCurrentVersion().contains("SNAPSHOT") || this.getCurrentVersion().equals("${project.version}") || this.getCurrentVersion().endsWith("unofficial")) {
                this.getLogger().info("Not a release version. Update check disabled");
            } else {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new UpdateCheck(this), 40L, 432000L);
            }
        }
        this.getCommand("vanish").setExecutor((CommandExecutor)new VanishCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ListenEntity(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerMessages(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerJoin(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerOther(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenToYourHeart(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenInventory(this), (Plugin)this);
        this.getLogger().info("v3.18 loaded.");
    }

    public void reload() {
        this.reloadConfig();
        Settings.freshStart(this);
    }

    public boolean versionDifference() {
        return this.versionDiff;
    }

    private final class UpdateCheck
    implements Runnable {
        private final VanishPlugin plugin;

        public UpdateCheck(VanishPlugin vanishPlugin2) {
            this.plugin = vanishPlugin2;
        }

        public void run() {
            try {
                URLConnection connection = new URL("http://updates.kitteh.org/VanishNoPacket/version").openConnection();
                connection.setConnectTimeout(8000);
                connection.setReadTimeout(15000);
                connection.setRequestProperty("User-agent", "VanishNoPacket");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String version = bufferedReader.readLine();
                if (version != null) {
                    this.plugin.latestVersion = version;
                    if (!"3.18".equals(version)) {
                        this.plugin.getLogger().info("Found a different version available: " + version);
                        this.plugin.getLogger().info("Check http://www.curse.com/server-mods/minecraft/vanish");
                        this.plugin.versionDiff = true;
                    }
                    return;
                }
                bufferedReader.close();
                connection.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plugin.getLogger().info("Error: Could not check if plugin was up to date. Will try later");
        }
    }
}

