/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.hooks.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.getspout.spoutapi.SpoutManager;
import org.getspout.spoutapi.event.spout.SpoutCraftEnableEvent;
import org.getspout.spoutapi.gui.Color;
import org.getspout.spoutapi.gui.GenericGradient;
import org.getspout.spoutapi.gui.GenericLabel;
import org.getspout.spoutapi.gui.RenderPriority;
import org.getspout.spoutapi.gui.Widget;
import org.getspout.spoutapi.gui.WidgetAnchor;
import org.getspout.spoutapi.player.SpoutPlayer;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.Hook;

public final class SpoutCraftHook
extends Hook
implements Listener {
    private boolean enabled;
    private HashMap<String, String> cloaks;
    private HashMap<String, String> skins;
    private HashMap<String, String> titles;
    private HashMap<String, PlayerData> playerDataMap;
    private Color boxColor;
    private HashMap<String, StatusBar> bars;

    public SpoutCraftHook(VanishPlugin plugin) {
        super(plugin);
    }

    public void onDisable() {
        if (!this.enabled) {
            return;
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Spout")) {
            for (SpoutPlayer player : SpoutManager.getOnlinePlayers()) {
                player.getMainScreen().removeWidgets((Plugin)this.plugin);
            }
        }
        this.enabled = false;
    }

    public void onEnable() {
        this.enabled = true;
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("Spout")) {
            this.enabled = false;
            this.plugin.getLogger().info("SpoutPlugin not running but you wanted SpoutPlugin features.");
            return;
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.boxColor = new Color(0.1f, 0.1f, 0.1f, 0.4f);
        this.cloaks = new HashMap();
        this.skins = new HashMap();
        this.titles = new HashMap();
        this.bars = new HashMap();
        this.playerDataMap = new HashMap();
        File confFile = new File(this.plugin.getDataFolder(), "spoutcraft.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)confFile);
        config.options().copyDefaults(true);
        InputStream stream = this.plugin.getResource("spoutcraft.yml");
        if (stream == null) {
            this.plugin.getLogger().info("Defaults for spoutcraft.yml not loaded");
            this.plugin.getLogger().info("The /reload command is not fully supported by this plugin or Spout");
            this.enabled = false;
            return;
        }
        config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((InputStream)stream));
        try {
            config.save(confFile);
        }
        catch (IOException e) {
            this.plugin.getServer().getLogger().log(Level.SEVERE, "Could not save spoutcraft.yml", e);
        }
        for (String skinGroup : config.getConfigurationSection("skins").getKeys(false)) {
            this.skins.put(skinGroup, config.getString("skins." + skinGroup));
        }
        for (String cloakGroup : config.getConfigurationSection("cloaks").getKeys(false)) {
            this.cloaks.put(cloakGroup, config.getString("cloaks." + cloakGroup));
        }
        for (String titleGroup : config.getConfigurationSection("titles").getKeys(false)) {
            this.titles.put(titleGroup, config.getString("titles." + titleGroup).replace("%r", "\n").replace("&&", String.valueOf('\u00a7')));
        }
    }

    public void onQuit(Player player) {
        if (!this.enabled) {
            return;
        }
        final String name = player.getName();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                SpoutCraftHook.this.bars.remove(name);
            }
        }, 1L);
    }

    @EventHandler
    public void onSpoutCraftEnable(SpoutCraftEnableEvent event) {
        if (!this.enabled) {
            return;
        }
        SpoutPlayer newPlayer = event.getPlayer();
        if (!VanishPerms.canSeeAll((Player)newPlayer)) {
            return;
        }
        for (SpoutPlayer p : SpoutManager.getOnlinePlayers()) {
            if (!this.plugin.getManager().isVanished(p.getName())) continue;
            PlayerData data = this.playerDataMap.get(p.getName());
            if (data == null) {
                data = this.initPlayer((Player)p);
            }
            this.playerUpdate(p, data, newPlayer);
        }
        if (this.plugin.getManager().isVanished(newPlayer.getName())) {
            this.onVanish((Player)newPlayer);
        }
    }

    public void onUnvanish(Player revealing) {
        if (!this.enabled) {
            return;
        }
        SpoutPlayer revealingPlayer = SpoutManager.getPlayer((Player)revealing);
        this.removeStatusBar(revealingPlayer);
        for (SpoutPlayer player : SpoutManager.getOnlinePlayers()) {
            if (player == null || !player.hasPermission("vanish.see") || !player.isSpoutCraftEnabled()) continue;
            revealingPlayer.resetSkinFor(player);
            revealingPlayer.resetCapeFor(player);
            revealingPlayer.resetTitleFor(player);
        }
    }

    public void onVanish(Player vanishing) {
        if (!this.enabled) {
            return;
        }
        this.attachStatusBar(SpoutManager.getPlayer((Player)vanishing));
        PlayerData data = this.playerDataMap.get(vanishing.getName());
        if (data == null) {
            data = this.initPlayer(vanishing);
        }
        if (data.skin != null && data.cloak != null && data.title != null) {
            return;
        }
        for (SpoutPlayer player : SpoutManager.getOnlinePlayers()) {
            this.playerUpdate(SpoutManager.getPlayer((Player)vanishing), data, player);
        }
    }

    private void attachStatusBar(SpoutPlayer player) {
        if (player.isSpoutCraftEnabled() && VanishPerms.canSeeSpoutStatus((Player)player)) {
            this.getStatusBar(player).assign();
        }
    }

    private StatusBar getStatusBar(SpoutPlayer player) {
        StatusBar bar = this.bars.get(player.getName());
        if (bar == null) {
            bar = new StatusBar(player);
            this.bars.put(player.getName(), bar);
        }
        return bar;
    }

    private PlayerData initPlayer(Player player) {
        String skin = null;
        String cloak = null;
        String title = null;
        for (String skinGroup : new HashSet<String>(this.skins.keySet())) {
            if (!player.hasPermission("vanish.spout.skin." + skinGroup)) continue;
            skin = this.skins.get(skinGroup);
            break;
        }
        for (String cloakGroup : new HashSet<String>(this.cloaks.keySet())) {
            if (!player.hasPermission("vanish.spout.cloak." + cloakGroup)) continue;
            cloak = this.cloaks.get(cloakGroup);
            break;
        }
        for (String titleGroup : new HashSet<String>(this.titles.keySet())) {
            if (!player.hasPermission("vanish.spout.title." + titleGroup)) continue;
            title = this.titles.get(titleGroup).replace("%n", player.getName());
            break;
        }
        PlayerData playerData = new PlayerData(skin, cloak, title);
        this.playerDataMap.put(player.getName(), playerData);
        return playerData;
    }

    private void playerUpdate(SpoutPlayer vanished, PlayerData data, SpoutPlayer target) {
        if (target != null && target.hasPermission("vanish.see") && target.isSpoutCraftEnabled()) {
            if (data.skin != null) {
                vanished.setSkinFor(target, data.skin);
            }
            if (data.cloak != null) {
                vanished.setCapeFor(target, data.cloak);
            }
            if (data.title != null) {
                vanished.setTitleFor(target, data.title);
            }
        }
    }

    private void removeStatusBar(SpoutPlayer player) {
        if (player.isSpoutCraftEnabled() && VanishPerms.canSeeSpoutStatus((Player)player)) {
            this.getStatusBar(player).remove();
        }
    }

    private final class StatusBar {
        private final GenericLabel label = (GenericLabel)new GenericLabel(ChatColor.DARK_AQUA + "Invisible").setAnchor(WidgetAnchor.BOTTOM_LEFT).setX(20).setY(-20).setHeight(10).setWidth(40);
        private final GenericGradient box;
        private final SpoutPlayer player;

        public StatusBar(SpoutPlayer player) {
            this.box = (GenericGradient)new GenericGradient().setTopColor(SpoutCraftHook.this.boxColor).setBottomColor(SpoutCraftHook.this.boxColor).setX(18).setY(-22).setHeight(12).setWidth(45).setAnchor(WidgetAnchor.BOTTOM_LEFT).setPriority(RenderPriority.High);
            this.player = player;
        }

        public void assign() {
            this.player.getMainScreen().attachWidget((Plugin)SpoutCraftHook.this.plugin, (Widget)this.box).attachWidget((Plugin)SpoutCraftHook.this.plugin, (Widget)this.label);
        }

        public void remove() {
            this.player.getMainScreen().removeWidget((Widget)this.box).removeWidget((Widget)this.label);
        }
    }

    private final class PlayerData {
        public String skin;
        public String cloak;
        public String title;

        public PlayerData(String skin, String cloak, String title) {
            this.skin = skin;
            this.cloak = cloak;
            this.title = title;
        }
    }
}

