/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.api;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.util.Messaging;
import com.miraclem4n.mchat.MChat;
import com.miraclem4n.mchat.api.API;
import com.miraclem4n.mchat.api.Reader;
import com.miraclem4n.mchat.configs.CensorUtil;
import com.miraclem4n.mchat.types.EventType;
import com.miraclem4n.mchat.types.IndicatorType;
import com.miraclem4n.mchat.types.InfoType;
import com.miraclem4n.mchat.types.config.ConfigType;
import com.miraclem4n.mchat.types.config.LocaleType;
import com.miraclem4n.mchat.util.MessageUtil;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Parser {
    public static Boolean heroesB;
    public static Heroes heroes;
    public static Boolean townyB;

    public static void initialize(MChat instance) {
        heroesB = instance.heroesB;
        heroes = instance.heroes;
        townyB = instance.townyB;
    }

    public static String parseMessage(String pName, String world, String msg, String format) {
        Object prefix = Reader.getRawPrefix(pName, InfoType.USER, world);
        Object suffix = Reader.getRawSuffix(pName, InfoType.USER, world);
        Object group = Reader.getRawGroup(pName, InfoType.USER, world);
        String vI = ConfigType.MCHAT_VAR_INDICATOR.getString();
        if (msg == null) {
            msg = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        if (group == null) {
            group = "";
        }
        String hSClass = "";
        String hClass = "";
        String hHealth = "";
        String hHBar = "";
        String hMana = "";
        String hMBar = "";
        String hParty = "";
        String hMastered = "";
        String hLevel = "";
        String hSLevel = "";
        String hExp = "";
        String hSExp = "";
        String hEBar = "";
        String hSEBar = "";
        String tTown = "";
        String tTownName = "";
        String tTitle = "";
        String tSurname = "";
        String tResidentName = "";
        String tPrefix = "";
        String tNamePrefix = "";
        String tPostfix = "";
        String tNamePostfix = "";
        String tNation = "";
        String tNationName = "";
        String tNationTag = "";
        Double locX = (double)Parser.randomNumber(-100, 100);
        Double locY = (double)Parser.randomNumber(-100, 100);
        Double locZ = (double)Parser.randomNumber(-100, 100);
        String loc = "X: " + locX + ", " + "Y: " + locY + ", " + "Z: " + locZ;
        String healthbar = "";
        String health = String.valueOf(Parser.randomNumber(1, 20));
        String pWorld = "";
        String hungerLevel = String.valueOf(Parser.randomNumber(0, 20));
        String hungerBar = API.createBasicBar(Parser.randomNumber(0, 20).intValue(), 20.0f, 10.0f);
        String level = String.valueOf(Parser.randomNumber(1, 2));
        String exp = String.valueOf(Parser.randomNumber(0, 200)) + "/" + (Parser.randomNumber(1, 2) + 1) * 10;
        String expBar = API.createBasicBar(Parser.randomNumber(0, 200).intValue(), (Parser.randomNumber(1, 2) + 1) * 10, 10.0f);
        String tExp = String.valueOf(Parser.randomNumber(0, 300));
        String gMode = String.valueOf(Parser.randomNumber(0, 1));
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LocaleType.FORMAT_DATE.getRaw());
        String time = dateFormat.format(now);
        String dName = pName;
        String dType = "";
        if (MChat.isShouting.get(pName) != null && MChat.isShouting.get(pName).booleanValue()) {
            dType = LocaleType.FORMAT_SHOUT.getVal();
        } else if (ConfigType.MCHAT_CHAT_DISTANCE.getDouble() > 0.0) {
            dType = LocaleType.FORMAT_LOCAL.getVal();
        }
        String sType = "";
        if (MChat.isSpying.get(pName) != null && MChat.isSpying.get(pName).booleanValue()) {
            sType = LocaleType.FORMAT_SPY.getVal();
        }
        if (Bukkit.getServer().getPlayer(pName) != null) {
            Player player = Bukkit.getServer().getPlayer(pName);
            locX = player.getLocation().getX();
            locY = player.getLocation().getY();
            locZ = player.getLocation().getZ();
            loc = "X: " + locX + ", " + "Y: " + locY + ", " + "Z: " + locZ;
            healthbar = API.createHealthBar(player);
            health = String.valueOf(player.getHealth());
            pWorld = player.getWorld().getName();
            hungerLevel = String.valueOf(player.getFoodLevel());
            hungerBar = API.createBasicBar(player.getFoodLevel(), 20.0f, 10.0f);
            level = String.valueOf(player.getLevel());
            exp = String.valueOf(player.getExp()) + "/" + (player.getLevel() + 1) * 10;
            expBar = API.createBasicBar(player.getExp(), (player.getLevel() + 1) * 10, 10.0f);
            tExp = String.valueOf(player.getTotalExperience());
            gMode = "";
            if (player.getGameMode() != null && player.getGameMode().name() != null) {
                gMode = player.getGameMode().name();
            }
            dName = player.getDisplayName();
            if (heroesB.booleanValue()) {
                Hero hero = heroes.getCharacterManager().getHero(player);
                HeroClass heroClass = hero.getHeroClass();
                HeroClass heroSClass = hero.getSecondClass();
                int hL = hero.getLevel();
                int hSL = hero.getLevel(heroSClass);
                double hE = hero.getExperience(heroClass);
                double hSE = hero.getExperience(heroSClass);
                hClass = hero.getHeroClass().getName();
                hHealth = String.valueOf(hero.getHealth());
                hHBar = Messaging.createHealthBar((double)hero.getHealth(), (double)hero.getMaxHealth());
                hMana = String.valueOf(hero.getMana());
                hLevel = String.valueOf(hL);
                hExp = String.valueOf(hE);
                hEBar = Messaging.createExperienceBar((Hero)hero, (HeroClass)heroClass);
                Integer hMMana = hero.getMaxMana();
                if (hMMana != null) {
                    hMBar = Messaging.createManaBar((int)hero.getMana(), (int)hero.getMaxMana());
                }
                if (hero.getParty() != null) {
                    hParty = hero.getParty().toString();
                }
                if (heroSClass != null) {
                    hSClass = heroSClass.getName();
                    hSLevel = String.valueOf(hSL);
                    hSExp = String.valueOf(hSE);
                    hSEBar = Messaging.createExperienceBar((Hero)hero, (HeroClass)heroSClass);
                }
                hMastered = hero.isMaster(heroClass) && (heroSClass == null || hero.isMaster(heroSClass)) ? LocaleType.MESSAGE_HEROES_TRUE.getVal() : LocaleType.MESSAGE_HEROES_FALSE.getVal();
            }
            if (townyB.booleanValue()) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(pName);
                    if (resident.hasTown()) {
                        Town town = resident.getTown();
                        tTown = town.getName();
                        tTownName = TownyFormatter.getFormattedTownName((Town)town);
                        tTitle = resident.getTitle();
                        tSurname = resident.getSurname();
                        tResidentName = resident.getFormattedName();
                        tPrefix = resident.hasTitle() ? resident.getTitle() : TownyFormatter.getNamePrefix((Resident)resident);
                        tNamePrefix = TownyFormatter.getNamePrefix((Resident)resident);
                        tPostfix = resident.hasSurname() ? resident.getSurname() : TownyFormatter.getNamePostfix((Resident)resident);
                        tNamePostfix = TownyFormatter.getNamePostfix((Resident)resident);
                        if (resident.hasNation()) {
                            Nation nation = town.getNation();
                            tNation = nation.getName();
                            tNationName = nation.getFormattedName();
                            tNationTag = nation.getTag();
                        }
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        String formatAll = Parser.parseVars(format, pName, world);
        msg = msg.replaceAll("%", "%%");
        formatAll = formatAll.replaceAll("%", "%%");
        formatAll = MessageUtil.addColour(formatAll);
        if (ConfigType.MCHAT_CAPS_LOCK_RANGE.getInteger() > 0) {
            msg = Parser.fixCaps(msg, ConfigType.MCHAT_CAPS_LOCK_RANGE.getInteger());
        }
        if (formatAll == null) {
            return msg;
        }
        if (API.checkPermissions(pName, world, "mchat.coloredchat").booleanValue()) {
            msg = MessageUtil.addColour(msg);
        }
        if (!API.checkPermissions(pName, world, "mchat.censorbypass").booleanValue()) {
            msg = Parser.replaceCensoredWords(msg);
        }
        TreeMap<String, Object> fVarMap = new TreeMap<String, Object>();
        TreeMap<String, Object> rVarMap = new TreeMap<String, Object>();
        TreeMap<String, Object> lVarMap = new TreeMap<String, Object>();
        Parser.addVar(fVarMap, vI + "mnameformat," + vI + "mnf", LocaleType.FORMAT_NAME.getVal());
        Parser.addVar(fVarMap, vI + "healthbar," + vI + "hb", healthbar);
        Parser.addVar(rVarMap, vI + "distancetype," + vI + "dtype", dType);
        Parser.addVar(rVarMap, vI + "displayname," + vI + "dname," + vI + "dn", dName);
        Parser.addVar(rVarMap, vI + "experiencebar," + vI + "expb," + vI + "ebar," + vI + "eb", expBar);
        Parser.addVar(rVarMap, vI + "experience," + vI + "exp", exp);
        Parser.addVar(rVarMap, vI + "gamemode," + vI + "gm", gMode);
        Parser.addVar(rVarMap, vI + "group," + vI + "g", group);
        Parser.addVar(rVarMap, vI + "hungerbar," + vI + "hub", hungerBar);
        Parser.addVar(rVarMap, vI + "hunger", hungerLevel);
        Parser.addVar(rVarMap, vI + "health," + vI + "h", health);
        Parser.addVar(rVarMap, vI + "location," + vI + "loc", loc);
        Parser.addVar(rVarMap, vI + "level," + vI + "l", level);
        Parser.addVar(rVarMap, vI + "mname," + vI + "mn", Reader.getMName(pName));
        Parser.addVar(rVarMap, vI + "pname," + vI + "n", pName);
        Parser.addVar(rVarMap, vI + "prefix," + vI + "p", prefix);
        Parser.addVar(rVarMap, vI + "spying," + vI + "spy", sType);
        Parser.addVar(rVarMap, vI + "suffix," + vI + "s", suffix);
        Parser.addVar(rVarMap, vI + "totalexp," + vI + "texp," + vI + "te", tExp);
        Parser.addVar(rVarMap, vI + "time," + vI + "t", time);
        Parser.addVar(rVarMap, vI + "world," + vI + "w", pWorld);
        Parser.addVar(rVarMap, vI + "Groupname," + vI + "Gname," + vI + "G", Reader.getGroupName(group.toString()));
        Parser.addVar(rVarMap, vI + "HClass," + vI + "HC", hClass);
        Parser.addVar(rVarMap, vI + "HExp," + vI + "HEx", hExp);
        Parser.addVar(rVarMap, vI + "HEBar," + vI + "HEb", hEBar);
        Parser.addVar(rVarMap, vI + "HHBar," + vI + "HHB", hHBar);
        Parser.addVar(rVarMap, vI + "HHealth," + vI + "HH", hHealth);
        Parser.addVar(rVarMap, vI + "HLevel," + vI + "HL", hLevel);
        Parser.addVar(rVarMap, vI + "HMastered," + vI + "HMa", hMastered);
        Parser.addVar(rVarMap, vI + "HMana," + vI + "HMn", hMana);
        Parser.addVar(rVarMap, vI + "HMBar," + vI + "HMb", hMBar);
        Parser.addVar(rVarMap, vI + "HParty," + vI + "HPa", hParty);
        Parser.addVar(rVarMap, vI + "HSecClass," + vI + "HSC", hSClass);
        Parser.addVar(rVarMap, vI + "HSecExp," + vI + "HSEx", hSExp);
        Parser.addVar(rVarMap, vI + "HSecEBar," + vI + "HSEb", hSEBar);
        Parser.addVar(rVarMap, vI + "HSecLevel," + vI + "HSL", hSLevel);
        Parser.addVar(rVarMap, vI + "town", tTown);
        Parser.addVar(rVarMap, vI + "townname", tTownName);
        Parser.addVar(rVarMap, vI + "townysurname", tSurname);
        Parser.addVar(rVarMap, vI + "townytitle", tTitle);
        Parser.addVar(rVarMap, vI + "townyresidentname", tResidentName);
        Parser.addVar(rVarMap, vI + "townyprefix", tPrefix);
        Parser.addVar(rVarMap, vI + "townynameprefix", tNamePrefix);
        Parser.addVar(rVarMap, vI + "townypostfix", tPostfix);
        Parser.addVar(rVarMap, vI + "townynamepostfix", tNamePostfix);
        Parser.addVar(rVarMap, vI + "townynation", tNation);
        Parser.addVar(rVarMap, vI + "townynationname", tNationName);
        Parser.addVar(rVarMap, vI + "townynationtag", tNationTag);
        Parser.addVar(rVarMap, vI + "Worldname," + vI + "Wname," + vI + "W", Reader.getWorldName(pWorld));
        Parser.addVar(lVarMap, vI + "message," + vI + "msg," + vI + "m", msg);
        formatAll = Parser.replaceCustVars(pName, formatAll);
        formatAll = Parser.replaceVars(formatAll, fVarMap.descendingMap(), true);
        formatAll = Parser.replaceVars(formatAll, rVarMap.descendingMap(), true);
        formatAll = Parser.replaceVars(formatAll, lVarMap.descendingMap(), false);
        return formatAll;
    }

    public static String parseChatMessage(String pName, String world, String msg) {
        return Parser.parseMessage(pName, world, msg, ConfigType.FORMAT_CHAT.getString());
    }

    public static String parsePlayerName(String pName, String world) {
        return Parser.parseMessage(pName, world, "", LocaleType.FORMAT_NAME.getRaw());
    }

    public static String parseEvent(String pName, String world, EventType type) {
        return Parser.parseMessage(pName, world, "", API.replace(Reader.getEventMessage(type), "player", Parser.parsePlayerName(pName, world), IndicatorType.LOCALE_VAR));
    }

    public static String parseTabbedList(String pName, String world) {
        return Parser.parseMessage(pName, world, "", LocaleType.FORMAT_TABBED_LIST.getRaw());
    }

    public static String parseListCmd(String pName, String world) {
        return Parser.parseMessage(pName, world, "", LocaleType.FORMAT_LIST_CMD.getRaw());
    }

    public static String parseMe(String pName, String world, String msg) {
        return Parser.parseMessage(pName, world, msg, LocaleType.FORMAT_ME.getRaw());
    }

    private static TreeMap<String, Object> addVar(TreeMap<String, Object> map, String keys, Object value) {
        if (keys.contains(",")) {
            for (String s : keys.split(",")) {
                if (s == null || value == null) continue;
                map.put(s, value);
            }
        } else if (value != null) {
            map.put(keys, value);
        }
        return map;
    }

    private static String fixCaps(String format, Integer range) {
        if (range < 1) {
            return format;
        }
        Pattern pattern = Pattern.compile("([A-Z]{" + range + ",300})");
        Matcher matcher = pattern.matcher(format);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group().toLowerCase()));
        }
        matcher.appendTail(sb);
        format = sb.toString();
        return format;
    }

    private static String parseVars(String format, String pName, String world) {
        String vI = "\\" + ConfigType.MCHAT_VAR_INDICATOR.getString();
        Pattern pattern = Pattern.compile(vI + "<(.*?)>");
        Matcher matcher = pattern.matcher(format);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String var = Reader.getRawInfo(pName, InfoType.USER, world, matcher.group(1)).toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(var));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceVars(String format, Map<String, Object> map, Boolean doColour) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String value = entry.getValue().toString();
            if (doColour.booleanValue()) {
                value = MessageUtil.addColour(value);
            }
            format = format.replace(entry.getKey(), value);
        }
        return format;
    }

    private static String replaceCustVars(String pName, String format) {
        String value;
        Set<Map.Entry<String, String>> varSet = API.varMap.entrySet();
        for (Map.Entry<String, String> entry : varSet) {
            String pKey = IndicatorType.CUS_VAR.getValue() + entry.getKey().replace(pName + "|", "");
            value = entry.getValue();
            if (!format.contains(pKey)) continue;
            format = format.replace(pKey, MessageUtil.addColour(value));
        }
        for (Map.Entry<String, String> entry : varSet) {
            String gKey = IndicatorType.CUS_VAR.getValue() + entry.getKey().replace("%^global^%|", "");
            value = entry.getValue();
            if (!format.contains(gKey)) continue;
            format = format.replace(gKey, MessageUtil.addColour(value));
        }
        return format;
    }

    private static String replaceCensoredWords(String msg) {
        if (ConfigType.MCHAT_IP_CENSOR.getBoolean().booleanValue()) {
            msg = Parser.replacer(msg, "([0-9]{1,3}\\.){3}([0-9]{1,3})", "*.*.*.*");
        }
        for (Map.Entry entry : CensorUtil.getConfig().getValues(false).entrySet()) {
            String val = entry.getValue().toString();
            msg = Parser.replacer(msg, "(?i)" + (String)entry.getKey(), val);
        }
        return msg;
    }

    private static String replacer(String msg, String regex, String replacement) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(msg);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        msg = sb.toString();
        return msg;
    }

    private static Integer randomNumber(Integer minValue, Integer maxValue) {
        Random random = new Random();
        return random.nextInt(maxValue - minValue + 1) + minValue;
    }
}

