/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.api;

import com.miraclem4n.mchat.api.API;
import com.miraclem4n.mchat.configs.InfoUtil;
import com.miraclem4n.mchat.types.EventType;
import com.miraclem4n.mchat.types.InfoType;
import com.miraclem4n.mchat.types.config.ConfigType;
import com.miraclem4n.mchat.types.config.LocaleType;
import com.miraclem4n.mchat.util.MessageUtil;
import com.platymuus.bukkit.permissions.Group;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import de.bananaco.bpermissions.api.ApiLayer;
import de.bananaco.bpermissions.api.util.CalculableType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.bukkit.Bukkit;

public class Reader {
    public static Object getRawInfo(String name, InfoType type, String world, String info) {
        if (ConfigType.INFO_USE_LEVELED_NODES.getBoolean().booleanValue()) {
            return Reader.getLeveledInfo(name, world, info);
        }
        if (ConfigType.INFO_USE_OLD_NODES.getBoolean().booleanValue()) {
            return Reader.getBukkitInfo(name, world, info);
        }
        if (ConfigType.INFO_USE_NEW_INFO.getBoolean().booleanValue()) {
            return Reader.getMChatInfo(name, type, world, info);
        }
        if (API.gmB.booleanValue()) {
            return Reader.getGroupManagerInfo(name, type, world, info);
        }
        if (API.pexB.booleanValue()) {
            return Reader.getPEXInfo(name, type, world, info);
        }
        if (API.bPermB.booleanValue()) {
            return Reader.getbPermInfo(name, type, world, info);
        }
        return Reader.getMChatInfo(name, type, world, info);
    }

    public static Object getRawPrefix(String name, InfoType type, String world) {
        return Reader.getRawInfo(name, type, world, "prefix");
    }

    public static Object getRawSuffix(String name, InfoType type, String world) {
        return Reader.getRawInfo(name, type, world, "suffix");
    }

    public static Object getRawGroup(String name, InfoType type, String world) {
        return Reader.getRawInfo(name, type, world, "group");
    }

    public static String getInfo(String name, InfoType type, String world, String info) {
        return MessageUtil.addColour(Reader.getRawInfo(name, type, world, info).toString());
    }

    public static String getPrefix(String name, InfoType type, String world) {
        return Reader.getInfo(name, type, world, "prefix");
    }

    public static String getSuffix(String name, InfoType type, String world) {
        return Reader.getInfo(name, type, world, "suffix");
    }

    public static String getGroup(String name, String world) {
        return Reader.getInfo(name, InfoType.USER, world, "group");
    }

    private static Object getMChatInfo(String name, InfoType type, String world, String info) {
        if (info.equals("group")) {
            return Reader.getMChatGroup(name);
        }
        String iType = type.getName();
        if (InfoUtil.getConfig().isSet(iType + "." + name + ".info." + info)) {
            return InfoUtil.getConfig().get(iType + "." + name + ".info." + info);
        }
        if (InfoUtil.getConfig().isSet(iType + "." + name + ".worlds." + world + "." + info)) {
            return InfoUtil.getConfig().get(iType + "." + name + ".worlds." + world + "." + info);
        }
        return "";
    }

    private static Object getMChatGroup(String name) {
        if (InfoUtil.getConfig().isSet("users." + name + ".group")) {
            return InfoUtil.getConfig().get("users." + name + ".group");
        }
        return "";
    }

    private static Object getLeveledInfo(String name, String world, String info) {
        HashMap<Integer, String> iMap = new HashMap<Integer, String>();
        if (API.pBukkitB.booleanValue() && info.equals("group")) {
            return Reader.getPermBukkitGroup(name);
        }
        if (!InfoUtil.getConfig().isSet("mchat." + info)) {
            return "";
        }
        if (!InfoUtil.getConfig().isSet("rank." + info)) {
            return Reader.getBukkitInfo(name, world, info);
        }
        for (Map.Entry entry : InfoUtil.getConfig().getValues(true).entrySet()) {
            if (!((String)entry.getKey()).contains("mchat." + info + ".") || !API.checkPermissions(name, world, (String)entry.getKey()).booleanValue()) continue;
            String rVal = ((String)entry.getKey()).replaceFirst("mchat\\.", "rank.");
            if (!InfoUtil.getConfig().isSet(rVal)) continue;
            try {
                iMap.put(InfoUtil.getConfig().getInt(rVal), entry.getValue().toString());
            }
            catch (NumberFormatException ignored) {}
        }
        for (int i = 0; i < 101; ++i) {
            if (iMap.get(i) == null || ((String)iMap.get(i)).isEmpty()) continue;
            return iMap.get(i);
        }
        return Reader.getBukkitInfo(name, world, info);
    }

    private static Object getBukkitInfo(String name, String world, String info) {
        if (API.pBukkitB.booleanValue() && info.equals("group")) {
            return Reader.getPermBukkitGroup(name);
        }
        if (!InfoUtil.getConfig().isSet("mchat." + info)) {
            return "";
        }
        for (Map.Entry entry : InfoUtil.getConfig().getValues(true).entrySet()) {
            if (!((String)entry.getKey()).contains("mchat." + info + ".") || !API.checkPermissions(name, world, (String)entry.getKey()).booleanValue()) continue;
            Object infoResolve = entry.getValue();
            if (infoResolve == null || info.isEmpty()) break;
            return infoResolve;
        }
        return "";
    }

    private static String getPermBukkitGroup(String name) {
        PermissionsPlugin pBukkit = (PermissionsPlugin)Bukkit.getServer().getPluginManager().getPlugin("PermissionsBukkit");
        List pGroups = pBukkit.getGroups(name);
        try {
            return ((Group)pGroups.get(0)).getName();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private static Object getGroupManagerInfo(String name, InfoType type, String world, String info) {
        OverloadedWorldHolder gmPermissions = API.gmWH.getWorldData(world);
        if (info.equals("group")) {
            return Reader.getGroupManagerGroup(name, world);
        }
        String infoString = "";
        if (type == InfoType.USER) {
            infoString = gmPermissions.getUser(name).getVariables().getVarString(info);
        }
        if (type == InfoType.GROUP) {
            infoString = gmPermissions.getGroup(name).getVariables().getVarString(info);
        }
        return infoString;
    }

    private static String getGroupManagerGroup(String name, String world) {
        OverloadedWorldHolder gmPermissions = API.gmWH.getWorldData(world);
        String group = gmPermissions.getUser(name).getGroup().getName();
        if (group == null) {
            return "";
        }
        return group;
    }

    private static Object getPEXInfo(String name, InfoType type, String world, String info) {
        String infoString = "";
        if (info.equals("group")) {
            return Reader.getPEXGroup(name);
        }
        if (type == InfoType.USER) {
            infoString = info.equals("prefix") ? API.pexPermissions.getUser(name).getPrefix(world) : (info.equals("suffix") ? API.pexPermissions.getUser(name).getSuffix(world) : API.pexPermissions.getUser(name).getOption(info, world));
        } else if (type == InfoType.GROUP) {
            infoString = info.equals("prefix") ? API.pexPermissions.getGroup(name).getPrefix(world) : (info.equals("suffix") ? API.pexPermissions.getGroup(name).getSuffix(world) : API.pexPermissions.getGroup(name).getOption(info, world));
        }
        return infoString;
    }

    private static Object getPEXGroup(String name) {
        String[] groupNames = API.pexPermissions.getUser(name).getGroupsNames();
        String group = "";
        if (groupNames.length > 0) {
            group = API.pexPermissions.getUser(name).getGroupsNames()[0];
        }
        return group;
    }

    private static Object getbPermInfo(String name, InfoType type, String world, String info) {
        if (info.equals("group")) {
            return Reader.getbPermGroup(name, world);
        }
        String userString = "";
        if (type == InfoType.USER) {
            userString = ApiLayer.getValue((String)world, (CalculableType)CalculableType.USER, (String)name, (String)info);
        } else if (type == InfoType.GROUP) {
            userString = ApiLayer.getValue((String)world, (CalculableType)CalculableType.GROUP, (String)name, (String)info);
        }
        return userString;
    }

    private static Object getbPermGroup(String name, String world) {
        String[] groupNames = ApiLayer.getGroups((String)world, (CalculableType)CalculableType.USER, (String)name);
        String group = "";
        if (groupNames.length > 0) {
            group = ApiLayer.getGroups((String)world, (CalculableType)CalculableType.USER, (String)name)[0];
        }
        return group;
    }

    public static String getGroupName(String group) {
        if (group.isEmpty()) {
            return "";
        }
        if (InfoUtil.getConfig().isSet("groupnames." + group)) {
            return InfoUtil.getConfig().getString("groupnames." + group);
        }
        return group;
    }

    public static String getWorldName(String world) {
        if (world.isEmpty()) {
            return "";
        }
        if (InfoUtil.getConfig().isSet("worldnames." + world)) {
            return InfoUtil.getConfig().getString("worldnames." + world);
        }
        return world;
    }

    public static String getMName(String name) {
        if (InfoUtil.getConfig().isSet("mname." + name) && !InfoUtil.getConfig().getString("mname." + name).isEmpty()) {
            return InfoUtil.getConfig().getString("mname." + name);
        }
        return name;
    }

    public static String getEventMessage(EventType type) {
        if (type.getName().equalsIgnoreCase("join")) {
            return LocaleType.MESSAGE_EVENT_JOIN.getRaw();
        }
        if (type.getName().equalsIgnoreCase("kick")) {
            return LocaleType.MESSAGE_EVENT_KICK.getRaw();
        }
        if (type.getName().equalsIgnoreCase("leave")) {
            return LocaleType.MESSAGE_EVENT_LEAVE.getRaw();
        }
        return "";
    }
}

