/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.commands;

import com.miraclem4n.mchat.MChat;
import com.miraclem4n.mchat.api.API;
import com.miraclem4n.mchat.api.Parser;
import com.miraclem4n.mchat.types.IndicatorType;
import com.miraclem4n.mchat.types.config.ConfigType;
import com.miraclem4n.mchat.types.config.LocaleType;
import com.miraclem4n.mchat.util.MessageUtil;
import com.miraclem4n.mchat.util.MiscUtil;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.getspout.spoutapi.player.SpoutPlayer;

public class ReplyCommand
implements CommandExecutor {
    MChat plugin;
    String message = "";

    public ReplyCommand(MChat instance) {
        this.plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("pmchatreply") || !MiscUtil.hasCommandPerm(sender, "mchat.pm.reply").booleanValue()) {
            return true;
        }
        if (!(sender instanceof Player)) {
            MessageUtil.sendMessage(sender, "Console's can't send PM's.");
            return true;
        }
        Player player = (Player)sender;
        String pName = player.getName();
        String world = player.getWorld().getName();
        this.message = "";
        for (String arg : args) {
            this.message = this.message + " " + arg;
        }
        if (this.plugin.lastPMd.get(pName) == null) {
            MessageUtil.sendMessage((CommandSender)player, LocaleType.MESSAGE_PM_NO_PM.getVal());
            return true;
        }
        String rName = this.plugin.lastPMd.get(pName);
        Player recipient = this.plugin.getServer().getPlayer(rName);
        if (!MiscUtil.isOnlineForCommand(sender, recipient).booleanValue()) {
            return true;
        }
        String senderName = Parser.parsePlayerName(pName, world);
        HashMap<String, String> rMap = new HashMap<String, String>();
        rMap.put("recipient", Parser.parsePlayerName(rName, recipient.getWorld().getName()));
        rMap.put("sender", Parser.parsePlayerName(senderName, world));
        rMap.put("msg", this.message);
        player.sendMessage(API.replace(LocaleType.FORMAT_PM_SENT.getVal(), rMap, IndicatorType.LOCALE_VAR));
        if (this.plugin.spoutB.booleanValue()) {
            this.sendSpoutMessage(player, recipient, this.message);
            return true;
        }
        this.plugin.lastPMd.put(rName, pName);
        recipient.sendMessage(API.replace(LocaleType.FORMAT_PM_RECEIVED.getVal(), rMap, IndicatorType.LOCALE_VAR));
        MessageUtil.log(API.replace(LocaleType.FORMAT_PM_RECEIVED.getVal(), rMap, IndicatorType.LOCALE_VAR));
        return true;
    }

    void sendSpoutMessage(Player player, Player recipient, final String message) {
        SpoutPlayer sRecipient;
        if (ConfigType.MCHAT_SPOUT.getBoolean().booleanValue() && (sRecipient = (SpoutPlayer)recipient).isSpoutCraftEnabled()) {
            this.plugin.lastPMd.put(recipient.getName(), player.getName());
            sRecipient.sendNotification(LocaleType.MESSAGE_SPOUT_PM.getVal(), player.getName(), Material.PAPER);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < message.length() / 40 + 1; ++i) {
                        ReplyCommand.this.sendRunnableNotification(sRecipient, ReplyCommand.this.formatPM(message, 40 * i + 1, i * 40 + 20), ReplyCommand.this.formatPM(message, i * 40 + 21, i * 40 + 40), i);
                    }
                }
            }, 40L);
        }
    }

    void sendRunnableNotification(final SpoutPlayer recipient, final String messageA, final String messageB, Integer delay) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                recipient.sendNotification(messageA, messageB, Material.PAPER);
            }
        }, (long)(40 * delay));
    }

    String formatPM(String message, Integer start, Integer finish) {
        while (message.length() <= finish) {
            message = message + " ";
        }
        return message.substring(start, finish);
    }
}

