/*
 * Decompiled with CFR 0.152.
 */
package net.serubin.hatme;

import java.util.List;
import net.serubin.hatme.HatMe;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HatPermsHandler {
    private boolean restrictionEnabled;
    private List<Integer> unrestrictBlocks;
    private HatMe plugin;

    public HatPermsHandler(HatMe plugin, FileConfiguration config) {
        this.plugin = plugin;
        this.unrestrictBlocks = config.getIntegerList("plugin.hatme.allowed");
        this.restrictionEnabled = config.getBoolean("plugin.hatme.restrict");
    }

    protected boolean checkHatPerms(Player player) {
        return player.hasPermission("hatme.hat") || player.hasPermission("hatme.hat." + player.getItemInHand().getTypeId()) || player.getItemInHand().getTypeId() == 0;
    }

    protected boolean checkHatAllPerms(Player player) {
        return player.hasPermission("hatme.hat.all") || player.hasPermission("hatme.hat.all." + player.getItemInHand().getTypeId());
    }

    protected boolean checkGivePerms(Player player, String arg) {
        return player.hasPermission("hatme.hat.give") || player.hasPermission("hatme.hat.give." + arg);
    }

    protected boolean checkRestrict(Player player) {
        int heldItem = player.getItemInHand().getTypeId();
        if (!this.restrictionEnabled) {
            return true;
        }
        if (player.hasPermission("hatme.norestrict")) {
            return true;
        }
        return this.unrestrictBlocks.contains(heldItem);
    }

    boolean checkItemRestrict(String arg, Player player) {
        if (!this.restrictionEnabled) {
            return true;
        }
        if (player.hasPermission("hatme.norestrict")) {
            return true;
        }
        return this.unrestrictBlocks.contains(Integer.parseInt(arg));
    }
}

