/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.chat.plugins;

import com.miraclem4n.mchat.api.Reader;
import com.miraclem4n.mchat.api.Writer;
import com.miraclem4n.mchat.types.InfoType;
import in.mDev.MiracleM4n.mChatSuite.mChatSuite;
import java.util.logging.Logger;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Chat_mChatSuite
extends Chat {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "mChatSuite";
    private Plugin plugin = null;
    private mChatSuite mChat = null;

    public Chat_mChatSuite(Plugin plugin, Permission perms) {
        super(perms);
        Plugin chat;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(), plugin);
        if (this.mChat == null && (chat = plugin.getServer().getPluginManager().getPlugin("mChatSuite")) != null && chat.isEnabled()) {
            this.mChat = (mChatSuite)chat;
            log.info(String.format("[%s][Chat] %s hooked.", plugin.getDescription().getName(), "mChatSuite"));
        }
    }

    @Override
    public String getName() {
        return "mChatSuite";
    }

    @Override
    public boolean isEnabled() {
        return this.mChat != null && this.mChat.isEnabled();
    }

    @Override
    public String getPlayerPrefix(String world, String player) {
        return Reader.getPrefix((String)player, (InfoType)InfoType.USER, (String)world);
    }

    @Override
    public void setPlayerPrefix(String world, String player, String prefix) {
        this.setPlayerInfoValue(world, player, "prefix", prefix);
    }

    @Override
    public String getPlayerSuffix(String world, String player) {
        return Reader.getSuffix((String)player, (InfoType)InfoType.USER, (String)world);
    }

    @Override
    public void setPlayerSuffix(String world, String player, String suffix) {
        this.setPlayerInfoValue(world, player, "suffix", suffix);
    }

    @Override
    public String getGroupPrefix(String world, String group) {
        return Reader.getPrefix((String)group, (InfoType)InfoType.GROUP, (String)world);
    }

    @Override
    public void setGroupPrefix(String world, String group, String prefix) {
        this.setGroupInfoValue(world, group, "prefix", prefix);
    }

    @Override
    public String getGroupSuffix(String world, String group) {
        return Reader.getSuffix((String)group, (InfoType)InfoType.GROUP, (String)world);
    }

    @Override
    public void setGroupSuffix(String world, String group, String suffix) {
        this.setGroupInfoValue(world, group, "suffix", suffix);
    }

    @Override
    public int getPlayerInfoInteger(String world, String player, String node, int defaultValue) {
        String val = this.getPlayerInfoValue(world, player, node);
        if (val == null || val.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setPlayerInfoInteger(String world, String player, String node, int value) {
        this.setPlayerInfoValue(world, player, node, value);
    }

    @Override
    public int getGroupInfoInteger(String world, String group, String node, int defaultValue) {
        String val = this.getGroupInfoValue(world, group, node);
        if (val == null || val.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setGroupInfoInteger(String world, String group, String node, int value) {
        this.setGroupInfoValue(world, group, node, value);
    }

    @Override
    public double getPlayerInfoDouble(String world, String player, String node, double defaultValue) {
        String val = this.getPlayerInfoValue(world, player, node);
        if (val == null || val.equals("")) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setPlayerInfoDouble(String world, String player, String node, double value) {
        this.setPlayerInfoValue(world, player, node, value);
    }

    @Override
    public double getGroupInfoDouble(String world, String group, String node, double defaultValue) {
        String val = this.getGroupInfoValue(world, group, node);
        if (val == null || val.equals("")) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setGroupInfoDouble(String world, String group, String node, double value) {
        this.setGroupInfoValue(world, group, node, value);
    }

    @Override
    public boolean getPlayerInfoBoolean(String world, String player, String node, boolean defaultValue) {
        String val = this.getPlayerInfoValue(world, player, node);
        if (val == null || val.equals("")) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }

    @Override
    public void setPlayerInfoBoolean(String world, String player, String node, boolean value) {
        this.setPlayerInfoValue(world, player, node, value);
    }

    @Override
    public boolean getGroupInfoBoolean(String world, String group, String node, boolean defaultValue) {
        String val = this.getGroupInfoValue(world, group, node);
        if (val == null || val.equals("")) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public void setGroupInfoBoolean(String world, String group, String node, boolean value) {
        this.setGroupInfoValue(world, group, node, value);
    }

    @Override
    public String getPlayerInfoString(String world, String player, String node, String defaultValue) {
        String val = this.getPlayerInfoValue(world, player, node);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public void setPlayerInfoString(String world, String player, String node, String value) {
        this.setPlayerInfoValue(world, player, node, value);
    }

    @Override
    public String getGroupInfoString(String world, String group, String node, String defaultValue) {
        String val = this.getGroupInfoValue(world, group, node);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public void setGroupInfoString(String world, String group, String node, String value) {
        this.setGroupInfoValue(world, group, node, value);
    }

    private void setPlayerInfoValue(String world, String player, String node, Object value) {
        if (world != null) {
            Writer.setWorldVar((String)player, (InfoType)InfoType.USER, (String)world, (String)node, (Object)value.toString());
        } else {
            Writer.setInfoVar((String)player, (InfoType)InfoType.USER, (String)node, (Object)value.toString());
        }
    }

    private void setGroupInfoValue(String world, String group, String node, Object value) {
        if (world != null) {
            Writer.setWorldVar((String)group, (InfoType)InfoType.GROUP, (String)world, (String)node, (Object)value);
        } else {
            Writer.setInfoVar((String)group, (InfoType)InfoType.GROUP, (String)node, (Object)value);
        }
    }

    private String getPlayerInfoValue(String world, String player, String node) {
        return Reader.getInfo((String)player, (InfoType)InfoType.USER, (String)world, (String)node);
    }

    private String getGroupInfoValue(String world, String group, String node) {
        return Reader.getInfo((String)group, (InfoType)InfoType.GROUP, (String)world, (String)node);
    }

    public class PermissionServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin chat;
            if (Chat_mChatSuite.this.mChat == null && (chat = Chat_mChatSuite.this.plugin.getServer().getPluginManager().getPlugin("mChatSuite")) != null) {
                Chat_mChatSuite.this.mChat = (mChatSuite)chat;
                log.info(String.format("[%s][Chat] %s hooked.", Chat_mChatSuite.this.plugin.getDescription().getName(), "mChatSuite"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Chat_mChatSuite.this.mChat != null && event.getPlugin().getDescription().getName().equals("mChatSuite")) {
                Chat_mChatSuite.this.mChat = null;
                log.info(String.format("[%s][Chat] %s un-hooked.", Chat_mChatSuite.this.plugin.getDescription().getName(), "mChatSuite"));
            }
        }
    }
}

