/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.gravypod.Dosh.Dosh;
import com.gravypod.Dosh.MoneyUtils;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.plugin.Plugin;

public class Economy_Dosh
implements Economy {
    Plugin plugin;
    Dosh doshPlugin;
    DoshAPIHandler apiHandle;

    public Economy_Dosh(Plugin _plugin) {
        this.plugin = _plugin;
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("Dosh")) {
            return;
        }
        this.doshPlugin = (Dosh)this.plugin.getServer().getPluginManager().getPlugin("Dosh");
        this.apiHandle = new DoshAPIHandler();
    }

    @Override
    public boolean isEnabled() {
        return this.apiHandle != null;
    }

    @Override
    public String getName() {
        return "Dosh";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public String format(double amount) {
        return null;
    }

    @Override
    public String currencyNamePlural() {
        return Dosh.getSettings().moneyName + "s";
    }

    @Override
    public String currencyNameSingular() {
        return Dosh.getSettings().moneyName;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return true;
    }

    @Override
    public double getBalance(String playerName) {
        return DoshAPIHandler.getUserBal((String)playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) - amount > 0.0;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (DoshAPIHandler.subtractMoney((String)playerName, (Double)amount)) {
            return new EconomyResponse(amount, this.getBalance(playerName), EconomyResponse.ResponseType.SUCCESS, "Worked!");
        }
        return new EconomyResponse(amount, this.getBalance(playerName), EconomyResponse.ResponseType.FAILURE, "Didnt work!");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        DoshAPIHandler.addUserBal((String)playerName, (Double)amount);
        return new EconomyResponse(amount, this.getBalance(playerName), EconomyResponse.ResponseType.SUCCESS, "It worked!");
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "We do not use banks!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "We do not use banks!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "We do not use banks!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "We do not use banks!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "We do not use banks!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "We do not use banks!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return null;
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return null;
    }

    @Override
    public List<String> getBanks() {
        return null;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class DoshAPIHandler
    extends MoneyUtils {
    }
}

