/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import java.util.ArrayList;
import java.util.Map;
import net.crystalyx.bukkit.simplyperms.SimplyAPI;
import net.crystalyx.bukkit.simplyperms.SimplyPlugin;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_SimplyPerms
extends Permission {
    private final String name = "SimplyPerms";
    private SimplyAPI perms;

    public Permission_SimplyPerms(Plugin plugin) {
        Plugin perms;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), plugin);
        if (this.perms == null && (perms = plugin.getServer().getPluginManager().getPlugin("SimplyPerms")) != null && perms.isEnabled()) {
            this.perms = ((SimplyPlugin)perms).getAPI();
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "SimplyPerms"));
        }
    }

    @Override
    public String getName() {
        return "SimplyPerms";
    }

    @Override
    public boolean isEnabled() {
        return this.perms != null;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        permission = permission.toLowerCase();
        Map playerPermissions = this.perms.getPlayerPermissions(player, world);
        return playerPermissions.containsKey(permission) && (Boolean)playerPermissions.get(permission) != false;
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        permission = permission.toLowerCase();
        if (world != null) {
            this.perms.addPlayerPermission(player, world, permission, true);
        } else {
            this.perms.addPlayerPermission(player, permission, true);
        }
        return true;
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        permission = permission.toLowerCase();
        if (world != null) {
            this.perms.removePlayerPermission(player, world, permission);
        } else {
            this.perms.removePlayerPermission(player, permission);
        }
        return true;
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        permission = permission.toLowerCase();
        Map groupPermissions = this.perms.getGroupPermissions(group, world);
        return groupPermissions.containsKey(permission) && (Boolean)groupPermissions.get(permission) != false;
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        permission = permission.toLowerCase();
        if (world != null) {
            this.perms.addGroupPermission(group, world, permission, true);
        } else {
            this.perms.addGroupPermission(group, permission, true);
        }
        return true;
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        permission = permission.toLowerCase();
        if (world != null) {
            permission = world + ":" + permission;
            this.perms.removeGroupPermission(group, world, permission);
        } else {
            this.perms.removeGroupPermission(group, permission);
        }
        return true;
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        if (world != null) {
            for (String g : this.perms.getPlayerGroups(player)) {
                if (!g.equals(group)) continue;
                return this.perms.getGroupWorlds(group).contains(world);
            }
            return false;
        }
        if (!this.perms.getAllGroups().contains(group)) {
            return false;
        }
        return this.perms.getPlayerGroups(player).contains(group);
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        group = group.toLowerCase();
        this.perms.addPlayerGroup(player, group);
        return true;
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        group = group.toLowerCase();
        this.perms.removePlayerGroup(player, group);
        return true;
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        ArrayList<String> groupList = new ArrayList<String>();
        if (world != null && this.perms.isPlayerInDB(player)) {
            for (String group : this.perms.getPlayerGroups(player)) {
                if (!this.perms.getGroupWorlds(group).contains(world)) continue;
                groupList.add(group);
            }
            return groupList.toArray(new String[0]);
        }
        if (this.perms.isPlayerInDB(player)) {
            for (String group : this.perms.getPlayerGroups(player)) {
                groupList.add(group);
            }
        }
        return groupList.toArray(new String[0]);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        if (!this.perms.isPlayerInDB(player)) {
            return null;
        }
        if (this.perms.getPlayerGroups(player) != null && !this.perms.getPlayerGroups(player).isEmpty()) {
            return (String)this.perms.getPlayerGroups(player).get(0);
        }
        return null;
    }

    @Override
    public String[] getGroups() {
        return this.perms.getAllGroups().toArray(new String[0]);
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        Permission_SimplyPerms permission = null;

        public PermissionServerListener(Permission_SimplyPerms permission) {
            this.permission = permission;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.permission.perms == null && (perms = Permission_SimplyPerms.this.plugin.getServer().getPluginManager().getPlugin("SimplyPerms")) != null) {
                this.permission.perms = ((SimplyPlugin)perms).getAPI();
                log.info(String.format("[%s][Permission] %s hooked.", Permission_SimplyPerms.this.plugin.getDescription().getName(), "SimplyPerms"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.permission.perms != null && event.getPlugin().getDescription().getName().equals("SimplyPerms")) {
                this.permission.perms = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_SimplyPerms.this.plugin.getDescription().getName(), "SimplyPerms"));
            }
        }
    }
}

