/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect;

import java.io.File;
import net.coreprotect.CoreProtectAPI;
import net.coreprotect.Functions;
import net.coreprotect.Metrics;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.consumer.Process;
import net.coreprotect.listener.BlockListener;
import net.coreprotect.listener.EntityListener;
import net.coreprotect.listener.HangingListener;
import net.coreprotect.listener.PlayerListener;
import net.coreprotect.listener.WorldListener;
import net.coreprotect.model.Config;
import net.coreprotect.thread.CacheCleanUp;
import net.coreprotect.thread.CheckUpdate;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class CoreProtect
extends JavaPlugin {
    private CoreProtectAPI api = new CoreProtectAPI(this);
    private static CoreProtect instance;

    public CoreProtectAPI getAPI() {
        return this.api;
    }

    public static CoreProtect getInstance() {
        if (instance == null) {
            instance = new CoreProtect();
        }
        return instance;
    }

    public void onEnable() {
        instance = this;
        Consumer.initialize();
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HangingListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        if (Functions.worldEditLoaded((Plugin)this)) {
            Functions.loadWorldEdit(this);
        }
        this.getCommand("coreprotect").setExecutor((CommandExecutor)CommandHandler.getInstance());
        this.getCommand("core").setExecutor((CommandExecutor)CommandHandler.getInstance());
        this.getCommand("co").setExecutor((CommandExecutor)CommandHandler.getInstance());
        boolean start = true;
        try {
            boolean exists = new File("plugins/CoreProtect/").exists();
            if (!exists) {
                new File("plugins/CoreProtect").mkdir();
            }
            Config.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            start = false;
        }
        if (start) {
            Config.server_running = true;
            System.out.println(String.valueOf(pdfFile.getName()) + " version " + pdfFile.getVersion() + " is enabled!");
            if (Config.config.get("use-mysql") == 1) {
                System.out.println("[CoreProtect] Using MySQL for data storage.");
            } else {
                System.out.println("[CoreProtect] Using SQLite for data storage.");
            }
            if (Config.config.get("check-updates") == 1) {
                Thread checkUpdateThread = new Thread(new CheckUpdate());
                checkUpdateThread.start();
            }
            Thread cacheCleanUpThread = new Thread(new CacheCleanUp());
            cacheCleanUpThread.start();
            if (!Config.converter_running && !Config.consumer_running) {
                Thread consumerThread = new Thread(new Consumer());
                consumerThread.start();
            }
            try {
                Metrics metrics = new Metrics((Plugin)this);
                metrics.start();
            }
            catch (Exception exception) {}
        } else {
            Config.consumer_running = false;
            System.out.println("[CoreProtect] " + pdfFile.getName() + " was unable to start.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        CoreProtect.safeShutdown();
    }

    private static void safeShutdown() {
        try {
            int time_start = (int)(System.currentTimeMillis() / 1000L);
            Config.server_running = false;
            boolean message_shown = false;
            boolean process_consumer = true;
            if (Config.converter_running) {
                process_consumer = false;
            }
            while ((Config.consumer_running || Config.converter_running) && !Config.purge_running) {
                int time = (int)(System.currentTimeMillis() / 1000L);
                if (time > time_start && !message_shown) {
                    if (Config.converter_running) {
                        Functions.messageOwner("Finishing up data conversion. Please wait...");
                    } else {
                        Functions.messageOwner("Finishing up data logging. Please wait...");
                    }
                    message_shown = true;
                }
                Thread.sleep(1L);
            }
            if (message_shown) {
                System.out.println("[CoreProtect] Success! Resuming server shutdown.");
            }
            if (process_consumer) {
                Process.processConsumer(Consumer.current_consumer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

