/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class CoreProtectAPI
extends Queue {
    public static CoreProtect plugin;

    private static List<String> parseList(List<Integer> list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            for (Integer value : list) {
                result.add(Integer.toString(value));
            }
        }
        return result;
    }

    public CoreProtectAPI(CoreProtect instance) {
        plugin = instance;
    }

    public boolean isEnabled() {
        return Config.config.get("api-enabled") != null && Config.config.get("api-enabled") == 1;
    }

    public void testAPI() {
        System.out.println("[CoreProtect] API Test Successful.");
    }

    public ParseResult parseResult(String[] data) {
        return new ParseResult(data);
    }

    public List<String[]> performPartialLookup(String user, int time, int radius, Location location, List<Integer> restrict, List<Integer> exclude, int limit_offset, int limit_count) {
        if (Config.config.get("api-enabled") == 1) {
            return this.processData(user, time, radius, location, CoreProtectAPI.parseList(restrict), CoreProtectAPI.parseList(exclude), 0, 1, limit_offset, limit_count, true);
        }
        return null;
    }

    public List<String[]> performLookup(String user, int time, int radius, Location location, List<Integer> restrict, List<Integer> exclude) {
        if (Config.config.get("api-enabled") == 1) {
            return this.processData(user, time, radius, location, CoreProtectAPI.parseList(restrict), CoreProtectAPI.parseList(exclude), 0, 1, -1, -1, false);
        }
        return null;
    }

    public List<String[]> performRollback(String user, int time, int radius, Location location, List<Integer> restrict, List<Integer> exclude) {
        if (Config.config.get("api-enabled") == 1) {
            return this.processData(user, time, radius, location, CoreProtectAPI.parseList(restrict), CoreProtectAPI.parseList(exclude), 0, 2, -1, -1, false);
        }
        return null;
    }

    public List<String[]> performRestore(String user, int time, int radius, Location location, List<Integer> restrict, List<Integer> exclude) {
        if (Config.config.get("api-enabled") == 1) {
            return this.processData(user, time, radius, location, CoreProtectAPI.parseList(restrict), CoreProtectAPI.parseList(exclude), 1, 2, -1, -1, false);
        }
        return null;
    }

    private List<String[]> processData(String user, int time, int radius, Location location, List<String> restrict, List<String> exclude, int action, int lookup, int offset, int row_count, boolean use_limit) {
        List<String[]> result = new ArrayList<String[]>();
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> exclude_users = new ArrayList<String>();
        ArrayList<Integer> action_list = new ArrayList<Integer>();
        if (user == null) {
            user = "#global";
        }
        user = user.toLowerCase();
        int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
        int stime = unixtimestamp - time;
        if (radius < 1) {
            radius = -1;
        }
        if (user.equals("#global") && radius == -1) {
            return null;
        }
        if (radius > -1 && location == null) {
            return null;
        }
        try {
            Connection connection = Database.getConnection(false);
            if (connection != null) {
                Statement statement = connection.createStatement();
                users.add(user);
                boolean restrict_world = false;
                if (radius > 0) {
                    restrict_world = true;
                }
                if (location == null) {
                    restrict_world = false;
                }
                Integer[] arg_radius = null;
                if (location != null && radius > 0) {
                    int xmin = location.getBlockX() - radius;
                    int xmax = location.getBlockX() + radius;
                    int zmin = location.getBlockZ() - radius;
                    int zmax = location.getBlockZ() + radius;
                    arg_radius = new Integer[]{radius, xmin, xmax, -1, -1, zmin, zmax, 0};
                }
                if (lookup == 1) {
                    if (location != null) {
                        restrict_world = true;
                    }
                    result = use_limit ? Lookup.performPartialLookup(statement, null, users, restrict, exclude, exclude_users, action_list, location, arg_radius, stime, offset, row_count, restrict_world, true) : Lookup.performLookup(statement, null, users, restrict, exclude, exclude_users, action_list, location, arg_radius, stime, restrict_world, true);
                } else {
                    boolean verbose = false;
                    result = Lookup.performRollbackRestore(statement, null, users, null, restrict, exclude, exclude_users, action_list, location, arg_radius, stime, restrict_world, false, verbose, action, 0);
                }
                statement.close();
                connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<String[]> blockLookup(Block block, int time) {
        if (Config.config.get("api-enabled") == 1) {
            return Lookup.block_lookup_api(block, time);
        }
        return null;
    }

    public boolean logPlacement(String user, Location location, int type, byte data) {
        if (Config.config.get("api-enabled") == 1 && user != null && location != null && user.length() > 0) {
            Queue.queueBlockPlace(user, location.getBlock().getState(), type, (int)data);
            return true;
        }
        return false;
    }

    public boolean logRemoval(String user, Location location, int type, byte data) {
        if (Config.config.get("api-enabled") == 1 && user != null && location != null && user.length() > 0) {
            Queue.queueBlockBreak(user, location.getBlock().getState(), type, data);
            return true;
        }
        return false;
    }

    public boolean logInteraction(String user, Location location) {
        if (Config.config.get("api-enabled") == 1 && user != null && location != null && user.length() > 0) {
            Queue.queuePlayerInteraction(user, location.getBlock().getState());
            return true;
        }
        return false;
    }

    public boolean hasPlaced(String user, Block block, int time, int offset) {
        boolean match = false;
        if (Config.config.get("api-enabled") == 1) {
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int stime = unixtimestamp - offset;
            List<String[]> check = this.blockLookup(block, time);
            for (String[] value : check) {
                ParseResult result = this.parseResult(value);
                if (!user.equalsIgnoreCase(result.getPlayer()) || result.getActionId() != 1 || result.getTime() > stime) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public boolean hasRemoved(String user, Block block, int time, int offset) {
        boolean match = false;
        if (Config.config.get("api-enabled") == 1) {
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int stime = unixtimestamp - offset;
            List<String[]> check = this.blockLookup(block, time);
            for (String[] value : check) {
                ParseResult result = this.parseResult(value);
                if (!user.equalsIgnoreCase(result.getPlayer()) || result.getActionId() != 1 || result.getTime() > stime) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public class ParseResult {
        String[] parse = null;

        public ParseResult(String[] data) {
            this.parse = data;
        }

        public int getTime() {
            return Integer.parseInt(this.parse[0]);
        }

        public String getPlayer() {
            return this.parse[1];
        }

        public int getX() {
            return Integer.parseInt(this.parse[2]);
        }

        public int getY() {
            return Integer.parseInt(this.parse[3]);
        }

        public int getZ() {
            return Integer.parseInt(this.parse[4]);
        }

        public int getTypeId() {
            return Integer.parseInt(this.parse[5]);
        }

        public int getData() {
            return Integer.parseInt(this.parse[6]);
        }

        public int getActionId() {
            return Integer.parseInt(this.parse[7]);
        }

        public String getActionString() {
            int ActionID = Integer.parseInt(this.parse[7]);
            String result = "Unknown";
            if (ActionID == 0) {
                result = "Removal";
            } else if (ActionID == 1) {
                result = "Placement";
            } else if (ActionID == 2) {
                result = "Interaction";
            }
            return result;
        }

        public boolean isRolledBack() {
            return Integer.parseInt(this.parse[8]) == 1;
        }

        public String worldName() {
            return Functions.getWorldName(Integer.parseInt(this.parse[9]));
        }
    }
}

