/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.coreprotect.CoreProtect;
import net.coreprotect.consumer.Queue;
import net.coreprotect.model.BlockInfo;
import net.coreprotect.model.Config;
import net.coreprotect.worldedit.CoreProtectEditSessionFactory;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Art;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class Functions
extends Queue {
    public static int checkConfig(World world, String option) {
        int result = -1;
        if (Config.config.get(String.valueOf(world.getName()) + "-" + option) != null) {
            result = Config.config.get(String.valueOf(world.getName()) + "-" + option);
        } else if (Config.config.get(option) != null) {
            result = Config.config.get(option);
        }
        return result;
    }

    public static void loadWorldEdit(CoreProtect plugin) {
        try {
            int value;
            boolean validVersion = true;
            String version = plugin.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getVersion();
            if (version.contains(".")) {
                String[] version_split = version.replaceAll("[^0-9.]", "").split("\\.");
                double value2 = Double.parseDouble(String.valueOf(version_split[0]) + "." + version_split[1]);
                if (value2 > 0.0 && value2 < 5.5) {
                    validVersion = false;
                }
            } else if (version.contains("-") && (value = Integer.parseInt(version.split("-")[0].replaceAll("[^0-9]", ""))) > 0 && value < 1326) {
                validVersion = false;
            }
            if (validVersion) {
                CoreProtectEditSessionFactory.register();
            } else {
                System.out.println("[CoreProtect] Invalid WorldEdit version found.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String block_name_lookup(int id) {
        String name = "";
        if (BlockInfo.block_names.get(id) != null) {
            name = BlockInfo.block_names.get(id);
        }
        return name;
    }

    public static String block_name_short(int id) {
        String name = "";
        if (BlockInfo.block_names.get(id) != null) {
            name = BlockInfo.block_names.get(id);
            if ((name = name.replaceAll("\\(.*?\\)", "").trim()).length() > 15) {
                Object[] name_split = name.split(" ");
                ArrayUtils.reverse((Object[])name_split);
                Object new_block_name = "";
                Object[] objectArray = name_split;
                int n = name_split.length;
                int n2 = 0;
                while (n2 < n) {
                    Object name_split_string = objectArray[n2];
                    if (((String)new_block_name).length() == 0) {
                        new_block_name = name_split_string;
                    } else {
                        String name_create = String.valueOf(name_split_string) + " " + (String)new_block_name;
                        if (name_create.length() > 15) break;
                        new_block_name = name_create;
                    }
                    ++n2;
                }
                name = new_block_name;
            }
        }
        return name;
    }

    public static int block_id(String name) {
        int id = -1;
        if (BlockInfo.block_ids.get(name.toLowerCase().trim()) != null) {
            id = BlockInfo.block_ids.get(name.toLowerCase().trim());
        }
        return id;
    }

    public static boolean worldEditLoaded(Plugin pl) {
        Plugin plugin = pl.getServer().getPluginManager().getPlugin("WorldEdit");
        return plugin != null;
    }

    public static void messageOwner(String string) {
        if (string.startsWith("-")) {
            CoreProtect.getInstance().getServer().getConsoleSender().sendMessage(string);
            Player[] playerArray = CoreProtect.getInstance().getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                if (player.isOp()) {
                    player.sendMessage(string);
                }
                ++n2;
            }
        } else {
            CoreProtect.getInstance().getServer().getConsoleSender().sendMessage("[CoreProtect] " + string);
            Player[] playerArray = CoreProtect.getInstance().getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n3 = 0;
            while (n3 < n) {
                Player player = playerArray[n3];
                if (player.isOp()) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- " + string);
                }
                ++n3;
            }
        }
    }

    public static void messageOwnerAndUser(CommandSender user, String string) {
        CoreProtect.getInstance().getServer().getConsoleSender().sendMessage("[CoreProtect] " + string);
        Player[] playerArray = CoreProtect.getInstance().getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player.isOp() && !player.getName().equals(user.getName())) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- " + string);
            }
            ++n2;
        }
        if (user instanceof Player && ((Player)user).isOnline()) {
            user.sendMessage("\u00a73CoreProtect \u00a7f- " + string);
        }
    }

    public static int matchWorld(String name) {
        int id = -1;
        try {
            String result = "";
            name = name.replaceFirst("#", "").toLowerCase().trim();
            for (World world : CoreProtect.getInstance().getServer().getWorlds()) {
                String world_name = world.getName();
                if (world_name.toLowerCase().equals(name)) {
                    result = world.getName();
                    break;
                }
                if (world_name.toLowerCase().endsWith(name)) {
                    result = world.getName();
                    continue;
                }
                if (!world_name.toLowerCase().replaceAll("[^a-zA-Z0-9]", "").endsWith(name)) continue;
                result = world.getName();
            }
            if (result.length() > 0) {
                id = Functions.getWorldId(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static int getWorldId(String name) {
        int id = -1;
        try {
            if (Config.worlds.get(name) == null) {
                int wid = Config.world_id + 1;
                Config.worlds.put(name, wid);
                Config.worlds_reversed.put(wid, name);
                Config.world_id = wid;
                Queue.queueWorldInsert(wid, name);
            }
            id = Config.worlds.get(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static String getWorldName(int id) {
        String name = "";
        try {
            if (Config.worlds_reversed.get(id) != null) {
                name = Config.worlds_reversed.get(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static List<Object> processMeta(BlockState block) {
        ArrayList<Object> meta = new ArrayList<Object>();
        try {
            CommandBlock command_block;
            String command;
            int type = block.getTypeId();
            if (type == 137 && (command = (command_block = (CommandBlock)block).getCommand()).length() > 0) {
                meta.add(command);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (meta.size() == 0) {
            meta = null;
        }
        return meta;
    }

    public static byte[] convertByteData(Object data) {
        byte[] result = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(data);
            oos.flush();
            oos.close();
            bos.close();
            result = bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int getHangingDelay(Map<String, Integer> hanging_delay, int row_wid, int row_x, int row_y, int row_z) {
        String token = String.valueOf(row_wid) + "." + row_x + "." + row_y + "." + row_z;
        int delay = 0;
        if (hanging_delay.get(token) != null) {
            delay = hanging_delay.get(token) + 1;
        }
        hanging_delay.put(token, delay);
        return delay;
    }

    public static void iceBreakCheck(BlockState block, String user, int type) {
        if (type == 79) {
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int wid = Functions.getWorldId(block.getWorld().getName());
            Config.lookup_cache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid, new Object[]{unixtimestamp, user, 8});
        }
    }

    public static Block fallingSand(Block b, BlockState bs, String player) {
        Block bl = b;
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        int type = b.getTypeId();
        if (bs != null) {
            type = bs.getTypeId();
        }
        int x = b.getX();
        int y = b.getY();
        int z = b.getZ();
        World world = b.getWorld();
        int wid = Functions.getWorldId(world.getName());
        int yc = y - 1;
        if (Config.falling_block_types.contains(type)) {
            boolean bottomfound = false;
            while (!bottomfound) {
                if (yc < 0) {
                    bl = world.getBlockAt(x, yc + 1, z);
                    bottomfound = true;
                    continue;
                }
                int down = world.getBlockTypeIdAt(x, yc, z);
                if (down != 0 && down != 8 && down != 9 && down != 10 && down != 11 && down != 78) {
                    bl = world.getBlockAt(x, yc + 1, z);
                    bottomfound = true;
                } else {
                    int t;
                    String cords = x + "." + yc + "." + z + "." + wid;
                    Object[] data = Config.lookup_cache.get(cords);
                    if (data != null && type == (t = ((Integer)data[2]).intValue())) {
                        bl = world.getBlockAt(x, yc + 1, z);
                        bottomfound = true;
                    }
                }
                --yc;
            }
            Config.lookup_cache.put(x + "." + bl.getY() + "." + z + "." + wid, new Object[]{timestamp, player, type});
        }
        return bl;
    }

    public static ItemStack[] get_container_state(ItemStack[] array) {
        ItemStack[] result = (ItemStack[])array.clone();
        int c = 0;
        ItemStack[] itemStackArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            ItemStack clone = null;
            if (i != null) {
                clone = i.clone();
            }
            result[c] = clone;
            ++c;
            ++n2;
        }
        return result;
    }

    public static void combine_items(ItemStack[] items) {
        try {
            int c1 = 0;
            ItemStack[] itemStackArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack o1 = itemStackArray[n2];
                int c2 = 0;
                ItemStack[] itemStackArray2 = items;
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    ItemStack o2 = itemStackArray2[n4];
                    if (o1 != null && o2 != null && o1.isSimilar(o2) && c2 > c1) {
                        int namount = o1.getAmount() + o2.getAmount();
                        o1.setAmount(namount);
                        o2.setAmount(0);
                    }
                    ++c2;
                    ++n4;
                }
                ++c1;
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Inventory getContainerInventory(BlockState block_state, boolean singleBlock) {
        Inventory inventory = null;
        try {
            if (block_state instanceof InventoryHolder) {
                List<Integer> chests;
                if (singleBlock && (chests = Arrays.asList(54, 95, 146)).contains(block_state.getTypeId())) {
                    inventory = ((Chest)block_state).getBlockInventory();
                }
                if (inventory == null) {
                    inventory = ((InventoryHolder)block_state).getInventory();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inventory;
    }

    public static ItemStack[] getContainerContents(Block block) {
        ItemStack[] contents = null;
        if (Functions.checkConfig(block.getWorld(), "item-transactions") == 1 && Config.containers.contains(block.getTypeId())) {
            try {
                Inventory inventory = Functions.getContainerInventory(block.getState(), false);
                if (inventory != null) {
                    contents = Functions.get_container_state(inventory.getContents());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    public static void updateBlock(final BlockState block) {
        CoreProtect.getInstance().getServer().getScheduler().runTask((Plugin)CoreProtect.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    block.update();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void removeHanging(final BlockState block, int delay) {
        CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    Entity[] entityArray = block.getChunk().getEntities();
                    int n = entityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Location el;
                        Entity e = entityArray[n2];
                        if ((e instanceof ItemFrame || e instanceof Painting) && (el = e.getLocation()).getBlockX() == block.getX() && el.getBlockY() == block.getY() && el.getBlockZ() == block.getZ()) {
                            e.remove();
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long)delay);
    }

    public static void spawnHanging(final BlockState blockstate, final int row_type, final int row_data, int delay) {
        CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    Block block = blockstate.getBlock();
                    int row_x = block.getX();
                    int row_y = block.getY();
                    int row_z = block.getZ();
                    Entity[] entityArray = block.getChunk().getEntities();
                    int n = entityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Location el;
                        Entity e = entityArray[n2];
                        if ((row_type == 389 && e instanceof ItemFrame || row_type == 321 && e instanceof Painting) && (el = e.getLocation()).getBlockX() == row_x && el.getBlockY() == row_y && el.getBlockZ() == row_z) {
                            e.remove();
                            break;
                        }
                        ++n2;
                    }
                    int dx1 = row_x + 1;
                    int dx2 = row_x - 1;
                    int dz1 = row_z + 1;
                    int dz2 = row_z - 1;
                    Block c1 = block.getWorld().getBlockAt(dx1, row_y, row_z);
                    Block c2 = block.getWorld().getBlockAt(dx2, row_y, row_z);
                    Block c3 = block.getWorld().getBlockAt(row_x, row_y, dz1);
                    Block c4 = block.getWorld().getBlockAt(row_x, row_y, dz2);
                    List<Integer> non_solids = Arrays.asList(0, 6, 8, 9, 10, 11, 27, 28, 31, 32, 37, 38, 39, 40, 50, 51, 55, 65, 66, 69, 75, 76, 77, 78, 83, 90, 93, 94);
                    BlockFace face_set = null;
                    if (!non_solids.contains(c1.getTypeId())) {
                        face_set = BlockFace.WEST;
                        block = c1;
                    } else if (!non_solids.contains(c2.getTypeId())) {
                        face_set = BlockFace.EAST;
                        block = c2;
                    } else if (!non_solids.contains(c3.getTypeId())) {
                        face_set = BlockFace.NORTH;
                        block = c3;
                    } else if (!non_solids.contains(c4.getTypeId())) {
                        face_set = BlockFace.SOUTH;
                        block = c4;
                    }
                    BlockFace face = null;
                    if (Config.non_solid_entity_blocks.contains(block.getRelative(BlockFace.EAST).getTypeId())) {
                        face = BlockFace.EAST;
                    } else if (Config.non_solid_entity_blocks.contains(block.getRelative(BlockFace.NORTH).getTypeId())) {
                        face = BlockFace.NORTH;
                    } else if (Config.non_solid_entity_blocks.contains(block.getRelative(BlockFace.WEST).getTypeId())) {
                        face = BlockFace.WEST;
                    } else if (Config.non_solid_entity_blocks.contains(block.getRelative(BlockFace.SOUTH).getTypeId())) {
                        face = BlockFace.SOUTH;
                    }
                    if (face_set != null && face != null) {
                        if (row_type == 321) {
                            Art painting = Art.getById((int)row_data);
                            int height = painting.getBlockHeight();
                            int width = painting.getBlockWidth();
                            int painting_x = row_x;
                            int painting_y = row_y;
                            int painting_z = row_z;
                            if (height != 1 || width != 1) {
                                if (height > 1 && height != 3) {
                                    --painting_y;
                                }
                                if (width > 1) {
                                    if (face_set.equals((Object)BlockFace.WEST)) {
                                        --painting_z;
                                    } else if (face_set.equals((Object)BlockFace.SOUTH)) {
                                        --painting_x;
                                    }
                                }
                            }
                            Block spawn_block = block.getRelative(face);
                            int current_type = spawn_block.getTypeId();
                            byte current_data = spawn_block.getData();
                            spawn_block.setTypeIdAndData(0, (byte)0, true);
                            Painting hanging = (Painting)block.getWorld().spawn(block.getLocation(), Painting.class);
                            spawn_block.setTypeIdAndData(current_type, current_data, true);
                            hanging.teleport(block.getWorld().getBlockAt(painting_x, painting_y, painting_z).getLocation());
                            hanging.setFacingDirection(face_set, true);
                            hanging.setArt(painting);
                        } else if (row_type == 389) {
                            Block spawn_block = block.getRelative(face);
                            int current_type = spawn_block.getTypeId();
                            byte current_data = spawn_block.getData();
                            spawn_block.setTypeIdAndData(0, (byte)0, true);
                            ItemFrame hanging = (ItemFrame)block.getWorld().spawn(block.getLocation(), ItemFrame.class);
                            spawn_block.setTypeIdAndData(current_type, current_data, true);
                            hanging.teleport(block.getWorld().getBlockAt(row_x, row_y, row_z).getLocation());
                            hanging.setFacingDirection(face_set, true);
                            if (row_data > 0) {
                                ItemStack istack = new ItemStack(row_data, 1);
                                hanging.setItem(istack);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long)delay);
    }

    public static void spawnEntity(final BlockState block, final int type, final List<Object> list) {
        CoreProtect.getInstance().getServer().getScheduler().runTask((Plugin)CoreProtect.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    int count;
                    Location location = block.getLocation();
                    location.setX(location.getX() + 0.5);
                    location.setZ(location.getZ() + 0.5);
                    Entity entity = block.getLocation().getWorld().spawnEntity(location, EntityType.fromId((int)type));
                    if (list.size() == 0) {
                        return;
                    }
                    List age = (List)list.get(0);
                    List tame = (List)list.get(1);
                    List data = (List)list.get(2);
                    int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                    int wid = Functions.getWorldId(block.getWorld().getName());
                    String token = block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid + "." + type;
                    Config.entity_cache.put(token, new Object[]{unixtimestamp, entity.getEntityId()});
                    if (entity instanceof Ageable) {
                        count = 0;
                        Ageable ageable = (Ageable)entity;
                        for (Object value : age) {
                            boolean bl;
                            if (count == 0) {
                                bl = ((Integer)value).intValue();
                                ageable.setAge(bl ? 1 : 0);
                            } else if (count == 1) {
                                bl = (Boolean)value;
                                ageable.setAgeLock(bl);
                            } else if (count == 2) {
                                bl = (Boolean)value;
                                if (bl) {
                                    ageable.setAdult();
                                } else {
                                    ageable.setBaby();
                                }
                            } else if (count == 3) {
                                bl = (Boolean)value;
                                ageable.setBreed(bl);
                            }
                            ++count;
                        }
                    }
                    if (entity instanceof Tameable) {
                        count = 0;
                        Tameable tameable = (Tameable)entity;
                        for (Object value : tame) {
                            String string;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                tameable.setTamed(bl);
                            } else if (count == 1 && (string = (String)value).length() > 0) {
                                Player owner = CoreProtect.getInstance().getServer().getPlayer(string);
                                if (owner == null) {
                                    OfflinePlayer offline_player = CoreProtect.getInstance().getServer().getOfflinePlayer(string);
                                    if (offline_player != null) {
                                        tameable.setOwner((AnimalTamer)offline_player);
                                    }
                                } else {
                                    tameable.setOwner((AnimalTamer)owner);
                                }
                            }
                            ++count;
                        }
                    }
                    count = 0;
                    for (Object value : data) {
                        if (entity instanceof Creeper) {
                            Creeper creeper = (Creeper)entity;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                creeper.setPowered(bl);
                            }
                        } else if (entity instanceof Enderman) {
                            Enderman enderman = (Enderman)entity;
                            if (count == 0) {
                                Map map = (Map)value;
                                MaterialData materialdata = ItemStack.deserialize((Map)map).getData();
                                enderman.setCarriedMaterial(materialdata);
                            }
                        } else if (entity instanceof IronGolem) {
                            IronGolem irongolem = (IronGolem)entity;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                irongolem.setPlayerCreated(bl);
                            }
                        } else if (entity instanceof Ocelot) {
                            Ocelot ocelot = (Ocelot)entity;
                            if (count == 0) {
                                Ocelot.Type type2 = (Ocelot.Type)value;
                                ocelot.setCatType(type2);
                            } else if (count == 1) {
                                boolean bl = (Boolean)value;
                                ocelot.setSitting(bl);
                            }
                        } else if (entity instanceof Pig) {
                            Pig pig = (Pig)entity;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                pig.setSaddle(bl);
                            }
                        } else if (entity instanceof Sheep) {
                            Sheep sheep = (Sheep)entity;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                sheep.setSheared(bl);
                            } else if (count == 1) {
                                DyeColor dyeColor = (DyeColor)value;
                                sheep.setColor(dyeColor);
                            }
                        } else if (entity instanceof Skeleton) {
                            Skeleton skeleton = (Skeleton)entity;
                            if (count == 0) {
                                Skeleton.SkeletonType skeletonType = (Skeleton.SkeletonType)value;
                                skeleton.setSkeletonType(skeletonType);
                            }
                        } else if (entity instanceof Slime) {
                            Slime slime = (Slime)entity;
                            if (count == 0) {
                                int n = (Integer)value;
                                slime.setSize(n);
                            }
                        } else if (entity instanceof Villager) {
                            Villager villager = (Villager)entity;
                            if (count == 0) {
                                Villager.Profession profession = (Villager.Profession)value;
                                villager.setProfession(profession);
                            }
                        } else if (entity instanceof Wolf) {
                            Wolf wolf = (Wolf)entity;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                wolf.setSitting(bl);
                            } else if (count == 1) {
                                DyeColor dyeColor = (DyeColor)value;
                                wolf.setCollarColor(dyeColor);
                            }
                        } else if (entity instanceof Zombie) {
                            Zombie zombie = (Zombie)entity;
                            if (count == 0) {
                                boolean bl = (Boolean)value;
                                zombie.setBaby(bl);
                            } else if (count == 1) {
                                boolean bl = (Boolean)value;
                                zombie.setVillager(bl);
                            }
                        }
                        ++count;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static String[] toStringArray(String input) {
        int commaCount = input.replaceAll("[^,]", "").length();
        if (commaCount == 8) {
            String[] data = input.split(",");
            String action_time = data[0];
            String action_player = data[1];
            String action_cords = data[2];
            String[] datacords = action_cords.split("\\.");
            String action_x = datacords[0];
            String action_y = datacords[1];
            String action_z = datacords[2];
            String action_type = data[3];
            String action_data = data[4];
            String action_action = data[5];
            String action_rb = data[6];
            String action_wid = data[7].trim();
            return new String[]{action_time, action_player, action_x, action_y, action_z, action_type, action_data, action_action, action_rb, action_wid};
        }
        return null;
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = ((Comparable)e1.getValue()).compareTo(e2.getValue());
                return res != 0 ? res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static ItemMeta deserializeItemMeta(Class<? extends ItemMeta> itemMetaClass, Map<String, Object> args) {
        DelegateDeserialization delegate = itemMetaClass.getAnnotation(DelegateDeserialization.class);
        return (ItemMeta)ConfigurationSerialization.deserializeObject(args, (Class)delegate.value());
    }

    public static int getSpawnerType(EntityType type) {
        switch (type) {
            case ZOMBIE: {
                return 1;
            }
            case SKELETON: {
                return 2;
            }
            case SPIDER: {
                return 3;
            }
            case CAVE_SPIDER: {
                return 4;
            }
            case SILVERFISH: {
                return 5;
            }
            case BLAZE: {
                return 6;
            }
        }
        return 0;
    }

    public static EntityType getSpawnerType(int type) {
        switch (type) {
            case 1: {
                return EntityType.ZOMBIE;
            }
            case 2: {
                return EntityType.SKELETON;
            }
            case 3: {
                return EntityType.SPIDER;
            }
            case 4: {
                return EntityType.CAVE_SPIDER;
            }
            case 5: {
                return EntityType.SILVERFISH;
            }
            case 6: {
                return EntityType.BLAZE;
            }
        }
        return EntityType.PIG;
    }

    public static int getSkullType(SkullType type) {
        switch (type) {
            case SKELETON: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case PLAYER: {
                return 3;
            }
            case CREEPER: {
                return 4;
            }
        }
        return 0;
    }

    public static SkullType getSkullType(int type) {
        switch (type) {
            case 0: {
                return SkullType.SKELETON;
            }
            case 1: {
                return SkullType.WITHER;
            }
            case 2: {
                return SkullType.ZOMBIE;
            }
            case 3: {
                return SkullType.PLAYER;
            }
            case 4: {
                return SkullType.CREEPER;
            }
        }
        return SkullType.SKELETON;
    }

    public static int getBlockFace(BlockFace rotation) {
        switch (rotation) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid BlockFace rotation: " + rotation);
    }

    public static BlockFace getBlockFace(int rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        throw new AssertionError(rotation);
    }
}

