/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.command.ApplyCommand;
import net.coreprotect.command.CancelCommand;
import net.coreprotect.command.HelpCommand;
import net.coreprotect.command.InspectCommand;
import net.coreprotect.command.LookupCommand;
import net.coreprotect.command.PurgeCommand;
import net.coreprotect.command.ReloadCommand;
import net.coreprotect.command.RollbackRestoreCommand;
import net.coreprotect.command.UndoCommand;
import net.coreprotect.command.VersionCommand;
import net.coreprotect.model.Config;
import net.coreprotect.worldedit.WorldEdit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private static CommandHandler instance;
    protected static List<String> natural_blocks;

    static {
        natural_blocks = Arrays.asList("1", "2", "3", "12", "13", "14", "15", "16", "17", "18", "21", "24", "30", "31", "32", "37", "38", "39", "40", "49", "56", "59", "73", "74", "78", "79", "81", "82", "83", "86", "87", "88", "103", "104", "105", "106", "110", "111", "115", "121", "129", "141", "142");
    }

    public static CommandHandler getInstance() {
        if (instance == null) {
            instance = new CommandHandler();
        }
        return instance;
    }

    protected static Location parseLocation(CommandSender user) {
        Location location = null;
        if (user instanceof Player) {
            Player player = (Player)user;
            location = player.getLocation();
        }
        return location;
    }

    protected static boolean parseCount(String[] args_input) {
        String[] args = (String[])args_input.clone();
        boolean result = false;
        int count = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("#count") || i.equals("#sum")) {
                    result = true;
                }
            }
            ++count;
            ++n2;
        }
        return result;
    }

    protected static int parsePreview(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int result = 0;
        int count = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("#preview")) {
                    result = 1;
                } else if (i.equals("#preview_cancel")) {
                    result = 2;
                }
            }
            ++count;
            ++n2;
        }
        return result;
    }

    protected static int parseNoisy(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int noisy = 0;
        int count = 0;
        if (Config.config.get("verbose") == 1) {
            noisy = 1;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("n") || i.equals("noisy") || i.equals("v") || i.equals("verbose") || i.equals("#v") || i.equals("#verbose")) {
                    noisy = 1;
                } else if (i.equals("#silent")) {
                    noisy = 0;
                }
            }
            ++count;
            ++n2;
        }
        return noisy;
    }

    protected static int parseTime(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int time = 0;
        int count = 0;
        boolean next = false;
        double w = 0.0;
        double d = 0.0;
        double h = 0.0;
        double m = 0.0;
        double s = 0.0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("t:") || i.equals("time:")) {
                    next = true;
                } else if (next || i.startsWith("t:") || i.startsWith("time:")) {
                    String[] i2;
                    i = i.replaceAll("time:", "");
                    i = i.replaceAll("t:", "");
                    i = i.replaceAll("y", "y:");
                    i = i.replaceAll("m", "m:");
                    i = i.replaceAll("w", "w:");
                    i = i.replaceAll("d", "d:");
                    i = i.replaceAll("h", "h:");
                    i = i.replaceAll("s", "s:");
                    String[] stringArray2 = i2 = i.split(":");
                    int n3 = i2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String i4;
                        String i3 = stringArray2[n4];
                        if (i3.endsWith("w")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                w = Double.parseDouble(i4);
                            }
                        } else if (i3.endsWith("d")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                d = Double.parseDouble(i4);
                            }
                        } else if (i3.endsWith("h")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                h = Double.parseDouble(i4);
                            }
                        } else if (i3.endsWith("m")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                m = Double.parseDouble(i4);
                            }
                        } else if (i3.endsWith("s") && (i4 = i3.replaceAll("[^0-9.]", "")).length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                            s = Double.parseDouble(i4);
                        }
                        ++n4;
                    }
                    double rs = w * 7.0 * 24.0 * 60.0 * 60.0 + d * 24.0 * 60.0 * 60.0 + h * 60.0 * 60.0 + m * 60.0 + s;
                    time = (int)rs;
                    next = false;
                } else {
                    next = false;
                }
            }
            ++count;
            ++n2;
        }
        return time;
    }

    protected static String parseTimeString(String[] args_input) {
        String[] args = (String[])args_input.clone();
        String time = "";
        int count = 0;
        boolean next = false;
        double w = 0.0;
        double d = 0.0;
        double h = 0.0;
        double m = 0.0;
        double s = 0.0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("t:") || i.equals("time:")) {
                    next = true;
                } else if (next || i.startsWith("t:") || i.startsWith("time:")) {
                    String[] i2;
                    i = i.replaceAll("time:", "");
                    i = i.replaceAll("t:", "");
                    i = i.replaceAll("y", "y:");
                    i = i.replaceAll("m", "m:");
                    i = i.replaceAll("w", "w:");
                    i = i.replaceAll("d", "d:");
                    i = i.replaceAll("h", "h:");
                    i = i.replaceAll("s", "s:");
                    String[] stringArray2 = i2 = i.split(":");
                    int n3 = i2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String i4;
                        String i3 = stringArray2[n4];
                        if (i3.endsWith("w")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                w = Double.parseDouble(i4);
                                time = String.valueOf(time) + " " + w + " week(s)";
                            }
                        } else if (i3.endsWith("d")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                d = Double.parseDouble(i4);
                                time = String.valueOf(time) + " " + d + " day(s)";
                            }
                        } else if (i3.endsWith("h")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                h = Double.parseDouble(i4);
                                time = String.valueOf(time) + " " + h + " hour(s)";
                            }
                        } else if (i3.endsWith("m")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                                m = Double.parseDouble(i4);
                                time = String.valueOf(time) + " " + m + " minute(s)";
                            }
                        } else if (i3.endsWith("s") && (i4 = i3.replaceAll("[^0-9.]", "")).length() > 0 && i4.replaceAll("[^0-9]", "").length() > 0) {
                            s = Double.parseDouble(i4);
                            time = String.valueOf(time) + " " + s + " second(s)";
                        }
                        ++n4;
                    }
                    next = false;
                } else {
                    next = false;
                }
            }
            ++count;
            ++n2;
        }
        return time;
    }

    protected static List<String> parseRestricted(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<String> restricted = new ArrayList<String>();
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("b:") || i.equals("block:") || i.equals("blocks:")) {
                    next = 4;
                } else if (next == 4 || i.startsWith("b:") || i.startsWith("block:") || i.startsWith("blocks:")) {
                    i = i.replaceAll("blocks:", "");
                    i = i.replaceAll("block:", "");
                    if ((i = i.replaceAll("b:", "")).contains(",")) {
                        String[] i2;
                        String[] stringArray2 = i2 = i.split(",");
                        int n3 = i2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String i3 = stringArray2[n4];
                            String i4 = i3.replaceAll("[^0-9]", "");
                            if (i4.length() > 0 && i3.length() == i4.length()) {
                                restricted.add(i4);
                            } else if (i3.length() > 0) {
                                if (i3.equals("#natural")) {
                                    restricted.addAll(natural_blocks);
                                } else {
                                    int t = Functions.block_id(i3);
                                    if (t > -1) {
                                        restricted.add(Integer.toString(t));
                                    }
                                }
                            }
                            ++n4;
                        }
                        next = i.endsWith(",") ? 4 : 0;
                    } else {
                        String i4 = i.replaceAll("[^0-9]", "");
                        if (i4.length() > 0 && i.length() == i4.length()) {
                            restricted.add(i4);
                        } else if (i.length() > 0) {
                            if (i.equals("#natural")) {
                                restricted.addAll(natural_blocks);
                            } else {
                                int t = Functions.block_id(i);
                                if (t > -1) {
                                    restricted.add(Integer.toString(t));
                                }
                            }
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return restricted;
    }

    protected static List<String> parseExcluded(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<String> excluded = new ArrayList<String>();
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("e:") || i.equals("exclude:")) {
                    next = 5;
                } else if (next == 5 || i.startsWith("e:") || i.startsWith("exclude:")) {
                    i = i.replaceAll("exclude:", "");
                    if ((i = i.replaceAll("e:", "")).contains(",")) {
                        String[] i2;
                        String[] stringArray2 = i2 = i.split(",");
                        int n3 = i2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String i3 = stringArray2[n4];
                            String i4 = i3.replaceAll("[^0-9]", "");
                            if (i4.length() > 0 && i3.length() == i4.length()) {
                                excluded.add(i4);
                            } else if (i3.length() > 0) {
                                if (i3.equals("#natural")) {
                                    excluded.addAll(natural_blocks);
                                } else {
                                    int t = Functions.block_id(i3);
                                    if (t > -1) {
                                        excluded.add(Integer.toString(t));
                                    }
                                }
                            }
                            ++n4;
                        }
                        next = i.endsWith(",") ? 5 : 0;
                    } else {
                        String i4 = i.replaceAll("[^0-9]", "");
                        if (i4.length() > 0 && i.length() == i4.length()) {
                            excluded.add(i4);
                        } else if (i.length() > 0) {
                            if (i.equals("#natural")) {
                                excluded.addAll(natural_blocks);
                            } else {
                                int t = Functions.block_id(i);
                                if (t > -1) {
                                    excluded.add(Integer.toString(t));
                                }
                            }
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return excluded;
    }

    protected static List<String> parseExcludedUsers(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<String> excluded = new ArrayList<String>();
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("e:") || i.equals("exclude:")) {
                    next = 5;
                } else if (next == 5 || i.startsWith("e:") || i.startsWith("exclude:")) {
                    i = i.replaceAll("exclude:", "");
                    if ((i = i.replaceAll("e:", "")).contains(",")) {
                        String[] i2;
                        String[] stringArray2 = i2 = i.split(",");
                        int n3 = i2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String i3 = stringArray2[n4];
                            String i4 = i3.replaceAll("[^0-9]", "");
                            boolean isBlock = false;
                            if (i4.length() > 0 && i3.length() == i4.length()) {
                                String name_check = Functions.block_name_lookup(Integer.parseInt(i4));
                                if (name_check.length() > 0) {
                                    isBlock = true;
                                } else if (Material.getMaterial((int)Integer.parseInt(i4)) != null) {
                                    isBlock = true;
                                }
                            } else if (i3.length() > 0) {
                                int t = Functions.block_id(i3);
                                if (t > -1) {
                                    isBlock = true;
                                }
                                if (i3.equals("#natural")) {
                                    isBlock = true;
                                }
                            }
                            if (!isBlock) {
                                excluded.add(i3);
                            }
                            ++n4;
                        }
                        next = i.endsWith(",") ? 5 : 0;
                    } else {
                        String i4 = i.replaceAll("[^0-9]", "");
                        boolean isBlock = false;
                        if (i4.length() > 0 && i.length() == i4.length()) {
                            String name_check = Functions.block_name_lookup(Integer.parseInt(i4));
                            if (name_check.length() > 0) {
                                isBlock = true;
                            } else if (Material.getMaterial((int)Integer.parseInt(i4)) != null) {
                                isBlock = true;
                            }
                        } else if (i.length() > 0) {
                            int t = Functions.block_id(i);
                            if (t > -1) {
                                isBlock = true;
                            }
                            if (i.equals("#natural")) {
                                isBlock = true;
                            }
                        }
                        if (!isBlock) {
                            excluded.add(i);
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return excluded;
    }

    protected static boolean parseWorldEdit(String[] args_input) {
        String[] args = (String[])args_input.clone();
        boolean result = false;
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we")) {
                        result = true;
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return result;
    }

    protected static boolean parseForceGlobal(String[] args_input) {
        String[] args = (String[])args_input.clone();
        boolean result = false;
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    int world_id;
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#global") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false")) {
                        result = true;
                    } else if (i.startsWith("#") && (world_id = Functions.matchWorld(i)) > 0) {
                        result = true;
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return result;
    }

    protected static Integer[] parseRadius(String[] args_input, CommandSender user) {
        String[] args = (String[])args_input.clone();
        Integer[] radius = null;
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    int z1;
                    int y1;
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we")) {
                        WorldEditPlugin wep = WorldEdit.getWorldEdit(user.getServer());
                        if (wep != null && user instanceof Player) {
                            try {
                                Region region;
                                LocalSession ls = wep.getSession((Player)user);
                                LocalWorld lw = ls.getSelectionWorld();
                                if (lw != null && (region = ls.getSelection(lw)) != null && lw.getName().equals(((Player)user).getWorld().getName())) {
                                    Vector v1 = region.getMinimumPoint();
                                    int x1 = v1.getBlockX();
                                    y1 = v1.getBlockY();
                                    z1 = v1.getBlockZ();
                                    int w = region.getWidth();
                                    int h = region.getHeight();
                                    int l = region.getLength();
                                    int max = w;
                                    if (h > max) {
                                        max = h;
                                    }
                                    if (l > max) {
                                        max = l;
                                    }
                                    int xmin = x1;
                                    int xmax = x1 + (w - 1);
                                    int ymin = y1;
                                    int ymax = y1 + (h - 1);
                                    int zmin = z1;
                                    int zmax = z1 + (l - 1);
                                    radius = new Integer[]{max, xmin, xmax, ymin, ymax, zmin, zmax, 1};
                                }
                            }
                            catch (Exception ls) {}
                        }
                    } else if (!(i.startsWith("#") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false"))) {
                        int rcount = 0;
                        int r_x = 0;
                        int r_y = -1;
                        int r_z = 0;
                        String[] r_dat = new String[]{i};
                        if (i.contains("x")) {
                            r_dat = i.split("x");
                        }
                        String[] w = r_dat;
                        z1 = r_dat.length;
                        y1 = 0;
                        while (y1 < z1) {
                            String value = w[y1];
                            String i4 = value.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.length() == value.length() && i4.replaceAll("[^0-9]", "").length() > 0) {
                                double a1 = Double.parseDouble(i4);
                                if (rcount == 0) {
                                    r_x = (int)a1;
                                    r_z = (int)a1;
                                } else if (rcount == 1) {
                                    r_y = (int)a1;
                                } else if (rcount == 2) {
                                    r_z = (int)a1;
                                }
                            }
                            ++rcount;
                            ++y1;
                        }
                        if (user instanceof Player) {
                            int max;
                            Location location = ((Player)user).getLocation();
                            int xmin = location.getBlockX() - r_x;
                            int xmax = location.getBlockX() + r_x;
                            int ymin = -1;
                            int ymax = -1;
                            int zmin = location.getBlockZ() - r_z;
                            int zmax = location.getBlockZ() + r_z;
                            if (r_y > -1) {
                                ymin = location.getBlockY() - r_y;
                                ymax = location.getBlockY() + r_y;
                            }
                            if (r_y > (max = r_x)) {
                                max = r_y;
                            }
                            if (r_z > max) {
                                max = r_z;
                            }
                            radius = new Integer[]{max, xmin, xmax, ymin, ymax, zmin, zmax, 0};
                        }
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return radius;
    }

    protected static int parseWorld(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int world_id = 0;
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we") || i.equals("#global") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false")) {
                        world_id = 0;
                    } else if (i.startsWith("#")) {
                        world_id = Functions.matchWorld(i);
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return world_id;
    }

    protected static String parseWorldName(String[] args_input) {
        String[] args = (String[])args_input.clone();
        String world_name = "";
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we") || i.equals("#global") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false")) {
                        world_name = "";
                    } else if (i.startsWith("#")) {
                        world_name = i.replaceFirst("#", "");
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return world_name;
    }

    private static void validUserCheck(List<String> users, String user) {
        List<String> bad_users = Arrays.asList("n", "noisy", "v", "verbose", "#v", "#verbose", "#silent", "#preview", "#preview_cancel", "#count", "#sum");
        String check = user.replaceAll("[^a-zA-Z0-9#_]", "");
        if (check.equals(user) && check.length() > 0) {
            if (user.equalsIgnoreCase("#global")) {
                user = "#global";
            }
            if (!bad_users.contains(user.toLowerCase())) {
                users.add(user);
            }
        }
    }

    private static void parseUser(List<String> users, String string) {
        if ((string = string.trim()).contains(",")) {
            String[] data;
            String[] stringArray = data = string.split(",");
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String user = stringArray[n2];
                CommandHandler.validUserCheck(users, user);
                ++n2;
            }
        } else {
            CommandHandler.validUserCheck(users, string);
        }
    }

    protected static List<String> parseUsers(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<String> users = new ArrayList<String>();
        int count = 0;
        int next = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                i = i.replaceAll("'", "");
                if (next == 2) {
                    next = i.endsWith(",") ? 2 : 0;
                } else if (i.equals("p:") || i.equals("user:") || i.equals("u:")) {
                    next = 1;
                } else if (next == 1 || i.startsWith("p:") || i.startsWith("user:") || i.startsWith("u:")) {
                    i = i.replaceAll("user:", "");
                    i = i.replaceAll("p:", "");
                    if ((i = i.replaceAll("u:", "")).contains(",")) {
                        String[] i2;
                        String[] stringArray2 = i2 = i.split(",");
                        int n3 = i2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String i3 = stringArray2[n4];
                            CommandHandler.parseUser(users, i3);
                            ++n4;
                        }
                        next = i.endsWith(",") ? 1 : 0;
                    } else {
                        CommandHandler.parseUser(users, i);
                        next = 0;
                    }
                } else if (i.endsWith(",") || i.endsWith(":")) {
                    next = 2;
                } else if (i.contains(":")) {
                    next = 0;
                } else {
                    CommandHandler.parseUser(users, i);
                    next = 0;
                }
            }
            ++count;
            ++n2;
        }
        return users;
    }

    protected static List<Integer> parseAction(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<Integer> result = new ArrayList<Integer>();
        int count = 0;
        boolean next = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("a:") || i.equals("action:")) {
                    next = true;
                } else if (next || i.startsWith("a:") || i.startsWith("action:")) {
                    result.clear();
                    i = i.replaceAll("action:", "");
                    i = i.replaceAll("a:", "");
                    if (i.startsWith("#")) {
                        i = i.replaceFirst("#", "");
                    }
                    if (i.equals("broke") || i.equals("break") || i.equals("remove") || i.equals("destroy") || i.equals("block-break") || i.equals("block-remove") || i.equals("-block") || i.equals("block-")) {
                        result.add(0);
                    } else if (i.equals("placed") || i.equals("place") || i.equals("block-place") || i.equals("+block") || i.equals("block+")) {
                        result.add(1);
                    } else if (i.equals("block") || i.equals("block-change") || i.equals("change")) {
                        result.add(0);
                        result.add(1);
                    } else if (i.equals("click") || i.equals("clicks") || i.equals("interact") || i.equals("interaction") || i.equals("player-interact") || i.equals("player-interaction") || i.equals("player-click")) {
                        result.add(2);
                    } else if (i.equals("death") || i.equals("entity-death") || i.equals("kill") || i.equals("entity-kill")) {
                        result.add(3);
                    } else if (i.equals("container") || i.equals("container-change") || i.equals("containers") || i.equals("chest") || i.equals("transaction") || i.equals("transactions")) {
                        result.add(4);
                    } else if (i.equals("-container") || i.equals("container-") || i.equals("remove-container")) {
                        result.add(4);
                        result.add(0);
                    } else if (i.equals("+container") || i.equals("container+") || i.equals("container-add") || i.equals("add-container")) {
                        result.add(4);
                        result.add(1);
                    } else if (i.equals("chat")) {
                        result.add(6);
                    } else if (i.equals("command") || i.equals("commands")) {
                        result.add(7);
                    } else if (i.equals("login") || i.equals("+session") || i.equals("session+") || i.equals("+connection") || i.equals("connection+")) {
                        result.add(8);
                        result.add(1);
                    } else if (i.equals("logout") || i.equals("-session") || i.equals("session-") || i.equals("-connection") || i.equals("connection-")) {
                        result.add(8);
                        result.add(0);
                    } else if (i.equals("session") || i.equals("sessions") || i.equals("connection") || i.equals("connections")) {
                        result.add(8);
                    } else {
                        result.add(-1);
                    }
                    next = false;
                } else {
                    next = false;
                }
            }
            ++count;
            ++n2;
        }
        return result;
    }

    public boolean onCommand(CommandSender user, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase();
        if (commandName.equals("core") || commandName.equals("coreprotect") || commandName.equals("co")) {
            int resultc = args.length;
            if (resultc > -1) {
                String corecommand = "help";
                if (resultc > 0) {
                    corecommand = args[0].toLowerCase();
                }
                boolean permission = false;
                if (user.isOp()) {
                    permission = true;
                }
                if (!permission) {
                    if (user.hasPermission("coreprotect.rollback") && (corecommand.equals("rollback") || corecommand.equals("rb") || corecommand.equals("ro") || corecommand.equals("apply") || corecommand.equals("cancel"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.restore") && (corecommand.equals("restore") || corecommand.equals("rs") || corecommand.equals("re") || corecommand.equals("undo") || corecommand.equals("apply") || corecommand.equals("cancel"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.inspect") && (corecommand.equals("i") || corecommand.equals("inspect"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.help") && corecommand.equals("help")) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.purge") && corecommand.equals("purge")) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.lookup") && (corecommand.equals("l") || corecommand.equals("lookup") || corecommand.equals("near"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.reload") && corecommand.equals("reload")) {
                        permission = true;
                    }
                }
                if (corecommand.equals("rollback") || corecommand.equals("restore") || corecommand.equals("rb") || corecommand.equals("rs") || corecommand.equals("ro") || corecommand.equals("re")) {
                    RollbackRestoreCommand.runCommand(user, permission, args, 0);
                } else if (corecommand.equals("apply")) {
                    ApplyCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("cancel")) {
                    CancelCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("undo")) {
                    UndoCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("help")) {
                    HelpCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("purge")) {
                    PurgeCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("inspect") || corecommand.equals("i")) {
                    InspectCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("lookup") || corecommand.equals("l")) {
                    LookupCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("near")) {
                    LookupCommand.runCommand(user, permission, new String[]{"l", "r:5x5"});
                } else if (corecommand.equals("version")) {
                    VersionCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("reload")) {
                    ReloadCommand.runCommand(user, permission, args);
                } else {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Command \"\u00a73/co " + corecommand + "\u00a7f\" not found.");
                }
            } else {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"\u00a73/core <parameters>\u00a7f\".");
            }
            return true;
        }
        return false;
    }
}

