/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.sql.Connection;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class LookupCommand {
    protected static void runCommand(CommandSender player, boolean permission, String[] args) {
        String lcommand;
        String pages;
        String bid;
        int resultc = args.length;
        Location lo = CommandHandler.parseLocation(player);
        List<String> arg_users = CommandHandler.parseUsers(args);
        Integer[] arg_radius = CommandHandler.parseRadius(args, player);
        int arg_noisy = CommandHandler.parseNoisy(args);
        List<String> arg_exclude_users = CommandHandler.parseExcludedUsers(args);
        List<String> arg_exclude = CommandHandler.parseExcluded(args);
        int arg_excluded = arg_exclude.size();
        List<String> arg_blocks = CommandHandler.parseRestricted(args);
        int arg_restricted = arg_blocks.size();
        String ts = CommandHandler.parseTimeString(args);
        int rbseconds = CommandHandler.parseTime(args);
        int arg_wid = CommandHandler.parseWorld(args);
        List<Integer> arg_action = CommandHandler.parseAction(args);
        boolean count = CommandHandler.parseCount(args);
        boolean worldedit = CommandHandler.parseWorldEdit(args);
        boolean page_lookup = false;
        if (arg_action.size() == 0 && arg_blocks.size() > 0) {
            arg_action.add(0);
            arg_action.add(1);
        }
        if (!permission) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
            return;
        }
        if (Config.converter_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
            return;
        }
        if (Config.purge_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
            return;
        }
        if (resultc < 2) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co l <params>\".");
            return;
        }
        if (arg_action.contains(-1)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- That is not a valid action.");
            return;
        }
        if (worldedit && arg_radius == null) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- WorldEdit selection not found.");
            return;
        }
        boolean allPermission = false;
        if (player.isOp()) {
            allPermission = true;
        }
        if (!allPermission) {
            if ((arg_action.size() == 0 || arg_action.contains(0) || arg_action.contains(1)) && !player.hasPermission("coreprotect.lookup.block")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(2) && !player.hasPermission("coreprotect.lookup.click")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(3) && !player.hasPermission("coreprotect.lookup.kill")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(4) && !player.hasPermission("coreprotect.lookup.container")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(6) && !player.hasPermission("coreprotect.lookup.chat")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(7) && !player.hasPermission("coreprotect.lookup.command")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(8) && !player.hasPermission("coreprotect.lookup.session")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
        }
        if (arg_action.contains(6) || arg_action.contains(7) || arg_action.contains(8)) {
            if (!arg_action.contains(8) && (arg_radius != null || arg_wid > 0 || worldedit)) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- \"r:\" can't be used with that action.");
                return;
            }
            if (arg_blocks.size() > 0) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- \"b:\" can't be used with that action.");
                return;
            }
            if (arg_exclude.size() > 0) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- \"e:\" can't be used with that action.");
                return;
            }
        }
        if (arg_wid == -1) {
            String world_name = CommandHandler.parseWorldName(args);
            player.sendMessage("\u00a73CoreProtect \u00a7f- World \"" + world_name + "\" not found.");
            return;
        }
        int type = 0;
        if (Config.lookup_type.get(player.getName()) != null) {
            type = Config.lookup_type.get(player.getName());
        }
        if (type == 0 && resultc > 1) {
            type = 4;
        } else if (resultc > 2) {
            type = 4;
        } else if (resultc > 1) {
            page_lookup = true;
            String dat = args[1];
            if (dat.contains(":")) {
                String[] split = dat.split(":");
                String check1 = split[0].replaceAll("[^a-zA-Z_]", "");
                String check2 = "";
                if (split.length > 1) {
                    check2 = split[1].replaceAll("[^a-zA-Z_]", "");
                }
                if (check1.length() > 0 || check2.length() > 0) {
                    type = 4;
                    page_lookup = false;
                }
            } else {
                String check1 = dat.replaceAll("[^a-zA-Z_]", "");
                if (check1.length() > 0) {
                    type = 4;
                    page_lookup = false;
                }
            }
        }
        if (arg_action.contains(6) || arg_action.contains(7) || arg_action.contains(8)) {
            page_lookup = true;
        }
        if (resultc > 2 && ((bid = args[1]).equalsIgnoreCase("type") || bid.equalsIgnoreCase("id"))) {
            type = 6;
        }
        if (!(rbseconds > 0 || page_lookup || type != 4 || arg_blocks.size() <= 0 && arg_users.size() <= 0)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please specify the amount of time to lookup.");
            return;
        }
        if (type == 1) {
            String[] data;
            boolean default_re = true;
            int p = 0;
            int re = 7;
            if (resultc > 1) {
                int pa;
                pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        default_re = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && (pa = Integer.parseInt(pages)) > 0) {
                    p = pa;
                }
            }
            if (p <= 0) {
                p = 1;
            }
            lcommand = Config.lookup_command.get(player.getName());
            data = lcommand.split("\\.");
            int x = Integer.parseInt(data[0]);
            int y = Integer.parseInt(data[1]);
            int z = Integer.parseInt(data[2]);
            int wid = Integer.parseInt(data[3]);
            int x2 = Integer.parseInt(data[4]);
            int y2 = Integer.parseInt(data[5]);
            int z2 = Integer.parseInt(data[6]);
            int ctype = Integer.parseInt(data[7]);
            if (default_re) {
                re = Integer.parseInt(data[8]);
            }
            String bc = String.valueOf(x) + "." + y + "." + z + "." + wid + "." + x2 + "." + y2 + "." + z2 + "." + ctype + "." + re;
            Config.lookup_command.put(player.getName(), bc);
            String world = Functions.getWorldName(wid);
            double dx = 0.5 * (double)(x + x2);
            double dy = 0.5 * (double)(y + y2);
            double dz = 0.5 * (double)(z + z2);
            Location location = new Location(CoreProtect.getInstance().getServer().getWorld(world), dx, dy, dz);
            CommandSender player2 = player;
            int p2 = p;
            int final_limit = re;
            class BasicThread
            implements Runnable {
                private final /* synthetic */ Location val$location;
                private final /* synthetic */ CommandSender val$player2;
                private final /* synthetic */ int val$ctype;
                private final /* synthetic */ int val$p2;
                private final /* synthetic */ int val$final_limit;

                BasicThread(Location location, CommandSender commandSender, int n, int n2, int n3) {
                    this.val$location = location;
                    this.val$player2 = commandSender;
                    this.val$ctype = n;
                    this.val$p2 = n2;
                    this.val$final_limit = n3;
                }

                @Override
                public void run() {
                    try {
                        Connection connection = Database.getConnection(false);
                        if (connection != null) {
                            Statement statement = connection.createStatement();
                            String blockdata = Lookup.chest_transactions(statement, this.val$location, this.val$player2.getName(), this.val$ctype, this.val$p2, this.val$final_limit);
                            if (blockdata.contains("\n")) {
                                String[] stringArray = blockdata.split("\n");
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String b = stringArray[n2];
                                    this.val$player2.sendMessage(b);
                                    ++n2;
                                }
                            } else {
                                this.val$player2.sendMessage(blockdata);
                            }
                            statement.close();
                            connection.close();
                        } else {
                            this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BasicThread runnable = new BasicThread(location, player2, ctype, p2, final_limit);
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (type == 2 || type == 3 || type == 7) {
            boolean default_re = true;
            int page = 1;
            int re = 7;
            if (resultc > 1) {
                int p;
                pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    String[] data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        default_re = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && (p = Integer.parseInt(pages)) > 0) {
                    page = p;
                }
            }
            lcommand = Config.lookup_command.get(player.getName());
            String[] data = lcommand.split("\\.");
            int x = Integer.parseInt(data[0]);
            int y = Integer.parseInt(data[1]);
            int z = Integer.parseInt(data[2]);
            int wid = Integer.parseInt(data[3]);
            int lookup_type = Integer.parseInt(data[4]);
            if (default_re) {
                re = Integer.parseInt(data[5]);
            }
            String bc = String.valueOf(x) + "." + y + "." + z + "." + wid + "." + lookup_type + "." + re;
            Config.lookup_command.put(player.getName(), bc);
            String world = Functions.getWorldName(wid);
            Block fblock = CoreProtect.getInstance().getServer().getWorld(world).getBlockAt(x, y, z);
            CommandSender player2 = player;
            int p2 = page;
            int final_limit = re;
            int t = type;
            class BasicThread
            implements Runnable {
                private final /* synthetic */ int val$t;
                private final /* synthetic */ Block val$fblock;
                private final /* synthetic */ CommandSender val$player2;
                private final /* synthetic */ int val$p2;
                private final /* synthetic */ int val$final_limit;

                BasicThread(int n, Block block, CommandSender commandSender, int n2, int n3) {
                    this.val$t = n;
                    this.val$fblock = block;
                    this.val$player2 = commandSender;
                    this.val$p2 = n2;
                    this.val$final_limit = n3;
                }

                @Override
                public void run() {
                    try {
                        Connection connection = Database.getConnection(false);
                        if (connection != null) {
                            Statement statement = connection.createStatement();
                            String blockdata = null;
                            blockdata = this.val$t == 7 ? Lookup.interaction_lookup(statement, this.val$fblock, this.val$player2.getName(), 0, this.val$p2, this.val$final_limit) : Lookup.block_lookup(statement, this.val$fblock, this.val$player2.getName(), 0, this.val$p2, this.val$final_limit);
                            if (blockdata.contains("\n")) {
                                String[] stringArray = blockdata.split("\n");
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String b = stringArray[n2];
                                    this.val$player2.sendMessage(b);
                                    ++n2;
                                }
                            } else if (blockdata.length() > 0) {
                                this.val$player2.sendMessage(blockdata);
                            }
                            statement.close();
                            connection.close();
                        } else {
                            this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BasicThread runnable = new BasicThread(t, fblock, player2, p2, final_limit);
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (type == 4 || type == 5) {
            boolean default_re = true;
            int pa = 1;
            int re = 4;
            if (arg_action.contains(6) || arg_action.contains(7)) {
                re = 7;
            }
            if (type == 5 && resultc > 1) {
                int p;
                pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    String[] data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        default_re = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && (p = Integer.parseInt(pages)) > 0) {
                    pa = p;
                }
            }
            boolean g = true;
            if (arg_users.contains("#global") && arg_radius == null) {
                g = false;
            }
            if (g && (page_lookup || arg_blocks.size() > 0 || arg_users.size() > 0 || arg_users.size() == 0 && arg_radius != null)) {
                int radius_value;
                int max_radius = Config.config.get("max-radius");
                if (arg_radius != null && (radius_value = arg_radius[0].intValue()) > max_radius && max_radius > 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- The maximum lookup radius is " + max_radius + ".");
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Don't specify a radius to do a global lookup.");
                    return;
                }
                if (arg_users.size() == 0) {
                    arg_users.add("#global");
                }
                List<String> rollbackusers = arg_users;
                int c = 0;
                for (String ruser : rollbackusers) {
                    List players = CoreProtect.getInstance().getServer().matchPlayer(ruser);
                    for (Player p : players) {
                        if (!p.getName().equalsIgnoreCase(ruser)) continue;
                        rollbackusers.set(c, p.getName());
                    }
                    ++c;
                }
                int cs = -1;
                int x = 0;
                int y = 0;
                int z = 0;
                int wid = 0;
                if (type == 5) {
                    String lcommand2 = Config.lookup_command.get(player.getName());
                    String[] data = lcommand2.split("\\.");
                    x = Integer.parseInt(data[0]);
                    y = Integer.parseInt(data[1]);
                    z = Integer.parseInt(data[2]);
                    wid = Integer.parseInt(data[3]);
                    cs = Integer.parseInt(data[4]);
                    arg_noisy = Integer.parseInt(data[5]);
                    arg_excluded = Integer.parseInt(data[6]);
                    arg_restricted = Integer.parseInt(data[7]);
                    arg_wid = Integer.parseInt(data[8]);
                    if (default_re) {
                        re = Integer.parseInt(data[9]);
                    }
                    rollbackusers = Config.lookup_ulist.get(player.getName());
                    arg_blocks = Config.lookup_blist.get(player.getName());
                    arg_exclude = Config.lookup_elist.get(player.getName());
                    arg_exclude_users = Config.lookup_e_userlist.get(player.getName());
                    arg_action = Config.lookup_alist.get(player.getName());
                    arg_radius = Config.lookup_radius.get(player.getName());
                    ts = Config.lookup_time.get(player.getName());
                    rbseconds = 1;
                } else {
                    if (lo != null) {
                        x = lo.getBlockX();
                        z = lo.getBlockZ();
                        wid = Functions.getWorldId(lo.getWorld().getName());
                    }
                    if (rollbackusers.contains("#container")) {
                        boolean valid = false;
                        if (Config.lookup_type.get(player.getName()) != null) {
                            int lookup_type = Config.lookup_type.get(player.getName());
                            if (lookup_type == 1) {
                                valid = true;
                            } else if (lookup_type == 5 && Config.lookup_ulist.get(player.getName()).contains("#container")) {
                                valid = true;
                            }
                        }
                        if (valid) {
                            if (!player.hasPermission("coreprotect.lookup.container")) {
                                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                                return;
                            }
                            String lcommand3 = Config.lookup_command.get(player.getName());
                            String[] data = lcommand3.split("\\.");
                            x = Integer.parseInt(data[0]);
                            y = Integer.parseInt(data[1]);
                            z = Integer.parseInt(data[2]);
                            wid = Integer.parseInt(data[3]);
                            arg_action.add(5);
                            arg_radius = null;
                            arg_wid = 0;
                        } else {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- Please inspect a valid container first.");
                            return;
                        }
                    }
                }
                List<String> rollbackusers2 = rollbackusers;
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                if (cs == -1) {
                    cs = rbseconds <= 0 ? 0 : unixtimestamp - rbseconds;
                }
                int stime = cs;
                Integer[] radius = arg_radius;
                try {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Lookup searching. Please wait...");
                    CommandSender player2 = player;
                    int final_x = x;
                    int final_y = y;
                    int final_z = z;
                    int final_wid = wid;
                    int final_arg_wid = arg_wid;
                    int noisy = arg_noisy;
                    String rtime = ts;
                    int excluded = arg_excluded;
                    int restricted = arg_restricted;
                    List<String> blist = arg_blocks;
                    List<String> elist = arg_exclude;
                    List<String> euserlist = arg_exclude_users;
                    int page = pa;
                    int display_results = re;
                    int type_lookup = type;
                    Location final_location = lo;
                    List<Integer> final_arg_action = arg_action;
                    boolean final_count = count;
                    class BasicThread2
                    implements Runnable {
                        private final /* synthetic */ Location val$final_location;
                        private final /* synthetic */ int val$final_x;
                        private final /* synthetic */ int val$final_y;
                        private final /* synthetic */ int val$final_z;
                        private final /* synthetic */ int val$final_wid;
                        private final /* synthetic */ int val$stime;
                        private final /* synthetic */ int val$noisy;
                        private final /* synthetic */ int val$excluded;
                        private final /* synthetic */ int val$restricted;
                        private final /* synthetic */ int val$final_arg_wid;
                        private final /* synthetic */ int val$display_results;
                        private final /* synthetic */ CommandSender val$player2;
                        private final /* synthetic */ int val$page;
                        private final /* synthetic */ String val$rtime;
                        private final /* synthetic */ List val$elist;
                        private final /* synthetic */ List val$euserlist;
                        private final /* synthetic */ List val$blist;
                        private final /* synthetic */ List val$rollbackusers2;
                        private final /* synthetic */ List val$final_arg_action;
                        private final /* synthetic */ Integer[] val$radius;
                        private final /* synthetic */ int val$type_lookup;
                        private final /* synthetic */ boolean val$final_count;

                        BasicThread2(Location location, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, CommandSender commandSender, int n11, String string, List list, List list2, List list3, List list4, List list5, Integer[] integerArray, int n12, boolean bl) {
                            this.val$final_location = location;
                            this.val$final_x = n;
                            this.val$final_y = n2;
                            this.val$final_z = n3;
                            this.val$final_wid = n4;
                            this.val$stime = n5;
                            this.val$noisy = n6;
                            this.val$excluded = n7;
                            this.val$restricted = n8;
                            this.val$final_arg_wid = n9;
                            this.val$display_results = n10;
                            this.val$player2 = commandSender;
                            this.val$page = n11;
                            this.val$rtime = string;
                            this.val$elist = list;
                            this.val$euserlist = list2;
                            this.val$blist = list3;
                            this.val$rollbackusers2 = list4;
                            this.val$final_arg_action = list5;
                            this.val$radius = integerArray;
                            this.val$type_lookup = n12;
                            this.val$final_count = bl;
                        }

                        @Override
                        public void run() {
                            block41: {
                                try {
                                    Location location = this.val$final_location;
                                    boolean exists = false;
                                    String bc = String.valueOf(this.val$final_x) + "." + this.val$final_y + "." + this.val$final_z + "." + this.val$final_wid + "." + this.val$stime + "." + this.val$noisy + "." + this.val$excluded + "." + this.val$restricted + "." + this.val$final_arg_wid + "." + this.val$display_results;
                                    Config.lookup_command.put(this.val$player2.getName(), bc);
                                    Config.lookup_page.put(this.val$player2.getName(), this.val$page);
                                    Config.lookup_time.put(this.val$player2.getName(), this.val$rtime);
                                    Config.lookup_type.put(this.val$player2.getName(), 5);
                                    Config.lookup_elist.put(this.val$player2.getName(), this.val$elist);
                                    Config.lookup_e_userlist.put(this.val$player2.getName(), this.val$euserlist);
                                    Config.lookup_blist.put(this.val$player2.getName(), this.val$blist);
                                    Config.lookup_ulist.put(this.val$player2.getName(), this.val$rollbackusers2);
                                    Config.lookup_alist.put(this.val$player2.getName(), this.val$final_arg_action);
                                    Config.lookup_radius.put(this.val$player2.getName(), this.val$radius);
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String baduser = "";
                                        for (String check : this.val$rollbackusers2) {
                                            if (!check.equals("#global") && !check.equals("#container")) {
                                                exists = Lookup.playerExists(statement, check);
                                                if (exists) continue;
                                                baduser = check;
                                                break;
                                            }
                                            exists = true;
                                        }
                                        if (exists) {
                                            for (String check : this.val$euserlist) {
                                                if (!check.equals("#global")) {
                                                    exists = Lookup.playerExists(statement, check);
                                                    if (exists) continue;
                                                    baduser = check;
                                                    break;
                                                }
                                                baduser = "#global";
                                                exists = false;
                                            }
                                        }
                                        if (exists) {
                                            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                                            boolean restrict_world = false;
                                            if (this.val$radius != null) {
                                                restrict_world = true;
                                            }
                                            if (location == null) {
                                                restrict_world = false;
                                            }
                                            if (this.val$final_arg_wid > 0) {
                                                restrict_world = true;
                                                location = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(this.val$final_arg_wid)), (double)this.val$final_x, (double)this.val$final_y, (double)this.val$final_z);
                                            } else if (location != null) {
                                                location = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(this.val$final_wid)), (double)this.val$final_x, (double)this.val$final_y, (double)this.val$final_z);
                                            }
                                            int row_max = this.val$page * this.val$display_results;
                                            int page_start = row_max - this.val$display_results;
                                            int rows = 0;
                                            boolean check_rows = true;
                                            if (this.val$type_lookup == 5 && this.val$page > 1 && page_start < (rows = Config.lookup_rows.get(this.val$player2.getName()).intValue())) {
                                                check_rows = false;
                                            }
                                            if (check_rows) {
                                                rows = Lookup.countLookupRows(statement, this.val$player2, this.val$rollbackusers2, this.val$blist, this.val$elist, this.val$euserlist, this.val$final_arg_action, location, this.val$radius, this.val$stime, restrict_world, true);
                                                Config.lookup_rows.put(this.val$player2.getName(), rows);
                                            }
                                            if (this.val$final_count) {
                                                String row_format = NumberFormat.getInstance().format(rows);
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- " + row_format + " row(s) found.");
                                            } else if (page_start < rows) {
                                                List<String[]> lookup_list = Lookup.performPartialLookup(statement, this.val$player2, this.val$rollbackusers2, this.val$blist, this.val$elist, this.val$euserlist, this.val$final_arg_action, location, this.val$radius, this.val$stime, page_start, this.val$display_results, restrict_world, true);
                                                this.val$player2.sendMessage("\u00a7f----- \u00a73CoreProtect Lookup Results \u00a7f-----");
                                                if (this.val$final_arg_action.contains(6) || this.val$final_arg_action.contains(7)) {
                                                    for (String[] data : lookup_list) {
                                                        String time = data[0];
                                                        String dplayer = data[1];
                                                        String message = data[2];
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        this.val$player2.sendMessage("\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + dplayer + ": \u00a7f" + message);
                                                    }
                                                } else if (this.val$final_arg_action.contains(8)) {
                                                    for (String[] data : lookup_list) {
                                                        String time = data[0];
                                                        String dplayer = data[1];
                                                        int wid = Integer.parseInt(data[2]);
                                                        int x = Integer.parseInt(data[3]);
                                                        int y = Integer.parseInt(data[4]);
                                                        int z = Integer.parseInt(data[5]);
                                                        int action = Integer.parseInt(data[6]);
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        String action_string = "in";
                                                        if (action == 0) {
                                                            action_string = "out";
                                                        }
                                                        String world = Functions.getWorldName(wid);
                                                        double time_length = (double)timeago.replaceAll("[^0-9]", "").length() * 1.5;
                                                        int padding = (int)(time_length + 12.5);
                                                        String left_padding = StringUtils.leftPad((String)"", (int)padding, (char)' ');
                                                        this.val$player2.sendMessage("\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + dplayer + " \u00a7flogged \u00a73" + action_string + "\u00a7f.");
                                                        this.val$player2.sendMessage("\u00a7f" + left_padding + "\u00a77^ \u00a7o(x" + x + "/y" + y + "/z" + z + "/" + world + ")");
                                                    }
                                                } else {
                                                    for (String[] data : lookup_list) {
                                                        String string_amount = "";
                                                        int drb = Integer.parseInt(data[8]);
                                                        String rbd = "";
                                                        if (drb == 1) {
                                                            rbd = "\u00a7m";
                                                        }
                                                        int amount = 0;
                                                        String time = data[0];
                                                        String dplayer = data[1];
                                                        int x = Integer.parseInt(data[2]);
                                                        int y = Integer.parseInt(data[3]);
                                                        int z = Integer.parseInt(data[4]);
                                                        String dtype = data[5];
                                                        int daction = Integer.parseInt(data[7]);
                                                        int wid = Integer.parseInt(data[9]);
                                                        String a = "placed";
                                                        String tag = "\u00a7f-";
                                                        if (this.val$final_arg_action.contains(4) || this.val$final_arg_action.contains(5)) {
                                                            amount = Integer.parseInt(data[10]);
                                                            string_amount = "x" + amount + " ";
                                                            a = "added";
                                                        }
                                                        if (daction == 0) {
                                                            a = "removed";
                                                        } else if (daction == 2) {
                                                            a = "clicked";
                                                        } else if (daction == 3) {
                                                            a = "killed";
                                                        }
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        double time_length = (double)timeago.replaceAll("[^0-9]", "").length() * 1.5;
                                                        int padding = (int)(time_length + 12.5);
                                                        String left_padding = StringUtils.leftPad((String)"", (int)padding, (char)' ');
                                                        String world = Functions.getWorldName(wid);
                                                        String dname = "";
                                                        dname = daction == 3 ? EntityType.fromId((int)Integer.parseInt(dtype)).getName() : Functions.block_name_short(Integer.parseInt(dtype));
                                                        if (dname.length() > 0) {
                                                            dname = " (" + dname + ")";
                                                        }
                                                        this.val$player2.sendMessage("\u00a77" + timeago + "/h ago " + tag + " \u00a73" + rbd + dplayer + " \u00a7f" + rbd + a + " " + string_amount + "\u00a73" + rbd + "#" + dtype + dname + "\u00a7f.");
                                                        this.val$player2.sendMessage("\u00a7f" + left_padding + "\u00a77^ \u00a7o(x" + x + "/y" + y + "/z" + z + "/" + world + ")");
                                                    }
                                                }
                                                if (rows > this.val$display_results) {
                                                    int total_pages = (int)Math.ceil((double)rows / ((double)this.val$display_results + 0.0));
                                                    if (this.val$final_arg_action.contains(6) || this.val$final_arg_action.contains(7)) {
                                                        this.val$player2.sendMessage("-----");
                                                    }
                                                    this.val$player2.sendMessage("\u00a7fPage " + this.val$page + "/" + total_pages + ". View older data by typing \"\u00a73/co l <page>\u00a7f\".");
                                                }
                                            } else if (rows > 0) {
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- No results found for that page.");
                                            } else {
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- No results found.");
                                            }
                                        } else {
                                            this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- User \"" + baduser + "\" not found.");
                                        }
                                        statement.close();
                                        connection.close();
                                        break block41;
                                    }
                                    this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    BasicThread2 runnable = new BasicThread2(final_location, final_x, final_y, final_z, final_wid, stime, noisy, excluded, restricted, final_arg_wid, display_results, player2, page, rtime, elist, euserlist, blist, rollbackusers2, final_arg_action, radius, type_lookup, final_count);
                    Thread thread = new Thread(runnable);
                    thread.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co l <params>\".");
            }
        } else if (type == 6) {
            bid = args[2];
            if ((bid = bid.replaceAll("[^0-9]", "")).length() > 0) {
                int b = Integer.parseInt(bid);
                if (b > 0) {
                    String bname = Functions.block_name_lookup(b);
                    if (bname.length() > 0) {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- The name of block ID #" + b + " is \"" + bname + "\".");
                    } else {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- No data found for block ID #" + b + ".");
                    }
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co lookup type <ID>\".");
                }
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co lookup type <ID>\".");
            }
        } else {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co l <params>\".");
        }
    }
}

