/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.database.Database;
import net.coreprotect.model.Config;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PurgeCommand
extends Consumer {
    protected static void runCommand(CommandSender player, boolean permission, String[] args) {
        int resultc = args.length;
        if (Config.converter_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
            return;
        }
        if (Config.purge_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
            return;
        }
        if (permission) {
            if (resultc > 1) {
                int seconds = CommandHandler.parseTime(args);
                if (seconds > 0) {
                    if (player instanceof Player) {
                        if (seconds < 2592000) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- You can only purge data older than 30 days.");
                            return;
                        }
                    } else if (seconds < 86400) {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- You can only purge data older than 24 hours.");
                        return;
                    }
                    int final_seconds = seconds;
                    CommandSender final_player = player;
                    class BasicThread
                    implements Runnable {
                        private final /* synthetic */ int val$final_seconds;
                        private final /* synthetic */ CommandSender val$final_player;

                        BasicThread(int n, CommandSender commandSender) {
                            this.val$final_seconds = n;
                            this.val$final_player = commandSender;
                        }

                        @Override
                        public void run() {
                            try {
                                int timestamp = (int)(System.currentTimeMillis() / 1000L);
                                int ptime = timestamp - this.val$final_seconds;
                                long removed = 0L;
                                Connection connection = Database.getConnection(false);
                                if (connection == null) {
                                    Functions.messageOwnerAndUser(this.val$final_player, "Database busy. Please try again later.");
                                    return;
                                }
                                Functions.messageOwnerAndUser(this.val$final_player, "Data purge started. This may take some time.");
                                Functions.messageOwnerAndUser(this.val$final_player, "Do not restart your server until completed.");
                                Statement statement = connection.createStatement();
                                Config.purge_running = true;
                                while (!pause_success) {
                                    Thread.sleep(1L);
                                }
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old sign data...");
                                String query = "DELETE FROM " + Config.prefix + "sign WHERE time < '" + ptime + "'";
                                PreparedStatement preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old container data...");
                                query = "DELETE FROM " + Config.prefix + "container WHERE time < '" + ptime + "'";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old skull data...");
                                query = "DELETE FROM " + Config.prefix + "skull WHERE time < '" + ptime + "'";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old session data...");
                                query = "DELETE FROM " + Config.prefix + "session WHERE time < '" + ptime + "'";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old chat data...");
                                query = "DELETE FROM " + Config.prefix + "chat WHERE time < '" + ptime + "'";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old command data...");
                                query = "DELETE FROM " + Config.prefix + "command WHERE time < '" + ptime + "'";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Purging old block data...");
                                query = "DELETE FROM " + Config.prefix + "block WHERE time < '" + ptime + "'";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                removed += (long)preparedStmt.getUpdateCount();
                                preparedStmt.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Cleaning up database...");
                                List<String> table_names = Arrays.asList("world", "player", "sign", "container", "skull", "block");
                                if (Config.config.get("use-mysql") == 1) {
                                    for (String table : table_names) {
                                        statement.executeUpdate("OPTIMIZE TABLE " + Config.prefix + table);
                                    }
                                } else {
                                    statement.executeUpdate("VACUUM");
                                }
                                statement.close();
                                connection.close();
                                Functions.messageOwnerAndUser(this.val$final_player, "Configuring database...");
                                Config.loadDatabase();
                                Functions.messageOwnerAndUser(this.val$final_player, "Data purge successful.");
                                Functions.messageOwnerAndUser(this.val$final_player, removed + " row(s) of data deleted.");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            Consumer.is_paused = false;
                            Config.purge_running = false;
                        }
                    }
                    BasicThread runnable = new BasicThread(final_seconds, final_player);
                    Thread thread = new Thread(runnable);
                    thread.start();
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co purge t:<time>\".");
                }
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co purge t:<time>\".");
            }
        } else {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
        }
    }
}

