/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.command.LookupCommand;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RollbackRestoreCommand {
    protected static void runCommand(CommandSender player, boolean permission, String[] args, int force_seconds) {
        Location lo = CommandHandler.parseLocation(player);
        List<String> arg_users = CommandHandler.parseUsers(args);
        Integer[] arg_radius = CommandHandler.parseRadius(args, player);
        int arg_noisy = CommandHandler.parseNoisy(args);
        List<String> arg_exclude = CommandHandler.parseExcluded(args);
        List<String> arg_exclude_users = CommandHandler.parseExcludedUsers(args);
        List<String> arg_blocks = CommandHandler.parseRestricted(args);
        String ts = CommandHandler.parseTimeString(args);
        int rbseconds = CommandHandler.parseTime(args);
        int arg_wid = CommandHandler.parseWorld(args);
        List<Integer> arg_action = CommandHandler.parseAction(args);
        boolean count = CommandHandler.parseCount(args);
        boolean worldedit = CommandHandler.parseWorldEdit(args);
        boolean forceglobal = CommandHandler.parseForceGlobal(args);
        int preview = CommandHandler.parsePreview(args);
        String corecommand = args[0].toLowerCase();
        if (arg_action.size() == 0 && arg_blocks.size() > 0) {
            arg_action.add(0);
            arg_action.add(1);
        }
        if (count) {
            LookupCommand.runCommand(player, permission, args);
            return;
        }
        if (Config.converter_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
            return;
        }
        if (Config.purge_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
            return;
        }
        if (arg_wid == -1) {
            String world_name = CommandHandler.parseWorldName(args);
            player.sendMessage("\u00a73CoreProtect \u00a7f- World \"" + world_name + "\" not found.");
            return;
        }
        if (preview > 0 && !(player instanceof Player)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You can only preview rollbacks in-game.");
            return;
        }
        if (arg_action.contains(-1)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- That is not a valid action.");
            return;
        }
        if (worldedit && arg_radius == null) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- WorldEdit selection not found.");
            return;
        }
        if (Config.active_rollbacks.get(player.getName()) != null) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- A rollback/restore is already in progress.");
            return;
        }
        if (preview > 1 && force_seconds <= 0) {
            preview = 1;
        }
        if (permission) {
            int a = 0;
            if (corecommand.equals("restore") || corecommand.equals("rs") || corecommand.equals("re")) {
                a = 1;
            }
            int final_action = a;
            int default_radius = Config.config.get("default-radius");
            if (player instanceof Player && arg_radius == null && default_radius > 0 && !forceglobal) {
                Location location = ((Player)player).getLocation();
                int xmin = location.getBlockX() - default_radius;
                int xmax = location.getBlockX() + default_radius;
                int zmin = location.getBlockZ() - default_radius;
                int zmax = location.getBlockZ() + default_radius;
                arg_radius = new Integer[]{default_radius, xmin, xmax, -1, -1, zmin, zmax, 0};
            }
            boolean g = true;
            if (arg_users.contains("#global") && arg_radius == null) {
                g = false;
            }
            if (arg_users.size() == 0 && arg_wid > 0) {
                if (final_action == 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a rollback user.");
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a restore user.");
                }
                return;
            }
            if (g && (arg_users.size() > 0 || arg_users.size() == 0 && arg_radius != null)) {
                int radius_value;
                int max_radius = Config.config.get("max-radius");
                if (arg_radius != null && (radius_value = arg_radius[0].intValue()) > max_radius && max_radius > 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- The maximum " + corecommand.toLowerCase() + " radius is " + max_radius + ".");
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Use \"r:#global\" to do a global " + corecommand.toLowerCase() + ".");
                    return;
                }
                if (arg_action.size() > 0) {
                    if (arg_action.contains(4)) {
                        if (arg_users.contains("#global") || arg_users.size() == 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- To use that action, please specify a user.");
                            return;
                        }
                        if (preview > 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- You can't preview container transactions.");
                            return;
                        }
                    } else if (!(arg_action.contains(0) || arg_action.contains(1) || arg_action.contains(3))) {
                        if (final_action == 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- That action can't be used with a rollback.");
                        } else {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- That action can't be used with a restore.");
                        }
                        return;
                    }
                }
                if (arg_users.size() == 0) {
                    arg_users.add("#global");
                }
                List<String> rollbackusers = arg_users;
                int c = 0;
                for (String ruser : rollbackusers) {
                    List players = CoreProtect.getInstance().getServer().matchPlayer(ruser);
                    for (Player p : players) {
                        if (!p.getName().equalsIgnoreCase(ruser)) continue;
                        rollbackusers.set(c, p.getName());
                    }
                    ++c;
                }
                int wid = 0;
                int x = 0;
                int y = 0;
                int z = 0;
                if (rollbackusers.contains("#container")) {
                    boolean valid = false;
                    if (Config.lookup_type.get(player.getName()) != null) {
                        int lookup_type = Config.lookup_type.get(player.getName());
                        if (lookup_type == 1) {
                            valid = true;
                        } else if (lookup_type == 5 && Config.lookup_ulist.get(player.getName()).contains("#container")) {
                            valid = true;
                        }
                    }
                    if (valid) {
                        if (preview > 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- You can't preview container transactions.");
                            return;
                        }
                        String lcommand = Config.lookup_command.get(player.getName());
                        String[] data = lcommand.split("\\.");
                        x = Integer.parseInt(data[0]);
                        y = Integer.parseInt(data[1]);
                        z = Integer.parseInt(data[2]);
                        wid = Integer.parseInt(data[3]);
                        arg_action.add(5);
                        arg_radius = null;
                        arg_wid = 0;
                        lo = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(wid)), (double)x, (double)y, (double)z);
                        Block block = lo.getBlock();
                        if (block.getState() instanceof Chest) {
                            BlockFace[] block_sides;
                            BlockFace[] blockFaceArray = block_sides = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
                            int n = block_sides.length;
                            int n2 = 0;
                            while (n2 < n) {
                                BlockFace face = blockFaceArray[n2];
                                if (block.getRelative(face, 1).getState() instanceof Chest) {
                                    Block relative = block.getRelative(face, 1);
                                    int x2 = relative.getX();
                                    int z2 = relative.getZ();
                                    double new_x = (double)(x + x2) / 2.0;
                                    double new_z = (double)(z + z2) / 2.0;
                                    lo.setX(new_x);
                                    lo.setZ(new_z);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- Please inspect a valid container first.");
                        return;
                    }
                }
                List<String> rollbackusers2 = rollbackusers;
                if (rbseconds > 0) {
                    int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                    int seconds = unixtimestamp - rbseconds;
                    if (force_seconds > 0) {
                        seconds = force_seconds;
                    }
                    int stime = seconds;
                    Integer[] radius = arg_radius;
                    try {
                        CommandSender player2 = player;
                        int noisy = arg_noisy;
                        String rtime = ts;
                        List<String> blist = arg_blocks;
                        List<String> elist = arg_exclude;
                        List<String> euserlist = arg_exclude_users;
                        Location location_final = lo;
                        int final_arg_wid = arg_wid;
                        List<Integer> final_arg_action = arg_action;
                        String[] final_args = args;
                        int final_preview = preview;
                        Config.active_rollbacks.put(player.getName(), true);
                        class BasicThread2
                        implements Runnable {
                            private final /* synthetic */ int val$final_action;
                            private final /* synthetic */ Location val$location_final;
                            private final /* synthetic */ List val$rollbackusers2;
                            private final /* synthetic */ List val$euserlist;
                            private final /* synthetic */ int val$final_preview;
                            private final /* synthetic */ CommandSender val$player2;
                            private final /* synthetic */ Integer[] val$radius;
                            private final /* synthetic */ int val$final_arg_wid;
                            private final /* synthetic */ int val$noisy;
                            private final /* synthetic */ List val$final_arg_action;
                            private final /* synthetic */ String val$rtime;
                            private final /* synthetic */ List val$blist;
                            private final /* synthetic */ List val$elist;
                            private final /* synthetic */ int val$stime;
                            private final /* synthetic */ String[] val$final_args;

                            BasicThread2(int n, Location location, List list, List list2, int n2, CommandSender commandSender, Integer[] integerArray, int n3, int n4, List list3, String string, List list4, List list5, int n5, String[] stringArray) {
                                this.val$final_action = n;
                                this.val$location_final = location;
                                this.val$rollbackusers2 = list;
                                this.val$euserlist = list2;
                                this.val$final_preview = n2;
                                this.val$player2 = commandSender;
                                this.val$radius = integerArray;
                                this.val$final_arg_wid = n3;
                                this.val$noisy = n4;
                                this.val$final_arg_action = list3;
                                this.val$rtime = string;
                                this.val$blist = list4;
                                this.val$elist = list5;
                                this.val$stime = n5;
                                this.val$final_args = stringArray;
                            }

                            @Override
                            public void run() {
                                try {
                                    int action = this.val$final_action;
                                    Location location = this.val$location_final;
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String baduser = "";
                                        boolean exists = false;
                                        for (String check : this.val$rollbackusers2) {
                                            if (!check.equals("#global") && !check.equals("#container")) {
                                                exists = Lookup.playerExists(statement, check);
                                                if (exists) continue;
                                                baduser = check;
                                                break;
                                            }
                                            exists = true;
                                        }
                                        if (exists) {
                                            for (String check : this.val$euserlist) {
                                                if (!check.equals("#global")) {
                                                    exists = Lookup.playerExists(statement, check);
                                                    if (exists) continue;
                                                    baduser = check;
                                                    break;
                                                }
                                                baduser = "#global";
                                                exists = false;
                                            }
                                        }
                                        if (exists) {
                                            String users = "";
                                            for (String value : this.val$rollbackusers2) {
                                                users = users.length() == 0 ? value : String.valueOf(users) + ", " + value;
                                            }
                                            if (this.val$final_preview == 2) {
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Cancelling preview...");
                                            } else if (this.val$final_preview == 1) {
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Preview started on \"" + users + "\".");
                                            } else if (action == 0) {
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Rollback started on \"" + users + "\".");
                                            } else {
                                                this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Restore started on \"" + users + "\".");
                                            }
                                            boolean restrict_world = false;
                                            if (this.val$radius != null) {
                                                restrict_world = true;
                                            }
                                            if (location == null) {
                                                restrict_world = false;
                                            }
                                            if (this.val$final_arg_wid > 0) {
                                                restrict_world = true;
                                                location = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(this.val$final_arg_wid)), 0.0, 0.0, 0.0);
                                            }
                                            boolean verbose = false;
                                            if (this.val$noisy == 1) {
                                                verbose = true;
                                            }
                                            if (this.val$final_arg_action.contains(5)) {
                                                Lookup.performContainerRollbackRestore(statement, this.val$player2, this.val$rollbackusers2, this.val$rtime, this.val$blist, this.val$elist, this.val$euserlist, this.val$final_arg_action, location, this.val$radius, this.val$stime, restrict_world, false, verbose, action);
                                            } else {
                                                Lookup.performRollbackRestore(statement, this.val$player2, this.val$rollbackusers2, this.val$rtime, this.val$blist, this.val$elist, this.val$euserlist, this.val$final_arg_action, location, this.val$radius, this.val$stime, restrict_world, false, verbose, action, this.val$final_preview);
                                                if (this.val$final_preview < 2) {
                                                    ArrayList<Object[]> list = new ArrayList<Object[]>();
                                                    list.add(new Object[]{this.val$stime});
                                                    list.add(this.val$final_args);
                                                    Config.last_rollback.put(this.val$player2.getName(), list);
                                                }
                                            }
                                        } else {
                                            this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- User \"" + baduser + "\" not found.");
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        this.val$player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (Config.active_rollbacks.get(this.val$player2.getName()) != null) {
                                    Config.active_rollbacks.remove(this.val$player2.getName());
                                }
                            }
                        }
                        BasicThread2 runnable = new BasicThread2(final_action, location_final, rollbackusers2, euserlist, final_preview, player2, radius, final_arg_wid, noisy, final_arg_action, rtime, blist, elist, stime, final_args);
                        Thread thread = new Thread(runnable);
                        thread.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (final_action == 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please specify the amount of time to rollback.");
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please specify the amount of time to restore.");
                }
            } else if (final_action == 0) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a rollback radius.");
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a restore radius.");
            }
        } else {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
        }
    }
}

