/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.consumer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.database.Database;
import net.coreprotect.database.Logger;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Process {
    public static void processConsumer(int process_id) {
        try {
            Connection connection = Database.getConnection(false);
            if (connection == null) {
                return;
            }
            Consumer.is_paused = true;
            Statement statement = connection.createStatement();
            ArrayList<Integer[]> consumer_data = Consumer.consumer.get(process_id);
            Map<Integer, String> users = Consumer.consumer_users.get(process_id);
            Map<Integer, Object> blocks = Consumer.consumer_object.get(process_id);
            Database.beginTransaction(statement);
            Iterator<Map.Entry<Integer, String>> it = users.entrySet().iterator();
            while (it.hasNext()) {
                String user = it.next().getValue();
                if (Config.player_id_cache.get(user.toLowerCase()) != null) continue;
                Database.loadUserID(connection, user);
            }
            Database.commitTransaction(statement);
            PreparedStatement preparedStmt_signs = Database.prepareStatement(connection, 0, false);
            PreparedStatement preparedStmt_blocks = Database.prepareStatement(connection, 1, false);
            PreparedStatement preparedStmt_skulls = Database.prepareStatement(connection, 2, true);
            PreparedStatement preparedStmt_containers = Database.prepareStatement(connection, 3, false);
            PreparedStatement preparedStmt_worlds = Database.prepareStatement(connection, 4, false);
            PreparedStatement preparedStmt_chat = Database.prepareStatement(connection, 5, false);
            PreparedStatement preparedStmt_command = Database.prepareStatement(connection, 6, false);
            PreparedStatement preparedStmt_session = Database.prepareStatement(connection, 7, false);
            PreparedStatement preparedStmt_entities = Database.prepareStatement(connection, 8, true);
            Database.beginTransaction(statement);
            int i = 0;
            while (i < consumer_data.size()) {
                Integer[] data = consumer_data.get(i);
                if (data != null) {
                    int id = data[0];
                    int action = data[1];
                    int block_type = data[2];
                    int block_data = data[3];
                    int replace_type = data[4];
                    int replace_data = data[5];
                    int force_data = data[6];
                    if (users.get(id) != null && blocks.get(id) != null) {
                        String user = users.get(id);
                        Object object = blocks.get(id);
                        try {
                            switch (action) {
                                case 0: {
                                    Process.processBlockBreak(preparedStmt_blocks, preparedStmt_skulls, process_id, id, block_type, block_data, replace_type, force_data, user, object);
                                    break;
                                }
                                case 1: {
                                    Process.processBlockPlace(preparedStmt_blocks, preparedStmt_skulls, block_type, block_data, replace_type, replace_data, force_data, user, object);
                                    break;
                                }
                                case 2: {
                                    Process.processSignText(preparedStmt_signs, process_id, id, force_data, user, object);
                                    break;
                                }
                                case 3: {
                                    Process.processContainerBreak(preparedStmt_containers, process_id, id, user, object);
                                    break;
                                }
                                case 4: {
                                    Process.processPlayerInteraction(preparedStmt_blocks, user, object);
                                    break;
                                }
                                case 5: {
                                    Process.processContainerTransaction(preparedStmt_containers, process_id, id, force_data, user, object);
                                    break;
                                }
                                case 6: {
                                    Process.processStructureGrowth(statement, preparedStmt_blocks, process_id, id, user, object);
                                    break;
                                }
                                case 7: {
                                    Process.processRollbackUpdate(statement, process_id, id, force_data, 0);
                                    break;
                                }
                                case 8: {
                                    Process.processRollbackUpdate(statement, process_id, id, force_data, 1);
                                    break;
                                }
                                case 9: {
                                    Process.processWorldInsert(preparedStmt_worlds, user, force_data);
                                    break;
                                }
                                case 10: {
                                    Process.processSignUpdate(statement, object, block_data, force_data);
                                    break;
                                }
                                case 11: {
                                    Process.processSkullUpdate(statement, object, force_data);
                                    break;
                                }
                                case 12: {
                                    Process.processPlayerChat(preparedStmt_chat, process_id, id, force_data, user);
                                    break;
                                }
                                case 13: {
                                    Process.processPlayerCommand(preparedStmt_command, process_id, id, force_data, user);
                                    break;
                                }
                                case 14: {
                                    Process.processPlayerSession(preparedStmt_session, object, force_data, user, 1);
                                    break;
                                }
                                case 15: {
                                    Process.processPlayerSession(preparedStmt_session, object, force_data, user, 0);
                                    break;
                                }
                                case 16: {
                                    Process.processEntityKill(preparedStmt_blocks, preparedStmt_entities, process_id, id, object, user, force_data);
                                    break;
                                }
                                case 17: {
                                    Process.processEntitySpawn(statement, object, block_type, force_data);
                                    break;
                                }
                                case 18: {
                                    Process.processHangingRemove(object, force_data);
                                    break;
                                }
                                case 19: {
                                    Process.processHangingSpawn(object, block_type, block_data, force_data);
                                    break;
                                }
                                case 20: {
                                    Process.processNaturalBlockBreak(statement, preparedStmt_blocks, process_id, id, user, object, block_type, block_data);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        users.remove(id);
                        blocks.remove(id);
                    }
                }
                ++i;
            }
            Database.commitTransaction(statement);
            Consumer.is_paused = false;
            consumer_data.clear();
            preparedStmt_signs.close();
            preparedStmt_blocks.close();
            preparedStmt_skulls.close();
            preparedStmt_containers.close();
            preparedStmt_worlds.close();
            preparedStmt_chat.close();
            preparedStmt_command.close();
            preparedStmt_session.close();
            preparedStmt_entities.close();
            statement.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Consumer.is_paused = false;
    }

    private static void processBlockBreak(PreparedStatement preparedStmt, PreparedStatement preparedStmt_skulls, int process_id, int id, int block_type, int block_data, int replace_type, int force_data, String user, Object object) {
        BlockState block = (BlockState)object;
        List<Object> meta = Functions.processMeta(block);
        if (block_type == 144) {
            Logger.log_skull_break(preparedStmt, preparedStmt_skulls, user, block);
        } else {
            Logger.log_break(preparedStmt, user, block.getLocation(), block_type, block_data, meta);
            if (force_data == 5 && (block_type == 64 || block_type == 71) && replace_type != 64 && replace_type != 71) {
                int d = block_data;
                if (block_data < 9) {
                    d = block_data + 8;
                }
                Location location = block.getLocation();
                location.setY(location.getY() + 1.0);
                Logger.log_break(preparedStmt, user, location, block_type, d, null);
            }
        }
    }

    private static void processBlockPlace(PreparedStatement preparedStmt, PreparedStatement preparedStmt_skulls, int block_type, int block_data, int replace_type, int replace_data, int force_data, String user, Object object) {
        BlockState block = (BlockState)object;
        if (block_type == 144) {
            Logger.log_skull_place(preparedStmt, preparedStmt_skulls, user, block, replace_type, replace_data);
        } else if (force_data == 1) {
            Logger.log_place(preparedStmt, user, block, replace_type, replace_data, block_type, block_data, true);
        } else {
            Logger.log_place(preparedStmt, user, block, replace_type, replace_data, block_type, block_data, false);
        }
    }

    private static void processSignText(PreparedStatement preparedStmt, int process_id, int id, int force_data, String user, Object object) {
        BlockState block = (BlockState)object;
        Map<Integer, String[]> signs = Consumer.consumer_signs.get(process_id);
        if (signs.get(id) != null) {
            String[] sign_text = signs.get(id);
            Logger.sign_text(preparedStmt, user, block, sign_text[0], sign_text[1], sign_text[2], sign_text[3], force_data);
            signs.remove(id);
        }
    }

    private static void processContainerBreak(PreparedStatement preparedStmt, int process_id, int id, String user, Object object) {
        BlockState block = (BlockState)object;
        Map<Integer, ItemStack[]> containers = Consumer.consumer_containers.get(process_id);
        if (containers.get(id) != null) {
            ItemStack[] container = containers.get(id);
            Logger.log_container_break(preparedStmt, user, block.getLocation(), container);
            containers.remove(id);
        }
    }

    private static void processPlayerInteraction(PreparedStatement preparedStmt, String user, Object object) {
        BlockState block = (BlockState)object;
        Logger.log_interact(preparedStmt, user, block);
    }

    private static void processContainerTransaction(PreparedStatement preparedStmt, int process_id, int id, int force_data, String user, Object object) {
        BlockState block = (BlockState)object;
        Map<Integer, Inventory> inventories = Consumer.consumer_inventories.get(process_id);
        if (inventories.get(id) != null) {
            Inventory inventory = inventories.get(id);
            String logging_chest_id = String.valueOf(user.toLowerCase()) + "." + block.getX() + "." + block.getY() + "." + block.getZ();
            if (Config.logging_chest.get(logging_chest_id) != null) {
                int current_chest = Config.logging_chest.get(logging_chest_id);
                if (Config.old_container.get(logging_chest_id) == null) {
                    return;
                }
                int force_size = 0;
                if (Config.force_containers.get(logging_chest_id) != null) {
                    force_size = Config.force_containers.get(logging_chest_id).size();
                }
                if (current_chest == force_data || force_size > 0) {
                    Logger.log_container(preparedStmt, user, inventory, block.getLocation());
                    List<ItemStack[]> old = Config.old_container.get(logging_chest_id);
                    if (old.size() == 0) {
                        Config.old_container.remove(logging_chest_id);
                        Config.logging_chest.remove(logging_chest_id);
                    }
                }
            }
            inventories.remove(id);
        }
    }

    private static void processStructureGrowth(Statement statement, PreparedStatement preparedStmt, int process_id, int id, String user, Object object) {
        BlockState block = (BlockState)object;
        Map<Integer, List<BlockState>> block_lists = Consumer.consumer_block_list.get(process_id);
        if (block_lists.get(id) != null) {
            List<BlockState> block_list = block_lists.get(id);
            String result_data = Lookup.who_placed(statement, block);
            if (result_data.length() > 0) {
                user = result_data;
            }
            for (BlockState list_block : block_list) {
                if (list_block.getY() < block.getY()) continue;
                Logger.log_place(preparedStmt, user, list_block, 0, 0, -1, -1, false);
            }
            block_lists.remove(id);
        }
    }

    private static void processRollbackUpdate(Statement statement, int process_id, int id, int action, int table) {
        Map<Integer, List<Object[]>> update_lists = Consumer.consumer_object_array_list.get(process_id);
        if (update_lists.get(id) != null) {
            List<Object[]> list = update_lists.get(id);
            for (Object[] list_row : list) {
                int rowid = (Integer)list_row[0];
                int rolled_back = (Integer)list_row[9];
                if (rolled_back != action) continue;
                Database.performUpdate(statement, rowid, action, table);
            }
            update_lists.remove(id);
        }
    }

    private static void processWorldInsert(PreparedStatement preparedStmt, String world, int world_id) {
        Database.insertWorld(preparedStmt, world_id, world);
    }

    private static void processSignUpdate(Statement statement, Object object, int action, int time) {
        BlockState block = (BlockState)object;
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        int wid = Functions.getWorldId(block.getWorld().getName());
        String query = "";
        query = action == 0 ? "SELECT line_1, line_2, line_3, line_4 FROM " + Config.prefix + "sign WHERE wid='" + wid + "' AND x='" + x + "' AND z='" + z + "' AND y='" + y + "' AND time < '" + time + "' ORDER BY rowid DESC LIMIT 0, 1" : "SELECT line_1, line_2, line_3, line_4 FROM " + Config.prefix + "sign WHERE wid='" + wid + "' AND x='" + x + "' AND z='" + z + "' AND y='" + y + "' AND time >= '" + time + "' ORDER BY rowid ASC LIMIT 0, 1";
        Database.getSignData(statement, block, query);
        Functions.updateBlock(block);
    }

    private static void processSkullUpdate(Statement statement, Object object, int row_id) {
        BlockState block = (BlockState)object;
        String query = "SELECT type,data,rotation,owner FROM " + Config.prefix + "skull WHERE rowid='" + row_id + "' LIMIT 0, 1";
        Database.getSkullData(statement, block, query);
        Functions.updateBlock(block);
    }

    private static void processPlayerChat(PreparedStatement preparedStmt, int process_id, int id, int time, String user) {
        Map<Integer, String> strings = Consumer.consumer_strings.get(process_id);
        if (strings.get(id) != null) {
            String message = strings.get(id);
            Logger.log_chat(preparedStmt, time, user, message);
            strings.remove(id);
        }
    }

    private static void processPlayerCommand(PreparedStatement preparedStmt, int process_id, int id, int time, String user) {
        Map<Integer, String> strings = Consumer.consumer_strings.get(process_id);
        if (strings.get(id) != null) {
            String message = strings.get(id);
            Logger.log_command(preparedStmt, time, user, message);
            strings.remove(id);
        }
    }

    private static void processPlayerSession(PreparedStatement preparedStmt, Object object, int time, String user, int action) {
        BlockState block = (BlockState)object;
        Logger.log_session(preparedStmt, user, block, time, action);
    }

    private static void processEntityKill(PreparedStatement preparedStmt, PreparedStatement preparedStmt_entities, int process_id, int id, Object object, String user, int type) {
        BlockState block = (BlockState)object;
        Map<Integer, List<Object>> object_lists = Consumer.consumer_object_list.get(process_id);
        if (object_lists.get(id) != null) {
            List<Object> object_list = object_lists.get(id);
            Logger.log_entity_kill(preparedStmt, preparedStmt_entities, user, block, object_list, type);
            object_lists.remove(id);
        }
    }

    private static void processEntitySpawn(Statement statement, Object object, int type, int row_id) {
        BlockState block = (BlockState)object;
        String query = "SELECT data FROM " + Config.prefix + "entity WHERE rowid='" + row_id + "' LIMIT 0, 1";
        List<Object> data = Database.getEntityData(statement, block, query);
        Functions.spawnEntity(block, type, data);
    }

    private static void processHangingRemove(Object object, int delay) {
        BlockState block = (BlockState)object;
        Functions.removeHanging(block, delay);
    }

    private static void processHangingSpawn(Object object, int type, int data, int delay) {
        BlockState block = (BlockState)object;
        Functions.spawnHanging(block, type, data, delay);
    }

    private static void processNaturalBlockBreak(Statement statement, PreparedStatement preparedStmt, int process_id, int id, String user, Object object, int block_type, int block_data) {
        BlockState block = (BlockState)object;
        Map<Integer, List<BlockState>> block_lists = Consumer.consumer_block_list.get(process_id);
        if (block_lists.get(id) != null) {
            List<BlockState> block_list = block_lists.get(id);
            for (BlockState list_block : block_list) {
                String removed = Lookup.who_removed_cache(list_block);
                if (removed.length() <= 0) continue;
                user = removed;
            }
            block_lists.remove(id);
            Logger.log_break(preparedStmt, user, block.getLocation(), block_type, block_data, null);
        }
    }
}

