/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.consumer;

import java.util.ArrayList;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Queue {
    private static void queueStandardData(int consumer_id, String user, Object object) {
        Consumer.consumer_users.get(Consumer.current_consumer).put(consumer_id, user);
        Consumer.consumer_object.get(Consumer.current_consumer).put(consumer_id, object);
        Consumer.consumer_id.put(Consumer.current_consumer, consumer_id + 1);
    }

    protected static void queuePlayerInteraction(String user, BlockState block) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 4, 0, 0, 0, 0, 0});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueSignText(String user, BlockState block, String line1, String line2, String line3, String line4, int offset) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 2, 0, 0, 0, 0, offset});
        Consumer.consumer_signs.get(Consumer.current_consumer).put(consumer_id, new String[]{line1, line2, line3, line4});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueStructureGrow(String user, BlockState block, List<BlockState> block_list) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 6, 0, 0, 0, 0, 0});
        Consumer.consumer_block_list.get(Consumer.current_consumer).put(consumer_id, block_list);
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueContainerTransaction(String user, BlockState block, Inventory inventory, int chest_id) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 5, 0, 0, 0, 0, chest_id});
        Consumer.consumer_inventories.get(Consumer.current_consumer).put(consumer_id, inventory);
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueContainerBreak(String user, BlockState block, ItemStack[] old_inventory) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 3, 0, 0, 0, 0, 0});
        Consumer.consumer_containers.get(Consumer.current_consumer).put(consumer_id, old_inventory);
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueBlockPlace(String user, BlockState block_location, Block block_type, BlockState block_replaced, int force_t, int force_d, int force_data) {
        int type = block_type.getTypeId();
        int data = block_type.getData();
        int replace_type = 0;
        byte replace_data = 0;
        if (type == 52) {
            CreatureSpawner mobSpawner = (CreatureSpawner)block_location;
            data = Functions.getSpawnerType(mobSpawner.getSpawnedType());
            force_data = 1;
        }
        if (block_replaced != null) {
            replace_type = block_replaced.getTypeId();
            replace_data = block_replaced.getData().getData();
        }
        if (force_t > -1) {
            type = force_t;
            force_data = 1;
        }
        if (force_d > -1) {
            data = force_d;
            force_data = 1;
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 1, type, data, replace_type, replace_data, force_data});
        Queue.queueStandardData(consumer_id, user, block_location);
    }

    protected static void queueBlockPlaceDelayed(final String user, final Block placed, final BlockState replaced, int ticks) {
        CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    Queue.queueBlockPlace(user, placed.getState(), placed, replaced, -1, -1, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long)ticks);
    }

    protected static void queueBlockPlace(String user, BlockState placed, BlockState replaced, int force_type) {
        Queue.queueBlockPlace(user, placed, placed.getBlock(), replaced, force_type, -1, 0);
    }

    protected static void queueBlockPlace(Player player, BlockState final_placed, Block placed, BlockState replaced, int force_t, int force_d) {
        Queue.queueBlockPlace(player.getName(), final_placed, placed, replaced, force_t, force_d, 0);
    }

    protected static void queueBlockPlace(String player, BlockState placed, int type, int data) {
        Queue.queueBlockPlace(player, placed, placed.getBlock(), null, type, data, 1);
    }

    protected static void queueBlockPlace(String player, Block placed, BlockState replaced, int force) {
        Queue.queueBlockPlace(player, placed.getState(), placed, replaced, -1, -1, force);
    }

    protected static void queueBlockPlace(String player, Block placed) {
        Queue.queueBlockPlace(player, placed.getState(), placed, null, -1, -1, 0);
    }

    protected static void queueBlockPlace(String user, Block placed, BlockState replaced, int type, int data) {
        Queue.queueBlockPlace(user, placed.getState(), placed, replaced, type, data, 1);
    }

    protected static void queueBlockBreak(String user, BlockState block, int type, int data, int break_type, int block_number) {
        if (type == 52) {
            CreatureSpawner mobSpawner = (CreatureSpawner)block;
            data = Functions.getSpawnerType(mobSpawner.getSpawnedType());
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 0, type, data, break_type, 0, block_number});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueBlockBreak(String user, BlockState block, int type, int data) {
        Queue.queueBlockBreak(user, block, type, data, 0, 0);
    }

    protected static void queueSkullBreak(String user, BlockState block, int type, int data, int break_type, int block_number) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 0, type, data, break_type, 0, block_number});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueRollbackUpdate(String user, Location location, List<Object[]> list, int action) {
        if (location == null) {
            location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 7, 0, 0, 0, 0, action});
        Consumer.consumer_object_array_list.get(Consumer.current_consumer).put(consumer_id, list);
        Queue.queueStandardData(consumer_id, user, location);
    }

    protected static void queueContainerRollbackUpdate(String user, Location location, List<Object[]> list, int action) {
        if (location == null) {
            location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 8, 0, 0, 0, 0, action});
        Consumer.consumer_object_array_list.get(Consumer.current_consumer).put(consumer_id, list);
        Queue.queueStandardData(consumer_id, user, location);
    }

    protected static void queueWorldInsert(int id, String world) {
        Location location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 9, 0, 0, 0, 0, id});
        Queue.queueStandardData(consumer_id, world, location);
    }

    protected static void queueSignUpdate(String user, BlockState block, int action, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 10, 0, action, 0, 0, time});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueSkullUpdate(String user, BlockState block, int row_id) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 11, 0, 0, 0, 0, row_id});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queuePlayerChat(Player player, String message, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 12, 0, 0, 0, 0, time});
        Consumer.consumer_strings.get(Consumer.current_consumer).put(consumer_id, message);
        Queue.queueStandardData(consumer_id, player.getName(), player.getLocation());
    }

    protected static void queuePlayerCommand(Player player, String message, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 13, 0, 0, 0, 0, time});
        Consumer.consumer_strings.get(Consumer.current_consumer).put(consumer_id, message);
        Queue.queueStandardData(consumer_id, player.getName(), player.getLocation().getBlock().getState());
    }

    protected static void queuePlayerLogin(Player player, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 14, 0, 0, 0, 0, time});
        Queue.queueStandardData(consumer_id, player.getName(), player.getLocation().getBlock().getState());
    }

    protected static void queuePlayerQuit(Player player, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 15, 0, 0, 0, 0, time});
        Queue.queueStandardData(consumer_id, player.getName(), player.getLocation().getBlock().getState());
    }

    protected static void queueEntityKill(String user, Location location, List<Object> data, int type) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 16, 0, 0, 0, 0, type});
        Consumer.consumer_object_list.get(Consumer.current_consumer).put(consumer_id, data);
        Queue.queueStandardData(consumer_id, user, location.getBlock().getState());
    }

    protected static void queueEntitySpawn(String user, BlockState block, int type, int data) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 17, type, 0, 0, 0, data});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueHangingRemove(String user, BlockState block, int delay) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 18, 0, 0, 0, 0, delay});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueHangingSpawn(String user, BlockState block, int type, int data, int delay) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 19, type, data, 0, 0, delay});
        Queue.queueStandardData(consumer_id, user, block);
    }

    protected static void queueNaturalBlockBreak(String user, BlockState block, Block relative, int type, int data) {
        ArrayList<BlockState> relative_list = new ArrayList<BlockState>();
        if (relative != null) {
            relative_list.add(relative.getState());
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Integer[]{consumer_id, 20, type, data, 0, 0, 0});
        Consumer.consumer_block_list.get(Consumer.current_consumer).put(consumer_id, relative_list);
        Queue.queueStandardData(consumer_id, user, block);
    }
}

