/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.convert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.database.Database;
import net.coreprotect.model.Config;

public class Converter
extends Consumer {
    public static CoreProtect plugin;

    public Converter(CoreProtect instance) {
        plugin = instance;
    }

    public static void processConsumer() {
        try {
            Functions.messageOwner("Processing new data. Please wait...");
            Consumer.is_paused = false;
            Thread consumerThread = new Thread(new Consumer());
            consumerThread.start();
            Thread.sleep(1000L);
            while (Consumer.is_paused) {
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteDirectory(String directory) {
        try {
            File dir = new File("plugins/CoreData/" + directory);
            if (dir.exists()) {
                String[] children = dir.list();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        String filename = children[i];
                        if (!filename.startsWith(".") && filename.contains(".dat")) {
                            File oldf = new File("plugins/CoreData/" + directory + "/" + filename);
                            oldf.delete();
                        }
                        ++i;
                    }
                }
                dir.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stage1() {
        try {
            boolean exists;
            File old_file = new File("plugins/CoreData/.license");
            if (old_file.exists()) {
                old_file.delete();
            }
            if ((old_file = new File("plugins/CoreData/config.yml")).exists()) {
                File new_file = new File("plugins/CoreProtect/config.yml");
                old_file.renameTo(new_file);
                new_file = new File("plugins/CoreProtect/config.yml");
                BufferedReader reader = new BufferedReader(new FileReader(new_file));
                String line = "";
                String oldtext = "";
                while ((line = reader.readLine()) != null) {
                    oldtext = String.valueOf(oldtext) + line + "\n";
                }
                reader.close();
                String newtext = oldtext.replaceAll("noisy-default", "verbose").replaceAll("noisy", "#verbose");
                newtext = newtext.replaceAll("player-interact:", "player-interactions:");
                FileWriter writer = new FileWriter("plugins/CoreProtect/config.yml");
                writer.write(newtext);
                writer.close();
            }
            if (exists = new File("plugins/CoreData/blacklist.txt").exists()) {
                old_file = new File("plugins/CoreData/blacklist.txt");
                File new_file = new File("plugins/CoreProtect/blacklist.txt");
                old_file.renameTo(new_file);
            }
            Config.loadConfig();
            if (Config.config.get("use-mysql") == 1) {
                boolean success;
                block17: {
                    success = false;
                    try {
                        PreparedStatement preparedStmt;
                        String query;
                        Connection connection = Database.getConnection(true);
                        if (connection == null) break block17;
                        try {
                            query = "DROP TABLE " + Config.prefix + "players";
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            query = "RENAME TABLE " + Config.prefix + "signs TO " + Config.prefix + "old_signs";
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                            query = "RENAME TABLE " + Config.prefix + "blocks TO " + Config.prefix + "old_blocks";
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                            query = "RENAME TABLE " + Config.prefix + "containers TO " + Config.prefix + "old_containers";
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        connection.close();
                        success = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!success) {
                    Config.config.put("use-mysql", 0);
                }
            }
            Config.loadDatabase();
            old_file = new File("plugins/CoreData/core.dat");
            if (old_file.exists()) {
                Connection connection = Database.getConnection(true);
                PreparedStatement preparedStmt = Database.prepareStatement(connection, 4, false);
                RandomAccessFile file = new RandomAccessFile("plugins/CoreData/core.dat", "rw");
                file.seek(0L);
                while (file.getFilePointer() < file.length()) {
                    String line = file.readUTF();
                    String[] data = line.split(",");
                    String dworld = data[0];
                    int did = Integer.parseInt(data[1]);
                    if (did > Config.world_id) {
                        Config.world_id = did;
                    }
                    Config.worlds.put(dworld, did);
                    Config.worlds_reversed.put(did, dworld);
                    Database.insertWorld(preparedStmt, did, dworld);
                }
                file.close();
                old_file.delete();
                preparedStmt.close();
                connection.close();
            }
            Functions.messageOwner("The upgrade is now running in the background.");
            Functions.messageOwner("Resuming server startup...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean stage2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void finishConversion() {
        try {
            File dir = new File("plugins/CoreData");
            String[] children = dir.list();
            if (children != null && children.length == 0) {
                dir.delete();
            }
            File delete = new File("plugins/CoreProtect/convert.tmp");
            delete.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void performUpgrade() {
        try {
            boolean in_progress = new File("plugins/CoreProtect/convert.tmp").exists();
            boolean old_data = new File("plugins/CoreData/core.dat").exists();
            if (in_progress || old_data) {
                int stage;
                Config.converter_running = true;
                Consumer.is_paused = true;
                Functions.messageOwner("-----");
                Functions.messageOwner("Upgrade starting. This may take some time.");
                Functions.messageOwner("Do not restart your server until completed.");
                Functions.messageOwner("-----");
                int completed_stage = 0;
                if (in_progress) {
                    RandomAccessFile file = new RandomAccessFile("plugins/CoreProtect/convert.tmp", "rw");
                    file.seek(0L);
                    completed_stage = file.readInt();
                    file.close();
                }
                if (completed_stage > 0) {
                    Config.loadConfig();
                }
                if ((stage = completed_stage + 1) == 1) {
                    Converter.stage1();
                    RandomAccessFile file = new RandomAccessFile("plugins/CoreProtect/convert.tmp", "rw");
                    file.seek(0L);
                    file.writeInt(stage);
                    file.close();
                }
                class Stage2
                implements Runnable {
                    Stage2() {
                    }

                    @Override
                    public void run() {
                        try {
                            boolean finished = Converter.stage2();
                            if (finished) {
                                Converter.finishConversion();
                                Config.converter_running = false;
                                Converter.processConsumer();
                                Functions.messageOwner("-----");
                                Functions.messageOwner("Upgrade successfully completed.");
                                Functions.messageOwner("-----");
                            } else {
                                Functions.messageOwner("-----");
                                Functions.messageOwner("Upgrade interrupted. Will resume on restart.");
                                Functions.messageOwner("-----");
                                Config.consumer_running = false;
                            }
                            Config.converter_running = false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Thread stage2Thread = new Thread(new Stage2());
                stage2Thread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

