/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coreprotect.Functions;
import net.coreprotect.database.Database;
import net.coreprotect.model.Config;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class Logger {
    public static void log_entity_kill(PreparedStatement preparedStmt, PreparedStatement preparedStmt2, String user, BlockState block, List<Object> data, int type) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            int wid = Functions.getWorldId(block.getWorld().getName());
            int time = (int)(System.currentTimeMillis() / 1000L);
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int userid = Config.player_id_cache.get(user.toLowerCase());
            Database.insertEntity(preparedStmt2, time, data);
            ResultSet keys = preparedStmt2.getGeneratedKeys();
            keys.next();
            int entity_key = keys.getInt(1);
            keys.close();
            Database.insertBlock(preparedStmt, time, userid, wid, x, y, z, type, entity_key, null, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_chat(PreparedStatement preparedStmt, int time, String user, String message) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            int userid = Config.player_id_cache.get(user.toLowerCase());
            Database.insertChat(preparedStmt, time, userid, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_command(PreparedStatement preparedStmt, int time, String user, String message) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            if (Config.blacklist.get((String.valueOf(message) + " ").split(" ")[0].toLowerCase()) != null) {
                return;
            }
            int userid = Config.player_id_cache.get(user.toLowerCase());
            Database.insertCommand(preparedStmt, time, userid, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_session(PreparedStatement preparedStmt, String user, BlockState block, int time, int action) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int wid = Functions.getWorldId(block.getWorld().getName());
            int userid = Config.player_id_cache.get(user.toLowerCase());
            Database.insertSession(preparedStmt, time, userid, wid, x, y, z, action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sign_text(PreparedStatement preparedStmt, String user, BlockState block, String line1, String line2, String line3, String line4, int time_offset) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            int userid = Config.player_id_cache.get(user.toLowerCase());
            int wid = Functions.getWorldId(block.getWorld().getName());
            int time = (int)(System.currentTimeMillis() / 1000L) - time_offset;
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            Database.insertSign(preparedStmt, time, userid, wid, x, y, z, line1, line2, line3, line4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_skull_place(PreparedStatement preparedStmt, PreparedStatement preparedStmt2, String user, BlockState block, int replace_type, int replace_data) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null || block == null) {
                return;
            }
            int time = (int)(System.currentTimeMillis() / 1000L);
            int type = block.getTypeId();
            Skull skull = (Skull)block;
            String skull_owner = "";
            int skull_type = Functions.getSkullType(skull.getSkullType());
            int skull_rotation = Functions.getBlockFace(skull.getRotation());
            if (skull.hasOwner()) {
                skull_owner = skull.getOwner();
            }
            byte skull_data = skull.getRawData();
            Database.insertSkull(preparedStmt2, time, skull_type, skull_data, skull_rotation, skull_owner);
            ResultSet keys = preparedStmt2.getGeneratedKeys();
            keys.next();
            int skull_key = keys.getInt(1);
            keys.close();
            Logger.log_place(preparedStmt, user, block, replace_type, replace_data, type, skull_key, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_skull_break(PreparedStatement preparedStmt, PreparedStatement preparedStmt2, String user, BlockState block) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null || block == null) {
                return;
            }
            int time = (int)(System.currentTimeMillis() / 1000L);
            int type = block.getTypeId();
            Skull skull = (Skull)block;
            String skull_owner = "";
            int skull_type = Functions.getSkullType(skull.getSkullType());
            int skull_rotation = Functions.getBlockFace(skull.getRotation());
            if (skull.hasOwner()) {
                skull_owner = skull.getOwner();
            }
            byte skull_data = skull.getRawData();
            Database.insertSkull(preparedStmt2, time, skull_type, skull_data, skull_rotation, skull_owner);
            ResultSet keys = preparedStmt2.getGeneratedKeys();
            keys.next();
            int skull_key = keys.getInt(1);
            keys.close();
            Logger.log_break(preparedStmt, user, block.getLocation(), type, skull_key, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_break(PreparedStatement preparedStmt, String user, Location location, int type, int data, List<Object> meta) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null || type == 0 || location == null) {
                return;
            }
            int wid = Functions.getWorldId(location.getWorld().getName());
            int time = (int)(System.currentTimeMillis() / 1000L);
            int x = location.getBlockX();
            int y = location.getBlockY();
            int z = location.getBlockZ();
            Config.break_cache.put(x + "." + y + "." + z + "." + wid, new Object[]{time, user, type});
            int userid = Config.player_id_cache.get(user.toLowerCase());
            Database.insertBlock(preparedStmt, time, userid, wid, x, y, z, type, data, meta, 0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_place(PreparedStatement preparedStmt, String user, BlockState block, int replaced_type, int replaced_data, int force_type, int force_data, boolean force) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            int type = block.getTypeId();
            int data = block.getData().getData();
            if (force_type > -1 && force) {
                type = force_type;
                if (type == 52 || type == 321 || type == 389 || type == 144) {
                    data = force_data;
                } else if (user.startsWith("#")) {
                    data = force_data;
                }
            } else if (force_type > -1 && type != force_type) {
                type = force_type;
                data = force_data;
            }
            if (type == 0) {
                return;
            }
            int userid = Config.player_id_cache.get(user.toLowerCase());
            int wid = Functions.getWorldId(block.getWorld().getName());
            int time = (int)(System.currentTimeMillis() / 1000L);
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int dx = x;
            int dy = y;
            int dz = z;
            int doubletype = type;
            int doubledata = data;
            boolean logdouble = false;
            if (user.length() > 0) {
                Config.lookup_cache.put(x + "." + y + "." + z + "." + wid, new Object[]{time, user, type});
            }
            if (type == 26 || type == 64 || type == 71) {
                if (type == 26) {
                    doubledata = data + 8;
                    if (data == 0) {
                        dz = z + 1;
                    } else if (data == 1) {
                        dx = x - 1;
                    } else if (data == 2) {
                        dz = z - 1;
                    } else if (data == 3) {
                        dx = x + 1;
                    }
                } else if ((type == 64 || type == 71) && data < 9) {
                    dy = y + 1;
                    doubledata = data + 8;
                }
                logdouble = true;
            }
            if (replaced_type > 0) {
                Database.insertBlock(preparedStmt, time, userid, wid, x, y, z, replaced_type, replaced_data, null, 0, 0);
            }
            Database.insertBlock(preparedStmt, time, userid, wid, x, y, z, type, data, null, 1, 0);
            if (logdouble) {
                Database.insertBlock(preparedStmt, time, userid, wid, dx, dy, dz, doubletype, doubledata, null, 1, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_interact(PreparedStatement preparedStmt, String user, BlockState block) {
        try {
            int type = block.getTypeId();
            if (Config.blacklist.get(user.toLowerCase()) != null || type == 0) {
                return;
            }
            int wid = Functions.getWorldId(block.getWorld().getName());
            int userid = Config.player_id_cache.get(user.toLowerCase());
            int time = (int)(System.currentTimeMillis() / 1000L);
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            byte data = block.getData().getData();
            Database.insertBlock(preparedStmt, time, userid, wid, x, y, z, type, data, null, 2, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_container_break(PreparedStatement preparedStmt, String player, Location l, ItemStack[] old_inventory) {
        try {
            Functions.combine_items(old_inventory);
            Logger.container_logger(preparedStmt, player, old_inventory, 0, l);
            String logging_container_id = String.valueOf(player.toLowerCase()) + "." + l.getBlockX() + "." + l.getBlockY() + "." + l.getBlockZ();
            if (Config.force_containers.get(logging_container_id) != null) {
                Config.force_containers.remove(logging_container_id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log_container(PreparedStatement preparedStmt, String player, Inventory inventory, Location l) {
        try {
            String logging_container_id = String.valueOf(player.toLowerCase()) + "." + l.getBlockX() + "." + l.getBlockY() + "." + l.getBlockZ();
            List<ItemStack[]> old_list = Config.old_container.get(logging_container_id);
            ItemStack[] oi1 = old_list.get(0);
            ItemStack[] old_inventory = Functions.get_container_state(oi1);
            ItemStack[] new_inventory = Functions.get_container_state(inventory.getContents());
            if (Config.force_containers.get(logging_container_id) != null) {
                List<ItemStack[]> force_list = Config.force_containers.get(logging_container_id);
                new_inventory = Functions.get_container_state(force_list.get(0));
                force_list.remove(0);
                if (force_list.size() == 0) {
                    Config.force_containers.remove(logging_container_id);
                } else {
                    Config.force_containers.put(logging_container_id, force_list);
                }
            }
            ItemStack[] itemStackArray = old_inventory;
            int n = old_inventory.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack oldi = itemStackArray[n2];
                ItemStack[] itemStackArray2 = new_inventory;
                int n3 = new_inventory.length;
                int n4 = 0;
                while (n4 < n3) {
                    ItemStack newi = itemStackArray2[n4];
                    if (oldi != null && newi != null && oldi.isSimilar(newi)) {
                        int oamount = oldi.getAmount();
                        int namount = newi.getAmount();
                        if (namount >= oamount) {
                            oldi.setAmount(0);
                            newi.setAmount(namount -= oamount);
                        } else {
                            oldi.setAmount(oamount -= namount);
                            newi.setAmount(0);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            Functions.combine_items(old_inventory);
            Functions.combine_items(new_inventory);
            Logger.container_logger(preparedStmt, player, old_inventory, 0, l);
            Logger.container_logger(preparedStmt, player, new_inventory, 1, l);
            old_list.remove(0);
            Config.old_container.put(logging_container_id, old_list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void container_logger(PreparedStatement preparedStmt, String user, ItemStack[] items, int action, Location l) {
        try {
            if (Config.blacklist.get(user.toLowerCase()) != null) {
                return;
            }
            ItemStack[] itemStackArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack i = itemStackArray[n2];
                if (i != null && i.getAmount() > 0) {
                    ArrayList<List<Map<String, Object>>> metadata = new ArrayList<List<Map<String, Object>>>();
                    ArrayList<Map> list = new ArrayList<Map>();
                    int hasEnchantments = 0;
                    int hasDisplayName = 0;
                    int hasLore = 0;
                    if (i.hasItemMeta()) {
                        if (i.getItemMeta() instanceof LeatherArmorMeta) {
                            LeatherArmorMeta meta = (LeatherArmorMeta)i.getItemMeta().clone();
                            LeatherArmorMeta sub_meta = meta.clone();
                            meta.setColor(null);
                            list.add(meta.serialize());
                            metadata.add(list);
                            list = new ArrayList();
                            list.add(sub_meta.getColor().serialize());
                            metadata.add(list);
                        } else if (i.getItemMeta() instanceof FireworkMeta) {
                            FireworkMeta meta = (FireworkMeta)i.getItemMeta().clone();
                            FireworkMeta sub_meta = meta.clone();
                            meta.clearEffects();
                            list.add(meta.serialize());
                            metadata.add(list);
                            if (sub_meta.hasEffects()) {
                                for (FireworkEffect effect : sub_meta.getEffects()) {
                                    Logger.getFireworkEffect(effect, metadata);
                                }
                            }
                        } else if (i.getItemMeta() instanceof PotionMeta) {
                            PotionMeta meta = (PotionMeta)i.getItemMeta().clone();
                            PotionMeta sub_meta = meta.clone();
                            meta.clearCustomEffects();
                            list.add(meta.serialize());
                            metadata.add(list);
                            if (sub_meta.hasCustomEffects()) {
                                for (PotionEffect effect : sub_meta.getCustomEffects()) {
                                    list = new ArrayList();
                                    list.add(effect.serialize());
                                    metadata.add(list);
                                }
                            }
                        } else if (i.getItemMeta() instanceof FireworkEffectMeta) {
                            FireworkEffectMeta meta = (FireworkEffectMeta)i.getItemMeta().clone();
                            FireworkEffectMeta sub_meta = meta.clone();
                            meta.setEffect(null);
                            list.add(meta.serialize());
                            metadata.add(list);
                            if (sub_meta.hasEffect()) {
                                FireworkEffect effect = sub_meta.getEffect();
                                Logger.getFireworkEffect(effect, metadata);
                            }
                        } else {
                            ItemMeta meta = i.getItemMeta().clone();
                            if (meta.hasEnchants()) {
                                hasEnchantments = 1;
                            }
                            if (meta.hasDisplayName()) {
                                hasDisplayName = 2;
                            }
                            if (meta.hasLore()) {
                                hasLore = 4;
                            }
                            list.add(meta.serialize());
                            metadata.add(list);
                        }
                    }
                    int meta = hasEnchantments + hasDisplayName + hasLore;
                    int wid = Functions.getWorldId(l.getWorld().getName());
                    int userid = Config.player_id_cache.get(user.toLowerCase());
                    int time = (int)(System.currentTimeMillis() / 1000L);
                    int x = l.getBlockX();
                    int y = l.getBlockY();
                    int z = l.getBlockZ();
                    int type = i.getTypeId();
                    short data = i.getDurability();
                    int amount = i.getAmount();
                    Database.insertContainer(preparedStmt, time, userid, wid, x, y, z, type, data, amount, meta, metadata, action, 0);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getFireworkEffect(FireworkEffect effect, List<List<Map<String, Object>>> metadata) {
        ArrayList<Map> color_list = new ArrayList<Map>();
        ArrayList<Map> fade_list = new ArrayList<Map>();
        ArrayList list = new ArrayList();
        for (Color color : effect.getColors()) {
            color_list.add(color.serialize());
        }
        for (Color color : effect.getFadeColors()) {
            fade_list.add(color.serialize());
        }
        HashMap<String, Boolean> has_check = new HashMap<String, Boolean>();
        has_check.put("flicker", effect.hasFlicker());
        has_check.put("trail", effect.hasTrail());
        list.add(has_check);
        metadata.add(list);
        metadata.add(color_list);
        metadata.add(fade_list);
    }
}

